/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexzhirkevich.customqrgenerator.style;

import androidx.annotation.FloatRange;
import com.github.alexzhirkevich.customqrgenerator.style.Neighbors;
import com.github.alexzhirkevich.customqrgenerator.style.QrBallShape;
import com.github.alexzhirkevich.customqrgenerator.style.QrShapeModifier;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\bf\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0004\u0003\u0004\u0005\u0006\u00a8\u0006\u0007"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/style/QrLogoShape;", "Lcom/github/alexzhirkevich/customqrgenerator/style/QrShapeModifier;", "", "Circle", "Default", "Rhombus", "RoundCorners", "custom_qr_generator_release"})
public interface QrLogoShape
extends QrShapeModifier<Boolean> {

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0096\u0002\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/style/QrLogoShape$Default;", "Lcom/github/alexzhirkevich/customqrgenerator/style/QrLogoShape;", "()V", "invoke", "", "i", "", "j", "elementSize", "qrPixelSize", "neighbors", "Lcom/github/alexzhirkevich/customqrgenerator/style/Neighbors;", "(IIIILcom/github/alexzhirkevich/customqrgenerator/style/Neighbors;)Ljava/lang/Boolean;", "custom_qr_generator_release"})
    public static final class Default
    implements QrLogoShape {
        @NotNull
        public static final Default INSTANCE = new Default();

        private Default() {
        }

        @Override
        @NotNull
        public Boolean invoke(int i, int j, int elementSize, int qrPixelSize, @NotNull Neighbors neighbors) {
            Intrinsics.checkNotNullParameter((Object)neighbors, (String)"neighbors");
            return true;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0096\u0002\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/style/QrLogoShape$Circle;", "Lcom/github/alexzhirkevich/customqrgenerator/style/QrLogoShape;", "()V", "invoke", "", "i", "", "j", "elementSize", "qrPixelSize", "neighbors", "Lcom/github/alexzhirkevich/customqrgenerator/style/Neighbors;", "(IIIILcom/github/alexzhirkevich/customqrgenerator/style/Neighbors;)Ljava/lang/Boolean;", "custom_qr_generator_release"})
    public static final class Circle
    implements QrLogoShape {
        @NotNull
        public static final Circle INSTANCE = new Circle();

        private Circle() {
        }

        @Override
        @NotNull
        public Boolean invoke(int i, int j, int elementSize, int qrPixelSize, @NotNull Neighbors neighbors) {
            Intrinsics.checkNotNullParameter((Object)neighbors, (String)"neighbors");
            return new QrBallShape.Circle(1.0f).invoke(i, j, elementSize, qrPixelSize, neighbors);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0096\u0002\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/style/QrLogoShape$Rhombus;", "Lcom/github/alexzhirkevich/customqrgenerator/style/QrLogoShape;", "()V", "invoke", "", "i", "", "j", "elementSize", "qrPixelSize", "neighbors", "Lcom/github/alexzhirkevich/customqrgenerator/style/Neighbors;", "(IIIILcom/github/alexzhirkevich/customqrgenerator/style/Neighbors;)Ljava/lang/Boolean;", "custom_qr_generator_release"})
    public static final class Rhombus
    implements QrLogoShape {
        @NotNull
        public static final Rhombus INSTANCE = new Rhombus();

        private Rhombus() {
        }

        @Override
        @NotNull
        public Boolean invoke(int i, int j, int elementSize, int qrPixelSize, @NotNull Neighbors neighbors) {
            Intrinsics.checkNotNullParameter((Object)neighbors, (String)"neighbors");
            return QrBallShape.Rhombus.INSTANCE.invoke(i, j, elementSize, qrPixelSize, neighbors);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B7\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ6\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0096\u0002\u00a2\u0006\u0002\u0010\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\r\u00a8\u0006\u001a"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/style/QrLogoShape$RoundCorners;", "Lcom/github/alexzhirkevich/customqrgenerator/style/QrLogoShape;", "corner", "", "outer", "", "horizontalOuter", "verticalOuter", "inner", "(FZZZZ)V", "getCorner", "()F", "getHorizontalOuter", "()Z", "getInner", "getOuter", "getVerticalOuter", "invoke", "i", "", "j", "elementSize", "qrPixelSize", "neighbors", "Lcom/github/alexzhirkevich/customqrgenerator/style/Neighbors;", "(IIIILcom/github/alexzhirkevich/customqrgenerator/style/Neighbors;)Ljava/lang/Boolean;", "custom_qr_generator_release"})
    public static final class RoundCorners
    implements QrLogoShape {
        private final float corner;
        private final boolean outer;
        private final boolean horizontalOuter;
        private final boolean verticalOuter;
        private final boolean inner;

        public RoundCorners(@FloatRange(from=0.0, to=0.5) float corner, boolean outer, boolean horizontalOuter, boolean verticalOuter, boolean inner) {
            this.corner = corner;
            this.outer = outer;
            this.horizontalOuter = horizontalOuter;
            this.verticalOuter = verticalOuter;
            this.inner = inner;
        }

        public /* synthetic */ RoundCorners(float f, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = true;
            }
            if ((n & 4) != 0) {
                bl2 = true;
            }
            if ((n & 8) != 0) {
                bl3 = true;
            }
            if ((n & 0x10) != 0) {
                bl4 = true;
            }
            this(f, bl, bl2, bl3, bl4);
        }

        public final float getCorner() {
            return this.corner;
        }

        public final boolean getOuter() {
            return this.outer;
        }

        public final boolean getHorizontalOuter() {
            return this.horizontalOuter;
        }

        public final boolean getVerticalOuter() {
            return this.verticalOuter;
        }

        public final boolean getInner() {
            return this.inner;
        }

        @Override
        @NotNull
        public Boolean invoke(int i, int j, int elementSize, int qrPixelSize, @NotNull Neighbors neighbors) {
            Intrinsics.checkNotNullParameter((Object)neighbors, (String)"neighbors");
            return new QrBallShape.RoundCorners(this.corner, this.outer, this.horizontalOuter, this.verticalOuter, this.inner).invoke(i, j, elementSize, qrPixelSize, neighbors);
        }
    }
}

