/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexzhirkevich.customqrgenerator.style;

import androidx.annotation.FloatRange;
import com.github.alexzhirkevich.customqrgenerator.style.ModifierDelegate;
import com.github.alexzhirkevich.customqrgenerator.style.Neighbors;
import com.github.alexzhirkevich.customqrgenerator.style.QrPixelShape;
import com.github.alexzhirkevich.customqrgenerator.style.QrShapeModifier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\bf\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0004\u0003\u0004\u0005\u0006\u00a8\u0006\u0007"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/style/QrFrameShape;", "Lcom/github/alexzhirkevich/customqrgenerator/style/QrShapeModifier;", "", "AsPixelShape", "Circle", "Default", "RoundCorners", "custom_qr_generator_release"})
public interface QrFrameShape
extends QrShapeModifier<Boolean> {

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0096\u0002\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/style/QrFrameShape$Default;", "Lcom/github/alexzhirkevich/customqrgenerator/style/QrFrameShape;", "()V", "invoke", "", "i", "", "j", "elementSize", "qrPixelSize", "neighbors", "Lcom/github/alexzhirkevich/customqrgenerator/style/Neighbors;", "(IIIILcom/github/alexzhirkevich/customqrgenerator/style/Neighbors;)Ljava/lang/Boolean;", "custom_qr_generator_release"})
    public static final class Default
    implements QrFrameShape {
        @NotNull
        public static final Default INSTANCE = new Default();

        private Default() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public Boolean invoke(int i, int j, int elementSize, int qrPixelSize, @NotNull Neighbors neighbors) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)neighbors, (String)"neighbors");
            int size = elementSize;
            if (!(0 <= i ? i <= qrPixelSize : false)) {
                if (!(0 <= j ? j <= qrPixelSize : false)) {
                    if (!(size - qrPixelSize <= i ? i <= size : false)) {
                        if (!(size - qrPixelSize <= j ? j <= size : false)) {
                            bl = false;
                            return bl;
                        }
                    }
                }
            }
            bl = true;
            return bl;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J6\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0096\u0002\u00a2\u0006\u0002\u0010\u0011R\u0014\u0010\u0005\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/style/QrFrameShape$AsPixelShape;", "Lcom/github/alexzhirkevich/customqrgenerator/style/QrFrameShape;", "Lcom/github/alexzhirkevich/customqrgenerator/style/ModifierDelegate;", "", "Lcom/github/alexzhirkevich/customqrgenerator/style/QrPixelShape;", "delegate", "(Lcom/github/alexzhirkevich/customqrgenerator/style/QrPixelShape;)V", "getDelegate", "()Lcom/github/alexzhirkevich/customqrgenerator/style/QrPixelShape;", "invoke", "i", "", "j", "elementSize", "qrPixelSize", "neighbors", "Lcom/github/alexzhirkevich/customqrgenerator/style/Neighbors;", "(IIIILcom/github/alexzhirkevich/customqrgenerator/style/Neighbors;)Ljava/lang/Boolean;", "custom_qr_generator_release"})
    public static final class AsPixelShape
    implements QrFrameShape,
    ModifierDelegate<Boolean, QrPixelShape> {
        @NotNull
        private final QrPixelShape delegate;

        public AsPixelShape(@NotNull QrPixelShape delegate) {
            Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
            this.delegate = delegate;
        }

        @NotNull
        public QrPixelShape getDelegate() {
            return this.delegate;
        }

        @Override
        @NotNull
        public Boolean invoke(int i, int j, int elementSize, int qrPixelSize, @NotNull Neighbors neighbors) throws IllegalStateException {
            Intrinsics.checkNotNullParameter((Object)neighbors, (String)"neighbors");
            return Default.INSTANCE.invoke(i, j, elementSize, qrPixelSize, neighbors) != false && (Boolean)this.getDelegate().invoke(i % qrPixelSize, j % qrPixelSize, qrPixelSize, qrPixelSize, neighbors) != false;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0096\u0002\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/style/QrFrameShape$Circle;", "Lcom/github/alexzhirkevich/customqrgenerator/style/QrFrameShape;", "()V", "invoke", "", "i", "", "j", "elementSize", "qrPixelSize", "neighbors", "Lcom/github/alexzhirkevich/customqrgenerator/style/Neighbors;", "(IIIILcom/github/alexzhirkevich/customqrgenerator/style/Neighbors;)Ljava/lang/Boolean;", "custom_qr_generator_release"})
    public static final class Circle
    implements QrFrameShape {
        @NotNull
        public static final Circle INSTANCE = new Circle();

        private Circle() {
        }

        @Override
        @NotNull
        public Boolean invoke(int i, int j, int elementSize, int qrPixelSize, @NotNull Neighbors neighbors) {
            Intrinsics.checkNotNullParameter((Object)neighbors, (String)"neighbors");
            double radius = (double)elementSize / 2.0;
            double d = radius - (double)qrPixelSize;
            double d2 = Math.sqrt((radius - (double)i) * (radius - (double)i) + (radius - (double)j) * (radius - (double)j));
            return d <= d2 ? d2 <= radius : false;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B7\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ6\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0096\u0002\u00a2\u0006\u0002\u0010\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\r\u00a8\u0006\u001a"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/style/QrFrameShape$RoundCorners;", "Lcom/github/alexzhirkevich/customqrgenerator/style/QrFrameShape;", "corner", "", "outer", "", "horizontalOuter", "verticalOuter", "inner", "(FZZZZ)V", "getCorner", "()F", "getHorizontalOuter", "()Z", "getInner", "getOuter", "getVerticalOuter", "invoke", "i", "", "j", "elementSize", "qrPixelSize", "neighbors", "Lcom/github/alexzhirkevich/customqrgenerator/style/Neighbors;", "(IIIILcom/github/alexzhirkevich/customqrgenerator/style/Neighbors;)Ljava/lang/Boolean;", "custom_qr_generator_release"})
    public static final class RoundCorners
    implements QrFrameShape {
        private final float corner;
        private final boolean outer;
        private final boolean horizontalOuter;
        private final boolean verticalOuter;
        private final boolean inner;

        public RoundCorners(@FloatRange(from=0.0, to=0.5) float corner, boolean outer, boolean horizontalOuter, boolean verticalOuter, boolean inner) {
            this.corner = corner;
            this.outer = outer;
            this.horizontalOuter = horizontalOuter;
            this.verticalOuter = verticalOuter;
            this.inner = inner;
        }

        public /* synthetic */ RoundCorners(float f, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = true;
            }
            if ((n & 4) != 0) {
                bl2 = true;
            }
            if ((n & 8) != 0) {
                bl3 = true;
            }
            if ((n & 0x10) != 0) {
                bl4 = true;
            }
            this(f, bl, bl2, bl3, bl4);
        }

        public final float getCorner() {
            return this.corner;
        }

        public final boolean getOuter() {
            return this.outer;
        }

        public final boolean getHorizontalOuter() {
            return this.horizontalOuter;
        }

        public final boolean getVerticalOuter() {
            return this.verticalOuter;
        }

        public final boolean getInner() {
            return this.inner;
        }

        @Override
        @NotNull
        public Boolean invoke(int i, int j, int elementSize, int qrPixelSize, @NotNull Neighbors neighbors) {
            Pair pair;
            Intrinsics.checkNotNullParameter((Object)neighbors, (String)"neighbors");
            float cornerRadius = (0.5f - RangesKt.coerceIn((float)this.corner, (float)0.0f, (float)0.5f)) * (float)elementSize;
            float center = (float)elementSize / 2.0f;
            float sub = center - cornerRadius;
            float sum = center + cornerRadius;
            if (this.outer && (float)i < sub && (float)j < sub) {
                pair = TuplesKt.to((Object)Float.valueOf(sub), (Object)Float.valueOf(sub));
            } else if (this.horizontalOuter && (float)i < sub && (float)j > sum) {
                pair = TuplesKt.to((Object)Float.valueOf(sub), (Object)Float.valueOf(sum));
            } else if (this.verticalOuter && (float)i > sum && (float)j < sub) {
                pair = TuplesKt.to((Object)Float.valueOf(sum), (Object)Float.valueOf(sub));
            } else if (this.inner && (float)i > sum && (float)j > sum) {
                pair = TuplesKt.to((Object)Float.valueOf(sum), (Object)Float.valueOf(sum));
            } else {
                return Default.INSTANCE.invoke(i, j, elementSize, qrPixelSize, neighbors);
            }
            Pair pair2 = pair;
            float x = ((Number)pair2.component1()).floatValue();
            float y = ((Number)pair2.component2()).floatValue();
            float f = sub - (float)qrPixelSize;
            float f2 = (float)Math.sqrt((x - (float)i) * (x - (float)i) + (y - (float)j) * (y - (float)j));
            return f <= f2 ? f2 <= sub : false;
        }
    }
}

