/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexzhirkevich.customqrgenerator.style;

import androidx.annotation.ColorInt;
import com.github.alexzhirkevich.customqrgenerator.QrUtil;
import com.github.alexzhirkevich.customqrgenerator.style.QrColor;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\n\bf\u0018\u00002\u00020\u0001:\u0005\b\t\n\u000b\fJ)\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u00a7\u0002\u00a8\u0006\r"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/style/QrColor;", "", "invoke", "", "i", "j", "elementSize", "qrPixelSize", "CrossingGradient", "LinearGradient", "RadialGradient", "Solid", "Unspecified", "custom_qr_generator_release"})
public interface QrColor {
    @ColorInt
    public int invoke(int var1, int var2, int var3, int var4);

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0097\u0002\u00a8\u0006\t"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/style/QrColor$Unspecified;", "Lcom/github/alexzhirkevich/customqrgenerator/style/QrColor;", "()V", "invoke", "", "i", "j", "elementSize", "qrPixelSize", "custom_qr_generator_release"})
    public static final class Unspecified
    implements QrColor {
        @NotNull
        public static final Unspecified INSTANCE = new Unspecified();

        private Unspecified() {
        }

        @Override
        @ColorInt
        public int invoke(int i, int j, int elementSize, int qrPixelSize) {
            return 0;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J)\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003H\u0097\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/style/QrColor$Solid;", "Lcom/github/alexzhirkevich/customqrgenerator/style/QrColor;", "color", "", "(I)V", "getColor", "()I", "invoke", "i", "j", "elementSize", "qrPixelSize", "custom_qr_generator_release"})
    public static final class Solid
    implements QrColor {
        private final int color;

        public Solid(@ColorInt int color) {
            this.color = color;
        }

        public final int getColor() {
            return this.color;
        }

        @Override
        @ColorInt
        public int invoke(int i, int j, int elementSize, int qrPixelSize) {
            return this.color;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001:\u0001\u0012B!\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J)\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0097\u0002R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0013"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/style/QrColor$LinearGradient;", "Lcom/github/alexzhirkevich/customqrgenerator/style/QrColor;", "startColor", "", "endColor", "orientation", "Lcom/github/alexzhirkevich/customqrgenerator/style/QrColor$LinearGradient$Orientation;", "(IILcom/github/alexzhirkevich/customqrgenerator/style/QrColor$LinearGradient$Orientation;)V", "getEndColor", "()I", "getOrientation", "()Lcom/github/alexzhirkevich/customqrgenerator/style/QrColor$LinearGradient$Orientation;", "getStartColor", "invoke", "i", "j", "elementSize", "qrPixelSize", "Orientation", "custom_qr_generator_release"})
    public static final class LinearGradient
    implements QrColor {
        private final int startColor;
        private final int endColor;
        @NotNull
        private final Orientation orientation;

        public LinearGradient(@ColorInt int startColor, @ColorInt int endColor, @NotNull Orientation orientation) {
            Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
            this.startColor = startColor;
            this.endColor = endColor;
            this.orientation = orientation;
        }

        public final int getStartColor() {
            return this.startColor;
        }

        public final int getEndColor() {
            return this.endColor;
        }

        @NotNull
        public final Orientation getOrientation() {
            return this.orientation;
        }

        @Override
        @ColorInt
        public int invoke(int i, int j, int elementSize, int qrPixelSize) {
            float f;
            switch (WhenMappings.$EnumSwitchMapping$0[this.orientation.ordinal()]) {
                case 1: {
                    f = 1.0f - (float)i / (float)elementSize;
                    break;
                }
                case 2: {
                    f = 1.0f - (float)j / (float)elementSize;
                    break;
                }
                case 3: {
                    f = 1.0f - (float)i * (float)j / (float)elementSize / (float)elementSize;
                    break;
                }
                case 4: {
                    f = 1.0f - (float)i * (float)(elementSize - j) / (float)elementSize / (float)elementSize;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            float proportion = f;
            return QrUtil.INSTANCE.mixColors(this.startColor, this.endColor, ((Number)((Object)RangesKt.coerceIn((Comparable)Float.valueOf(proportion), (ClosedFloatingPointRange)RangesKt.rangeTo((float)0.0f, (float)1.0f)))).floatValue());
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/style/QrColor$LinearGradient$Orientation;", "", "(Ljava/lang/String;I)V", "Vertical", "Horizontal", "LeftDiagonal", "RightDiagonal", "custom_qr_generator_release"})
        public static final class Orientation
        extends Enum<Orientation> {
            public static final /* enum */ Orientation Vertical = new Orientation();
            public static final /* enum */ Orientation Horizontal = new Orientation();
            public static final /* enum */ Orientation LeftDiagonal = new Orientation();
            public static final /* enum */ Orientation RightDiagonal = new Orientation();
            private static final /* synthetic */ Orientation[] $VALUES;

            public static Orientation[] values() {
                return (Orientation[])$VALUES.clone();
            }

            public static Orientation valueOf(String value) {
                return Enum.valueOf(Orientation.class, value);
            }

            static {
                $VALUES = orientationArray = new Orientation[]{Orientation.Vertical, Orientation.Horizontal, Orientation.LeftDiagonal, Orientation.RightDiagonal};
            }
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Orientation.values().length];
                nArray[Orientation.Vertical.ordinal()] = 1;
                nArray[Orientation.Horizontal.ordinal()] = 2;
                nArray[Orientation.LeftDiagonal.ordinal()] = 3;
                nArray[Orientation.RightDiagonal.ordinal()] = 4;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J)\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003H\u0097\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/style/QrColor$RadialGradient;", "Lcom/github/alexzhirkevich/customqrgenerator/style/QrColor;", "centerColor", "", "radiusColor", "(II)V", "getCenterColor", "()I", "getRadiusColor", "invoke", "i", "j", "elementSize", "qrPixelSize", "custom_qr_generator_release"})
    public static final class RadialGradient
    implements QrColor {
        private final int centerColor;
        private final int radiusColor;

        public RadialGradient(@ColorInt int centerColor, @ColorInt int radiusColor) {
            this.centerColor = centerColor;
            this.radiusColor = radiusColor;
        }

        public final int getCenterColor() {
            return this.centerColor;
        }

        public final int getRadiusColor() {
            return this.radiusColor;
        }

        @Override
        @ColorInt
        public int invoke(int i, int j, int elementSize, int qrPixelSize) {
            float center = (float)elementSize / 2.0f;
            float proportion = 1.0f - (float)Math.sqrt(((float)i - center) * ((float)i - center) + ((float)j - center) * ((float)j - center)) / center;
            return QrUtil.INSTANCE.mixColors(this.centerColor, this.radiusColor, ((Number)((Object)RangesKt.coerceIn((Comparable)Float.valueOf(proportion), (ClosedFloatingPointRange)RangesKt.rangeTo((float)0.0f, (float)1.0f)))).floatValue());
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J)\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003H\u0097\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lcom/github/alexzhirkevich/customqrgenerator/style/QrColor$CrossingGradient;", "Lcom/github/alexzhirkevich/customqrgenerator/style/QrColor;", "colorLeftDiagonal", "", "colorRightDiagonal", "(II)V", "getColorLeftDiagonal", "()I", "getColorRightDiagonal", "invoke", "i", "j", "elementSize", "qrPixelSize", "custom_qr_generator_release"})
    public static final class CrossingGradient
    implements QrColor {
        private final int colorLeftDiagonal;
        private final int colorRightDiagonal;

        public CrossingGradient(@ColorInt int colorLeftDiagonal, @ColorInt int colorRightDiagonal) {
            this.colorLeftDiagonal = colorLeftDiagonal;
            this.colorRightDiagonal = colorRightDiagonal;
        }

        public final int getColorLeftDiagonal() {
            return this.colorLeftDiagonal;
        }

        public final int getColorRightDiagonal() {
            return this.colorRightDiagonal;
        }

        @Override
        @ColorInt
        public int invoke(int i, int j, int elementSize, int qrPixelSize) {
            int n;
            float center = (float)elementSize / 2.0f;
            int color = (float)i <= center && (float)j <= center || (float)i >= center && (float)j >= center ? this.colorLeftDiagonal : this.colorRightDiagonal;
            int middleColor = QrUtil.INSTANCE.mixColors(this.colorLeftDiagonal, this.colorRightDiagonal, 0.5f);
            int realI = Math.min(i, elementSize - i);
            int realJ = Math.min(j, elementSize - j);
            int imin = Math.min(realI, (int)((float)realI - center / (float)2));
            int jmin = Math.min(realJ, (int)((float)realJ - center / (float)2));
            if ((float)realI <= center / (float)2 && (float)realJ <= center / (float)2) {
                n = color;
            } else if ((float)realI > center / (float)2 && (float)realJ < center / (float)2) {
                n = new LinearGradient(color, middleColor, LinearGradient.Orientation.Vertical).invoke(imin, jmin, elementSize / 4, qrPixelSize);
            } else if ((float)realI < center / (float)2 && (float)realJ > center / (float)2) {
                n = new LinearGradient(color, middleColor, LinearGradient.Orientation.Horizontal).invoke(imin, jmin, elementSize / 4, qrPixelSize);
            } else {
                Function2 order2 = color == this.colorLeftDiagonal ? (Function2)invoke.order.1.INSTANCE : (Function2)invoke.order.2.INSTANCE;
                n = ((Number)order2.invoke((Object)new LinearGradient(color, middleColor, LinearGradient.Orientation.Horizontal).invoke(imin, jmin, elementSize / 4, qrPixelSize), (Object)new LinearGradient(color, middleColor, LinearGradient.Orientation.Vertical).invoke(imin, jmin, elementSize / 4, qrPixelSize))).intValue();
            }
            return n;
        }
    }
}

