/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.cucumber;

import cucumber.api.Result;
import cucumber.api.event.EventHandler;
import cucumber.api.event.TestCaseFinished;
import org.pitest.testapi.Description;
import org.pitest.testapi.ResultCollector;

public class ReporterAdapter
implements EventHandler<TestCaseFinished> {
    private final ResultCollector rc;
    private final Description scenarioDescription;
    private boolean closed;

    public ReporterAdapter(ResultCollector rc, Description scenarioDescription) {
        this.rc = rc;
        this.scenarioDescription = scenarioDescription;
        rc.notifyStart(scenarioDescription);
    }

    public void receive(TestCaseFinished event) {
        if (this.closed) {
            return;
        }
        Result result = event.result;
        Throwable error = result.getError();
        if (error != null) {
            this.rc.notifyEnd(this.scenarioDescription, error);
        } else if (result.is(Result.Type.SKIPPED) || result.is(Result.Type.UNDEFINED)) {
            this.rc.notifySkipped(this.scenarioDescription);
            this.closed = true;
        } else {
            this.rc.notifyEnd(this.scenarioDescription);
        }
    }
}

