/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.cucumber;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.pitest.cucumber.CucumberTestUnitFinder;
import org.pitest.junit.CompoundTestUnitFinder;
import org.pitest.junit.JUnitCompatibleConfiguration;
import org.pitest.testapi.TestGroupConfig;
import org.pitest.testapi.TestUnitFinder;
import org.pitest.util.Log;

public class CucumberJUnitCompatibleConfiguration
extends JUnitCompatibleConfiguration {
    public CucumberJUnitCompatibleConfiguration(TestGroupConfig config) {
        super(config, Collections.emptyList(), Collections.emptyList());
    }

    public TestUnitFinder testUnitFinder() {
        TestUnitFinder finder;
        if (this.isCucumberUsed()) {
            Log.getLogger().fine("Cucumber detected, scenarios will be used");
            List<TestUnitFinder> finders = Arrays.asList(new CucumberTestUnitFinder(), super.testUnitFinder());
            finder = new CompoundTestUnitFinder(finders);
        } else {
            Log.getLogger().fine("Cucumber not used in this project");
            finder = super.testUnitFinder();
        }
        return finder;
    }

    private boolean isCucumberUsed() {
        boolean result = false;
        try {
            Class.forName("cucumber.api.junit.Cucumber");
            result = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return result;
    }
}

