/*
 * Decompiled with CFR 0.152.
 */
package alexh;

import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class Unchecker {
    private static final Function<Throwable, ? extends RuntimeException> DEFAULT_EXCEPTION_TRANSFORMER = RuntimeException::new;

    public static <T> Supplier<T> uncheck(ThrowingSupplier<T> supplier, Function<Throwable, ? extends RuntimeException> exTransformer) {
        return () -> {
            try {
                return supplier.get();
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable t) {
                throw (RuntimeException)exTransformer.apply(t);
            }
        };
    }

    public static <T> T uncheckedGet(ThrowingSupplier<T> supplier, Function<Throwable, ? extends RuntimeException> exTransformer) {
        return Unchecker.uncheck(supplier, exTransformer).get();
    }

    public static void unchecked(ThrowingRunnable runnable, Function<Throwable, ? extends RuntimeException> exTransformer) {
        Unchecker.uncheck(runnable, exTransformer).run();
    }

    public static <In, Out> Function<In, Out> uncheck(ThrowingFunction<In, Out> function, Function<Throwable, ? extends RuntimeException> exTransformer) {
        return in -> Unchecker.uncheckedGet(() -> function.apply(in), exTransformer);
    }

    public static <In1, In2, Out> BiFunction<In1, In2, Out> uncheck(ThrowingBiFunction<In1, In2, Out> function, Function<Throwable, ? extends RuntimeException> exTransformer) {
        return (in1, in2) -> Unchecker.uncheckedGet(() -> function.apply(in1, in2), exTransformer);
    }

    public static Runnable uncheck(ThrowingRunnable runnable, Function<Throwable, ? extends RuntimeException> exTransformer) {
        return () -> Unchecker.uncheckedGet(() -> {
            runnable.run();
            return null;
        }, exTransformer);
    }

    public static <T> Consumer<T> uncheck(ThrowingConsumer<T> consumer, Function<Throwable, ? extends RuntimeException> exTransformer) {
        return t -> Unchecker.unchecked(() -> consumer.accept(t), exTransformer);
    }

    public static <T, U> BiConsumer<T, U> uncheck(ThrowingBiConsumer<T, U> consumer, Function<Throwable, ? extends RuntimeException> exTransformer) {
        return (t, u) -> Unchecker.unchecked(() -> consumer.accept(t, u), exTransformer);
    }

    public static <T> Supplier<T> uncheck(ThrowingSupplier<T> supplier) {
        return Unchecker.uncheck(supplier, DEFAULT_EXCEPTION_TRANSFORMER);
    }

    public static <T> T uncheckedGet(ThrowingSupplier<T> supplier) {
        return Unchecker.uncheckedGet(supplier, DEFAULT_EXCEPTION_TRANSFORMER);
    }

    public static void unchecked(ThrowingRunnable runnable) {
        Unchecker.unchecked(runnable, DEFAULT_EXCEPTION_TRANSFORMER);
    }

    public static <In, Out> Function<In, Out> uncheck(ThrowingFunction<In, Out> function) {
        return Unchecker.uncheck(function, DEFAULT_EXCEPTION_TRANSFORMER);
    }

    public static <In1, In2, Out> BiFunction<In1, In2, Out> uncheck(ThrowingBiFunction<In1, In2, Out> function) {
        return Unchecker.uncheck(function, DEFAULT_EXCEPTION_TRANSFORMER);
    }

    public static Runnable uncheck(ThrowingRunnable runnable) {
        return Unchecker.uncheck(runnable, DEFAULT_EXCEPTION_TRANSFORMER);
    }

    public static <T> Consumer<T> uncheck(ThrowingConsumer<T> consumer) {
        return Unchecker.uncheck(consumer, DEFAULT_EXCEPTION_TRANSFORMER);
    }

    public static <T, U> BiConsumer<T, U> uncheck(ThrowingBiConsumer<T, U> consumer) {
        return Unchecker.uncheck(consumer, DEFAULT_EXCEPTION_TRANSFORMER);
    }

    @FunctionalInterface
    public static interface ThrowingBiConsumer<T, U> {
        public void accept(T var1, U var2) throws Throwable;
    }

    @FunctionalInterface
    public static interface ThrowingConsumer<T> {
        public void accept(T var1) throws Throwable;
    }

    @FunctionalInterface
    public static interface ThrowingBiFunction<In1, In2, Out> {
        public Out apply(In1 var1, In2 var2) throws Throwable;
    }

    @FunctionalInterface
    public static interface ThrowingFunction<In, Out> {
        public Out apply(In var1) throws Throwable;
    }

    @FunctionalInterface
    public static interface ThrowingRunnable {
        public void run() throws Throwable;
    }

    @FunctionalInterface
    public static interface ThrowingSupplier<T> {
        public T get() throws Throwable;
    }
}

