/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava3.retrofit;

import hu.akarnokd.rxjava3.retrofit.BodyObservable;
import hu.akarnokd.rxjava3.retrofit.CallEnqueueObservable;
import hu.akarnokd.rxjava3.retrofit.CallExecuteObservable;
import hu.akarnokd.rxjava3.retrofit.ResultObservable;
import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.core.BackpressureStrategy;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.lang.reflect.Type;
import retrofit2.Call;
import retrofit2.CallAdapter;

final class RxJava3CallAdapter<R>
implements CallAdapter<R, Object> {
    private final Type responseType;
    @Nullable
    private final Scheduler scheduler;
    private final boolean isAsync;
    private final boolean isResult;
    private final boolean isBody;
    private final boolean isFlowable;
    private final boolean isSingle;
    private final boolean isMaybe;
    private final boolean isCompletable;

    RxJava3CallAdapter(Type responseType, @Nullable Scheduler scheduler, boolean isAsync, boolean isResult, boolean isBody, boolean isFlowable, boolean isSingle, boolean isMaybe, boolean isCompletable) {
        this.responseType = responseType;
        this.scheduler = scheduler;
        this.isAsync = isAsync;
        this.isResult = isResult;
        this.isBody = isBody;
        this.isFlowable = isFlowable;
        this.isSingle = isSingle;
        this.isMaybe = isMaybe;
        this.isCompletable = isCompletable;
    }

    public Type responseType() {
        return this.responseType;
    }

    public Object adapt(Call<R> call) {
        Observable responseObservable;
        Observable observable = responseObservable = this.isAsync ? new CallEnqueueObservable<R>(call) : new CallExecuteObservable<R>(call);
        Observable observable2 = this.isResult ? new ResultObservable(responseObservable) : (this.isBody ? new BodyObservable(responseObservable) : responseObservable);
        if (this.scheduler != null) {
            observable2 = observable2.subscribeOn(this.scheduler);
        }
        if (this.isFlowable) {
            return observable2.toFlowable(BackpressureStrategy.LATEST);
        }
        if (this.isSingle) {
            return observable2.singleOrError();
        }
        if (this.isMaybe) {
            return observable2.singleElement();
        }
        if (this.isCompletable) {
            return observable2.ignoreElements();
        }
        return RxJavaPlugins.onAssembly((Observable)observable2);
    }
}

