/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava.interop;

import io.reactivex.SingleObserver;
import io.reactivex.SingleSource;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import java.util.concurrent.atomic.AtomicReference;
import rx.Single;
import rx.SingleSubscriber;
import rx.Subscription;

final class SingleV2ToSingleV1<T>
implements Single.OnSubscribe<T> {
    final SingleSource<T> source;

    SingleV2ToSingleV1(SingleSource<T> source) {
        this.source = source;
    }

    public void call(SingleSubscriber<? super T> t) {
        SourceSingleObserver<? super T> parent = new SourceSingleObserver<T>(t);
        t.add(parent);
        this.source.subscribe(parent);
    }

    static final class SourceSingleObserver<T>
    extends AtomicReference<Disposable>
    implements SingleObserver<T>,
    Subscription {
        private static final long serialVersionUID = 4758098209431016997L;
        final SingleSubscriber<? super T> actual;

        SourceSingleObserver(SingleSubscriber<? super T> actual) {
            this.actual = actual;
        }

        public void unsubscribe() {
            DisposableHelper.dispose((AtomicReference)this);
        }

        public boolean isUnsubscribed() {
            return DisposableHelper.isDisposed((Disposable)((Disposable)this.get()));
        }

        public void onSubscribe(Disposable d) {
            DisposableHelper.setOnce((AtomicReference)this, (Disposable)d);
        }

        public void onSuccess(T value) {
            this.actual.onSuccess(value);
        }

        public void onError(Throwable e) {
            this.actual.onError(e);
        }
    }
}

