/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava.interop;

import io.reactivex.Flowable;
import io.reactivex.plugins.RxJavaPlugins;
import org.reactivestreams.Subscription;
import rx.Observable;
import rx.Subscriber;

final class ObservableV1ToFlowableV2<T>
extends Flowable<T> {
    final Observable<T> source;

    ObservableV1ToFlowableV2(Observable<T> source) {
        this.source = source;
    }

    protected void subscribeActual(org.reactivestreams.Subscriber<? super T> s) {
        ObservableSubscriber<? super T> parent = new ObservableSubscriber<T>(s);
        ObservableSubscriberSubscription parentSubscription = new ObservableSubscriberSubscription(parent);
        s.onSubscribe((Subscription)parentSubscription);
        this.source.unsafeSubscribe(parent);
    }

    static final class ObservableSubscriberSubscription
    implements Subscription {
        final ObservableSubscriber<?> parent;

        ObservableSubscriberSubscription(ObservableSubscriber<?> parent) {
            this.parent = parent;
        }

        public void request(long n) {
            this.parent.requestMore(n);
        }

        public void cancel() {
            this.parent.unsubscribe();
        }
    }

    static final class ObservableSubscriber<T>
    extends Subscriber<T> {
        final org.reactivestreams.Subscriber<? super T> actual;
        boolean done;

        ObservableSubscriber(org.reactivestreams.Subscriber<? super T> actual) {
            this.actual = actual;
            this.request(0L);
        }

        public void onNext(T t) {
            if (this.done) {
                return;
            }
            if (t == null) {
                this.unsubscribe();
                this.onError(new NullPointerException("The upstream 1.x Observable signalled a null value which is not supported in 2.x"));
            } else {
                this.actual.onNext(t);
            }
        }

        public void onError(Throwable e) {
            if (this.done) {
                RxJavaPlugins.onError((Throwable)e);
                return;
            }
            this.done = true;
            this.actual.onError(e);
        }

        public void onCompleted() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.actual.onComplete();
        }

        void requestMore(long n) {
            this.request(n);
        }
    }
}

