/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava.interop;

import io.reactivex.internal.subscriptions.SubscriptionHelper;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;

final class FlowableV2ToObservableV1<T>
implements Observable.OnSubscribe<T> {
    final Publisher<T> source;

    FlowableV2ToObservableV1(Publisher<T> source) {
        this.source = source;
    }

    public void call(Subscriber<? super T> t) {
        SourceSubscriber<? super T> parent = new SourceSubscriber<T>(t);
        t.add(parent);
        t.setProducer(parent);
        this.source.subscribe(parent);
    }

    static final class SourceSubscriber<T>
    extends AtomicReference<Subscription>
    implements org.reactivestreams.Subscriber<T>,
    rx.Subscription,
    Producer {
        private static final long serialVersionUID = -6567012932544037069L;
        final Subscriber<? super T> actual;
        final AtomicLong requested;

        SourceSubscriber(Subscriber<? super T> actual) {
            this.actual = actual;
            this.requested = new AtomicLong();
        }

        public void request(long n) {
            SubscriptionHelper.deferredRequest((AtomicReference)this, (AtomicLong)this.requested, (long)n);
        }

        public void unsubscribe() {
            SubscriptionHelper.cancel((AtomicReference)this);
        }

        public boolean isUnsubscribed() {
            return SubscriptionHelper.isCancelled((Subscription)((Subscription)this.get()));
        }

        public void onSubscribe(Subscription s) {
            SubscriptionHelper.deferredSetOnce((AtomicReference)this, (AtomicLong)this.requested, (Subscription)s);
        }

        public void onNext(T t) {
            this.actual.onNext(t);
        }

        public void onError(Throwable t) {
            this.actual.onError(t);
        }

        public void onComplete() {
            this.actual.onCompleted();
        }
    }
}

