/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava.interop;

import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.plugins.RxJavaPlugins;
import rx.Subscriber;

final class ObservableV1ToObservableV2<T>
extends Observable<T> {
    final rx.Observable<T> source;

    ObservableV1ToObservableV2(rx.Observable<T> source) {
        this.source = source;
    }

    protected void subscribeActual(Observer<? super T> s) {
        ObservableSubscriber<? super T> parent = new ObservableSubscriber<T>(s);
        s.onSubscribe(parent);
        this.source.unsafeSubscribe(parent);
    }

    static final class ObservableSubscriber<T>
    extends Subscriber<T>
    implements Disposable {
        final Observer<? super T> actual;
        boolean done;

        ObservableSubscriber(Observer<? super T> actual) {
            this.actual = actual;
        }

        public void onNext(T t) {
            if (this.done) {
                return;
            }
            if (t == null) {
                this.unsubscribe();
                this.onError(new NullPointerException("The upstream 1.x Observable signalled a null value which is not supported in 2.x"));
            } else {
                this.actual.onNext(t);
            }
        }

        public void onError(Throwable e) {
            if (this.done) {
                RxJavaPlugins.onError((Throwable)e);
                return;
            }
            this.done = true;
            this.actual.onError(e);
            this.unsubscribe();
        }

        public void onCompleted() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.actual.onComplete();
            this.unsubscribe();
        }

        public void dispose() {
            this.unsubscribe();
        }

        public boolean isDisposed() {
            return this.isUnsubscribed();
        }
    }
}

