/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava.interop;

import hu.akarnokd.rxjava.interop.ObservableV1ToObservableV2;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.subjects.Subject;

final class SubjectV1ToSubjectV2<T>
extends Subject<T> {
    final rx.subjects.Subject<T, T> source;
    volatile boolean terminated;
    Throwable error;

    SubjectV1ToSubjectV2(rx.subjects.Subject<T, T> source) {
        this.source = source;
    }

    public void onSubscribe(Disposable d) {
        if (this.terminated) {
            d.dispose();
        }
    }

    public void onNext(T t) {
        if (!this.terminated) {
            if (t == null) {
                this.onError(new NullPointerException());
            } else {
                this.source.onNext(t);
            }
        }
    }

    public void onError(Throwable e) {
        if (!this.terminated) {
            if (e == null) {
                e = new NullPointerException("Throwable was null");
            }
            this.error = e;
            this.terminated = true;
            this.source.onError(e);
        } else {
            RxJavaPlugins.onError((Throwable)e);
        }
    }

    public void onComplete() {
        if (!this.terminated) {
            this.terminated = true;
            this.source.onCompleted();
        }
    }

    protected void subscribeActual(Observer<? super T> observer) {
        ObservableV1ToObservableV2.ObservableSubscriber<? super T> parent = new ObservableV1ToObservableV2.ObservableSubscriber<T>(observer);
        observer.onSubscribe(parent);
        this.source.unsafeSubscribe(parent);
    }

    public boolean hasObservers() {
        return this.source.hasObservers();
    }

    public boolean hasComplete() {
        return this.terminated && this.error == null;
    }

    public boolean hasThrowable() {
        return this.terminated && this.error != null;
    }

    public Throwable getThrowable() {
        return this.terminated ? this.error : null;
    }
}

