/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.wp.view;

import android.graphics.Canvas;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectangle;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.control.IWord;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.AttrManage;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.IAttributeSet;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.IDocument;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.IElement;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.AbstractView;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.DocAttr;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.IRoot;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.IView;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.PageAttr;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.ParaAttr;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.ViewContainer;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.ViewKit;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import com.ahmadullahpk.alldocumentreader.xs.wp.model.WPDocument;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.LayoutKit;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.LineView;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.ParagraphView;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.TableLayoutKit;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.TableView;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.ViewFactory;

public class WPSTRoot
extends AbstractView
implements IRoot {
    private static TableLayoutKit tableLayout = new TableLayoutKit();
    private boolean isWrapLine;
    private int elementIndex;
    private IDocument doc;
    private PageAttr pageAttr;
    private ParaAttr paraAttr;
    private DocAttr docAttr;
    private IWord container;
    private int maxParaWidth;

    public WPSTRoot(IWord container, IDocument doc, int elementIndex) {
        this.doc = doc;
        this.container = container;
        this.elementIndex = elementIndex;
        this.docAttr = new DocAttr();
        this.paraAttr = new ParaAttr();
        this.pageAttr = new PageAttr();
    }

    @Override
    public short getType() {
        return 3;
    }

    @Override
    public IWord getContainer() {
        return this.container;
    }

    @Override
    public IDocument getDocument() {
        return this.doc;
    }

    @Override
    public IControl getControl() {
        return this.container.getControl();
    }

    public void doLayout() {
        ParagraphView para;
        IElement sec = ((WPDocument)this.doc).getTextboxSectionElementForIndex(this.elementIndex);
        AttrManage.instance().fillPageAttr(this.pageAttr, sec.getAttribute());
        IAttributeSet attr = this.doc.getSection(0L).getAttribute();
        int bodyWidth = (int)((float)(AttrManage.instance().getPageWidth(attr) - AttrManage.instance().getPageMarginLeft(attr) - AttrManage.instance().getPageMarginRight(attr)) * 0.06666667f);
        tableLayout.clearBreakPages();
        int dx = this.pageAttr.leftMargin;
        int dy = this.pageAttr.topMargin;
        this.setTopIndent(this.pageAttr.topMargin);
        this.setLeftIndent(this.pageAttr.leftMargin);
        int spanW = (this.isWrapLine ? this.pageAttr.pageWidth : bodyWidth) - this.pageAttr.leftMargin - this.pageAttr.rightMargin;
        spanW = Math.max(5, spanW);
        int spanH = Integer.MAX_VALUE;
        int flag = ViewKit.instance().setBitValue(0, 0, true);
        flag = ViewKit.instance().setBitValue(flag, 3, !this.isWrapLine || this.pageAttr.horizontalAlign == 1);
        long maxEnd = sec.getEndOffset();
        long currentLayoutOffset = sec.getStartOffset();
        int paraCount = this.doc.getParaCount(maxEnd);
        if (paraCount == 0) {
            return;
        }
        IElement elem = this.doc.getParagraph(currentLayoutOffset);
        if (AttrManage.instance().hasAttribute(elem.getAttribute(), (short)4107)) {
            elem = ((WPDocument)this.doc).getParagraph0(currentLayoutOffset);
            para = (ParagraphView)ViewFactory.createView(this.getControl(), elem, null, 9);
        } else {
            para = (ParagraphView)ViewFactory.createView(this.getControl(), elem, null, 5);
        }
        this.appendChlidView(para);
        para.setStartOffset(currentLayoutOffset);
        para.setEndOffset(elem.getEndOffset());
        int contentHeight = 0;
        boolean firstPara = true;
        int breakType = 0;
        while (spanH > 0 && currentLayoutOffset < maxEnd && breakType != 1) {
            para.setLocation(dx, dy);
            if (para.getType() == 9) {
                breakType = tableLayout.layoutTable(this.getControl(), this.doc, this, this.docAttr, this.pageAttr, this.paraAttr, (TableView)para, currentLayoutOffset, dx, dy, spanW, spanH, flag, false);
            } else {
                tableLayout.clearBreakPages();
                AttrManage.instance().fillParaAttr(this.getControl(), this.paraAttr, elem.getAttribute());
                breakType = LayoutKit.instance().layoutPara(this.getControl(), this.doc, this.docAttr, this.pageAttr, this.paraAttr, para, currentLayoutOffset, dx, dy, spanW, spanH, flag);
            }
            int paraHeight = para.getLayoutSpan((byte)1);
            dy += paraHeight;
            currentLayoutOffset = para.getEndOffset(null);
            contentHeight += paraHeight;
            this.maxParaWidth = Math.max(this.maxParaWidth, para.getLayoutSpan((byte)0));
            if ((spanH -= paraHeight) > 0 && currentLayoutOffset < maxEnd) {
                elem = this.doc.getParagraph(currentLayoutOffset);
                if (elem == null) break;
                if (AttrManage.instance().hasAttribute(elem.getAttribute(), (short)4107)) {
                    elem = ((WPDocument)this.doc).getParagraph0(currentLayoutOffset);
                    para = (ParagraphView)ViewFactory.createView(this.getControl(), elem, null, 9);
                } else {
                    para = (ParagraphView)ViewFactory.createView(this.getControl(), elem, null, 5);
                }
                para.setStartOffset(currentLayoutOffset);
                this.appendChlidView(para);
            }
            firstPara = false;
        }
        if (!this.isWrapLine) {
            this.paraAlign(this.maxParaWidth);
        }
        this.layoutPageAlign(contentHeight, this.maxParaWidth);
        if (!this.isWrapLine) {
            this.pageAttr.pageWidth = bodyWidth;
        }
    }

    private void paraAlign(int maxParaWidth) {
        for (IView paraView = this.getChildView(); paraView != null; paraView = paraView.getNextView()) {
            this.paraAttr.horizontalAlignment = (byte)AttrManage.instance().getParaHorizontalAlign(paraView.getElement().getAttribute());
            for (IView line = paraView.getChildView(); line != null; line = line.getNextView()) {
                if (line.getType() != 6) continue;
                ((LineView)line).layoutAlignment(this.docAttr, this.pageAttr, this.paraAttr, ((ParagraphView)paraView).getBNView(), maxParaWidth, 0, false);
            }
        }
    }

    private void layoutPageAlign(int contentHeight, int maxParaWidth) {
        int spanHeight = this.pageAttr.pageHeight - this.pageAttr.topMargin - this.pageAttr.bottomMargin;
        int addSpan = 0;
        switch (this.pageAttr.verticalAlign) {
            case 1: {
                addSpan = (spanHeight - contentHeight) / 2;
                break;
            }
            case 2: {
                addSpan = spanHeight - contentHeight;
                break;
            }
        }
        if (addSpan < 0) {
            return;
        }
        this.setY(addSpan);
        this.setTopIndent(addSpan);
        if (this.pageAttr.horizontalAlign == 1) {
            int pageWidth = this.pageAttr.pageWidth - this.pageAttr.leftMargin - this.pageAttr.rightMargin;
            addSpan = (pageWidth - maxParaWidth) / 2;
            for (IView view = this.getChildView(); view != null; view = view.getNextView()) {
                this.paraAttr.horizontalAlignment = (byte)AttrManage.instance().getParaHorizontalAlign(view.getElement().getAttribute());
                for (IView line = view.getChildView(); line != null && line.getType() == 6; line = line.getNextView()) {
                    ((LineView)line).layoutAlignment(this.docAttr, this.pageAttr, this.paraAttr, ((ParagraphView)view).getBNView(), maxParaWidth, 0, false);
                    line.setX(line.getX() + addSpan);
                }
            }
        }
    }

    public String getText() {
        String text = "";
        for (IView view = this.getChildView(); view != null; view = view.getNextView()) {
            text = text + ((ParagraphView)view).getText();
        }
        return text;
    }

    @Override
    public void draw(Canvas canvas, int originX, int originY, float zoom) {
        canvas.save();
        canvas.clipRect((float)originX, (float)originY, (float)originX + (float)this.pageAttr.pageWidth * zoom, (float)originY + (float)(this.pageAttr.pageHeight - this.pageAttr.bottomMargin) * zoom);
        super.draw(canvas, originX, originY, zoom);
        canvas.restore();
    }

    @Override
    public boolean canBackLayout() {
        return false;
    }

    @Override
    public void backLayout() {
    }

    @Override
    public Rectangle modelToView(long offset, Rectangle rect, boolean isBack) {
        IView view = this.getView(offset, 5, isBack);
        if (view != null) {
            view.modelToView(offset, rect, isBack);
        }
        rect.x += this.getX();
        rect.y += this.getY();
        return rect;
    }

    @Override
    public long viewToModel(int x, int y, boolean isBack) {
        IView view;
        x -= this.getX();
        y -= this.getY();
        for (view = this.getChildView(); view != null && (y < view.getY() || y >= view.getY() + view.getLayoutSpan((byte)1)); view = view.getNextView()) {
        }
        if (view != null) {
            return view.viewToModel(x, y, isBack);
        }
        return -1L;
    }

    @Override
    public ViewContainer getViewContainer() {
        return null;
    }

    public int getAdjustTextboxWidth() {
        return this.maxParaWidth + this.pageAttr.leftMargin + this.pageAttr.rightMargin;
    }

    public void setWrapLine(boolean b) {
        this.isWrapLine = b;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.doc = null;
        this.container = null;
        this.pageAttr = null;
        this.paraAttr = null;
        this.docAttr = null;
    }
}

