/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.wp.view;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import com.ahmadullahpk.alldocumentreader.xs.common.BackgroundDrawer;
import com.ahmadullahpk.alldocumentreader.xs.common.bg.BackgroundAndFill;
import com.ahmadullahpk.alldocumentreader.xs.common.borders.Border;
import com.ahmadullahpk.alldocumentreader.xs.common.borders.Borders;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectangle;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.IElement;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.AbstractView;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.IView;
import com.ahmadullahpk.alldocumentreader.xs.wp.model.WPDocument;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.LeafView;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.ObjView;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.ShapeView;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.TitleView;
import java.util.ArrayList;
import java.util.List;

public class PageView
extends AbstractView {
    private boolean hasBreakTable;
    private int pageBRColor;
    private int pageBorder = -1;
    private Paint paint;
    private int pageNumber;
    private TitleView header;
    private TitleView footer;
    private List<LeafView> shapeViews;

    public PageView(IElement elem) {
        this.elem = elem;
        this.paint = new Paint();
        this.paint.setStrokeWidth(2.0f);
    }

    @Override
    public short getType() {
        return 4;
    }

    @Override
    public void draw(Canvas canvas, int originX, int originY, float zoom) {
        canvas.save();
        int dX = (int)((float)this.x * zoom) + originX;
        int dY = (int)((float)this.y * zoom) + originY;
        canvas.clipRect((float)dX, (float)dY, (float)dX + (float)this.getWidth() * zoom, (float)dY + (float)this.getHeight() * zoom);
        this.drawBackground(canvas, dX, dY, zoom);
        this.drawBorder(canvas, dX, dY, zoom);
        this.drawPaper(canvas, dX, dY, zoom);
        this.drawPageSeparated(canvas, dX, dY, zoom);
        if (this.header != null) {
            this.header.setParentView(this);
            this.header.draw(canvas, dX, dY, zoom);
        }
        if (this.footer != null) {
            this.footer.setParentView(this);
            this.footer.draw(canvas, dX, dY, zoom);
        }
        this.drawShape(canvas, dX, dY, zoom, true);
        super.draw(canvas, originX, originY, zoom);
        this.drawShape(canvas, dX, dY, zoom, false);
        canvas.restore();
    }

    public void drawForPrintMode(Canvas canvas, int originX, int originY, float zoom) {
        int dX = (int)((float)this.x * zoom) + originX;
        int dY = (int)((float)this.y * zoom) + originY;
        this.drawBackground(canvas, dX, dY, zoom);
        this.drawBorder(canvas, dX, dY, zoom);
        this.drawPageSeparated(canvas, dX, dY, zoom);
        if (this.header != null) {
            this.header.setParentView(this);
            this.header.draw(canvas, dX, dY, zoom);
        }
        if (this.footer != null) {
            this.footer.setParentView(this);
            this.footer.draw(canvas, dX, dY, zoom);
        }
        this.drawShape(canvas, dX, dY, zoom, true);
        super.draw(canvas, originX, originY, zoom);
        this.drawShape(canvas, dX, dY, zoom, false);
    }

    public void drawToImage(Canvas canvas, int originX, int originY, float zoom) {
        int dX = (int)((float)this.x * zoom) + originX;
        int dY = (int)((float)this.y * zoom) + originY;
        this.drawBackground(canvas, dX, dY, zoom);
        this.drawBorder(canvas, dX, dY, zoom);
        if (this.header != null) {
            this.header.setParentView(this);
            this.header.draw(canvas, dX, dY, zoom);
        }
        if (this.footer != null) {
            this.footer.setParentView(this);
            this.footer.draw(canvas, dX, dY, zoom);
        }
        this.drawShape(canvas, dX, dY, zoom, true);
        super.draw(canvas, originX, originY, zoom);
        this.drawShape(canvas, dX, dY, zoom, false);
    }

    private void drawBackground(Canvas canvas, int dx, int dy, float zoom) {
        int w = (int)((float)this.getWidth() * zoom);
        int h = (int)((float)this.getHeight() * zoom);
        Rect rect = new Rect(dx, dy, dx + w, dy + h);
        BackgroundAndFill pageFill = ((WPDocument)this.getDocument()).getPageBackground();
        if (pageFill != null) {
            BackgroundDrawer.drawBackground(canvas, this.getControl(), this.pageNumber, pageFill, rect, null, zoom);
        } else {
            this.paint.setColor(-1);
            canvas.drawRect((float)dx, (float)dy, (float)(dx + w), (float)(dy + h), this.paint);
        }
    }

    private void drawBorder(Canvas canvas, int dx, int dy, float zoom) {
        if (this.pageBorder >= 0) {
            int w = (int)((float)this.getWidth() * zoom);
            int h = (int)((float)this.getHeight() * zoom);
            Borders bs = this.getControl().getSysKit().getBordersManage().getBorders(this.pageBorder);
            int old = this.paint.getColor();
            if (bs != null) {
                int eY;
                int sY;
                int eX;
                int sX;
                Border left = bs.getLeftBorder();
                Border top = bs.getTopBorder();
                Border right = bs.getRightBorder();
                Border bottom = bs.getBottomBorder();
                if (left != null) {
                    this.paint.setColor(left.getColor());
                    eX = sX = (int)(zoom * (float)left.getSpace()) + dx;
                    sY = (top == null ? 0 : (int)((float)top.getSpace() * zoom)) + dy;
                    eY = (int)(bottom == null ? (float)h : (float)h - (float)bottom.getSpace() * zoom) + dy;
                    canvas.drawLine((float)sX, (float)sY, (float)eX, (float)eY, this.paint);
                }
                if (top != null) {
                    this.paint.setColor(top.getColor());
                    eY = sY = (int)(zoom * (float)top.getSpace()) + dy;
                    sX = (left == null ? 0 : (int)((float)left.getSpace() * zoom)) + dx - 1;
                    eX = (int)(right == null ? (float)w : (float)w - (float)right.getSpace() * zoom) + dx + 1;
                    canvas.drawLine((float)sX, (float)sY, (float)eX, (float)eY, this.paint);
                }
                if (right != null) {
                    this.paint.setColor(right.getColor());
                    eX = sX = (int)((float)w - (float)right.getSpace() * zoom) + dx;
                    sY = (int)(top == null ? 0.0f : (float)top.getSpace() * zoom) + dy;
                    eY = (int)(bottom == null ? (float)h : (float)h - (float)bottom.getSpace() * zoom) + dy;
                    canvas.drawLine((float)sX, (float)sY, (float)eX, (float)eY, this.paint);
                }
                if (bottom != null) {
                    this.paint.setColor(bottom.getColor());
                    eY = sY = (int)((float)h - zoom * (float)top.getSpace()) + dy;
                    sX = (left == null ? 0 : (int)((float)left.getSpace() * zoom)) + dx - 1;
                    eX = (int)(right == null ? (float)w : (float)w - (float)right.getSpace() * zoom) + dx + 1;
                    canvas.drawLine((float)sX, (float)sY, (float)eX, (float)eY, this.paint);
                }
            }
            this.paint.setColor(old);
        }
    }

    private void drawPaper(Canvas canvas, int dx, int dy, float zoom) {
        canvas.save();
        int w = (int)((float)this.getWidth() * zoom);
        int h = (int)((float)this.getHeight() * zoom);
        canvas.clipRect(dx, dy, dx + w + 5, dy + h + 5);
        this.paint.setColor(-16777216);
        canvas.drawLine((float)dx, (float)dy, (float)(dx + w), (float)dy, this.paint);
        canvas.drawLine((float)dx, (float)dy, (float)dx, (float)(dy + h), this.paint);
        canvas.drawLine((float)(dx + w), (float)dy, (float)(dx + w), (float)(dy + h), this.paint);
        canvas.drawLine((float)dx, (float)(dy + h), (float)(dx + w), (float)(dy + h), this.paint);
        canvas.restore();
    }

    private void drawPageSeparated(Canvas canvas, int dx, int dy, float zoom) {
        int bm = 30;
        float left = (float)this.getLeftIndent() * zoom + (float)dx;
        float top = (float)this.getTopIndent() * zoom + (float)dy;
        this.paint.setColor(-7829368);
        canvas.drawRect(left - 1.0f, top - (float)bm, left, top, this.paint);
        canvas.drawRect(left - (float)bm, top - 1.0f, left, top, this.paint);
        float right = (float)(this.getWidth() - this.getRightIndent()) * zoom + (float)dx;
        canvas.drawRect(right, top - (float)bm, right + 1.0f, top, this.paint);
        canvas.drawRect(right, top - 1.0f, right + (float)bm, top, this.paint);
        float bottom = (float)(this.getHeight() - this.getBottomIndent()) * zoom + (float)dy;
        canvas.drawRect(left - 1.0f, bottom, left, bottom + (float)bm, this.paint);
        canvas.drawRect(left - (float)bm, bottom, left, bottom + 1.0f, this.paint);
        canvas.drawRect(right, bottom, right + 1.0f, bottom + (float)bm, this.paint);
        canvas.drawRect(right, bottom, right + (float)bm, bottom + 1.0f, this.paint);
    }

    private void drawShape(Canvas canvas, int originX, int originY, float zoom, boolean drawBehindDocShape) {
        if (this.shapeViews == null || this.shapeViews.size() == 0) {
            return;
        }
        if (drawBehindDocShape) {
            for (LeafView shape : this.shapeViews) {
                if (shape instanceof ShapeView && ((ShapeView)shape).isBehindDoc()) {
                    ((ShapeView)shape).drawForWrap(canvas, originX, originY, zoom);
                    continue;
                }
                if (!(shape instanceof ObjView) || !((ObjView)shape).isBehindDoc()) continue;
                ((ObjView)shape).drawForWrap(canvas, originX, originY, zoom);
            }
        } else {
            for (LeafView shape : this.shapeViews) {
                if (shape instanceof ShapeView && !((ShapeView)shape).isBehindDoc()) {
                    ((ShapeView)shape).drawForWrap(canvas, originX, originY, zoom);
                    continue;
                }
                if (!(shape instanceof ObjView) || ((ObjView)shape).isBehindDoc()) continue;
                ((ObjView)shape).drawForWrap(canvas, originX, originY, zoom);
            }
        }
    }

    @Override
    public Rectangle modelToView(long offset, Rectangle rect, boolean isBack) {
        IView view = this.getView(offset, 5, isBack);
        if (view != null) {
            view.modelToView(offset, rect, isBack);
        }
        rect.x += this.getX();
        rect.y += this.getY();
        return rect;
    }

    @Override
    public IView getView(long offset, int type, boolean isBack) {
        IView view;
        for (view = this.child; view != null && !view.contains(offset, isBack); view = view.getNextView()) {
        }
        if (view != null && view.getType() != type && view.getType() != 9) {
            return view.getView(offset, type, isBack);
        }
        return view;
    }

    @Override
    public long viewToModel(int x, int y, boolean isBack) {
        x -= this.getX();
        IView view = this.getChildView();
        if (view != null && (y -= this.getY()) > view.getY()) {
            while (view != null && (y < view.getY() || y >= view.getY() + view.getHeight())) {
                view = view.getNextView();
            }
        }
        IView iView = view = view == null ? this.getChildView() : view;
        if (view != null) {
            return view.viewToModel(x, y, isBack);
        }
        return -1L;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    public TitleView getHeader() {
        return this.header;
    }

    public void setHeader(TitleView header) {
        this.header = header;
    }

    public TitleView getFooter() {
        return this.footer;
    }

    public void setFooter(TitleView footer) {
        this.footer = footer;
    }

    public boolean isHasBreakTable() {
        return this.hasBreakTable;
    }

    public void setHasBreakTable(boolean hasBreakTable) {
        this.hasBreakTable = hasBreakTable;
    }

    public void setPageBackgroundColor(int color2) {
        this.pageBRColor = color2;
    }

    public void setPageBorder(int border) {
        this.pageBorder = border;
    }

    public void addShapeView(LeafView view) {
        if (this.shapeViews == null) {
            this.shapeViews = new ArrayList<LeafView>();
        }
        this.shapeViews.add(view);
    }

    public boolean checkUpdateHeaderFooterFieldText(int totalPages) {
        boolean hasTotalPageCode = this.checkUpdateHeaderFooterFieldText(this.header, totalPages);
        return hasTotalPageCode || this.checkUpdateHeaderFooterFieldText(this.footer, totalPages);
    }

    private boolean checkUpdateHeaderFooterFieldText(TitleView titleView, int totalPages) {
        boolean hasTotalPageCode = false;
        if (titleView != null) {
            for (IView paraView = titleView.getChildView(); paraView != null; paraView = paraView.getNextView()) {
                for (IView lineView = paraView.getChildView(); lineView != null; lineView = lineView.getNextView()) {
                    for (IView leafView = lineView.getChildView(); leafView != null; leafView = leafView.getNextView()) {
                        if (!(leafView instanceof LeafView) || !((LeafView)leafView).hasUpdatedFieldText()) continue;
                        hasTotalPageCode = true;
                        ((LeafView)leafView).setNumPages(totalPages);
                    }
                }
            }
        }
        return hasTotalPageCode;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.header != null) {
            this.header.dispose();
            this.header = null;
        }
        if (this.footer != null) {
            this.footer.dispose();
            this.footer = null;
        }
        if (this.shapeViews != null) {
            this.shapeViews.clear();
            this.shapeViews = null;
        }
        this.paint = null;
    }
}

