/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.wp.view;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectangle;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.control.IWord;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.IElement;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.AbstractView;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.CharAttr;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.DocAttr;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.IView;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.PageAttr;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.ParaAttr;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.ViewKit;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.BNView;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.LeafView;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.ObjView;
import com.ahmadullahpk.alldocumentreader.xs.wp.view.ShapeView;

public class LineView
extends AbstractView {
    private int heightExceptShape;

    public LineView() {
    }

    public LineView(IElement elem) {
        this.elem = elem;
    }

    @Override
    public short getType() {
        return 6;
    }

    public void layoutAlignment(DocAttr docAttr, PageAttr pageAttr, ParaAttr paraAttr, BNView bnView, int span, int flag) {
        this.layoutAlignment(docAttr, pageAttr, paraAttr, bnView, span, flag, true);
    }

    public void setHeightExceptShape(int height) {
        this.heightExceptShape = height;
    }

    public int getHeightExceptShape() {
        return this.heightExceptShape;
    }

    public void layoutAlignment(DocAttr docAttr, PageAttr pageAttr, ParaAttr paraAttr, BNView bnView, int span, int flag, boolean isLayoutVertical) {
        if (!ViewKit.instance().getBitValue(flag, 3)) {
            this.layoutHorizontal(docAttr, pageAttr, paraAttr, bnView, span, flag);
        }
        if (isLayoutVertical) {
            this.layoutVertical(docAttr, pageAttr, paraAttr, bnView, span, flag);
        }
    }

    public void layoutHorizontal(DocAttr docAttr, PageAttr pageAttr, ParaAttr paraAttr, BNView bnView, int span, int flag) {
        switch (paraAttr.horizontalAlignment) {
            case 1: {
                this.x += (span - this.width) / 2;
                break;
            }
            case 2: {
                this.x += span - this.width;
                break;
            }
        }
    }

    private void layoutVertical(DocAttr docAttr, PageAttr pageAttr, ParaAttr paraAttr, BNView bnView, int span, int flag) {
        int maxBaseline;
        LeafView leaf = (LeafView)this.getChildView();
        if (leaf == null) {
            return;
        }
        int n = maxBaseline = bnView == null ? 0 : bnView.getBaseline();
        while (leaf != null) {
            maxBaseline = Math.max(maxBaseline, leaf.getBaseline());
            leaf = (LeafView)leaf.getNextView();
        }
        leaf = (LeafView)this.getChildView();
        while (leaf != null) {
            if (leaf.getType() == 13) {
                if (!((ShapeView)leaf).isInline()) {
                    leaf = (LeafView)leaf.getNextView();
                    continue;
                }
            } else if (leaf.getType() == 8 && !((ObjView)leaf).isInline()) {
                leaf = (LeafView)leaf.getNextView();
                continue;
            }
            int baseline = maxBaseline - leaf.getBaseline();
            leaf.setTopIndent(baseline);
            leaf.setY(leaf.getY() + baseline);
            leaf = (LeafView)leaf.getNextView();
        }
        float value = 0.0f;
        boolean processline = false;
        switch (paraAttr.lineSpaceType) {
            case 0: 
            case 1: 
            case 2: 
            case 5: {
                processline = true;
                if (pageAttr.pageLinePitch > 0.0f) {
                    if ((float)this.heightExceptShape > pageAttr.pageLinePitch * paraAttr.lineSpaceValue) {
                        value = (float)(Math.ceil((float)this.heightExceptShape / pageAttr.pageLinePitch) * (double)pageAttr.pageLinePitch);
                        break;
                    }
                    value = pageAttr.pageLinePitch * paraAttr.lineSpaceValue;
                    break;
                }
                value = paraAttr.lineSpaceValue * (float)this.heightExceptShape;
                break;
            }
            case 3: {
                processline = true;
                if (paraAttr.lineSpaceValue > (float)this.heightExceptShape) {
                    processline = true;
                    if (pageAttr.pageLinePitch > 0.0f) {
                        value = Math.max(paraAttr.lineSpaceValue, pageAttr.pageLinePitch);
                        break;
                    }
                    value = paraAttr.lineSpaceValue;
                    break;
                }
                if (pageAttr.pageLinePitch > 0.0f) {
                    processline = true;
                    value = (float)(Math.ceil((float)this.heightExceptShape / pageAttr.pageLinePitch) * (double)pageAttr.pageLinePitch);
                    break;
                }
                value = this.heightExceptShape;
                break;
            }
        }
        if (processline) {
            value = (value - (float)this.heightExceptShape) / 2.0f;
            this.setTopIndent((int)value);
            this.setBottomIndent((int)value);
            this.setY(this.getY() + (int)value);
            if (bnView != null) {
                bnView.setTopIndent((int)value);
                bnView.setBottomIndent((int)value);
                bnView.setY((int)value);
            }
        }
    }

    @Override
    public Rectangle modelToView(long offset, Rectangle rect, boolean isBack) {
        IView view = this.getView(offset, 7, isBack);
        if (view != null) {
            view.modelToView(offset, rect, isBack);
        }
        rect.x += this.getX();
        rect.y += this.getY();
        return rect;
    }

    @Override
    public long viewToModel(int x, int y, boolean isBack) {
        IView view = this.getView(x -= this.getX(), y -= this.getY(), 7, isBack);
        if (view == null) {
            view = x > this.getWidth() ? this.getLastView() : this.getChildView();
        }
        if (view != null) {
            return view.viewToModel(x, y, isBack);
        }
        return -1L;
    }

    @Override
    public void draw(Canvas canvas, int originX, int originY, float zoom) {
        canvas.save();
        IWord word = this.getContainer();
        int dX = (int)((float)this.x * zoom) + originX;
        int dY = (int)((float)this.y * zoom) + originY;
        IView view = this.getChildView();
        Rect clip = canvas.getClipBounds();
        if (this.getTopIndent() < 0 && word != null && word.getEditType() == 0) {
            canvas.clipRect((float)dX, (float)dY - (float)this.getTopIndent() * zoom, (float)dX + (float)this.getLayoutSpan((byte)0) * zoom, (float)dY - (float)this.getTopIndent() * zoom + (float)this.getLayoutSpan((byte)1) * zoom);
        }
        while (view != null) {
            if (view.intersection(clip, dX, dY, zoom)) {
                view.draw(canvas, dX, dY, zoom);
            }
            view = view.getNextView();
        }
        canvas.restore();
        this.drawUnderline(canvas, originX, originY, zoom);
        if (word != null && word.getHighlight() != null) {
            word.getHighlight().draw(canvas, this, dX, dY, this.getStartOffset(null), this.getEndOffset(null), zoom);
        }
    }

    private void drawUnderline(Canvas canvas, int originX, int originY, float zoom) {
        Paint paint = new Paint();
        int dX = (int)((float)this.x * zoom) + originX;
        int dY = (int)((float)this.y * zoom + (float)originY + (float)this.getTopIndent() * zoom);
        LeafView leaf = (LeafView)this.getChildView();
        int w = 0;
        int color2 = Integer.MAX_VALUE;
        int baseline = 0;
        while (leaf != null) {
            CharAttr charAttr = leaf.getCharAttr();
            if (charAttr == null) {
                leaf = (LeafView)leaf.getNextView();
                continue;
            }
            if (charAttr.underlineType > 0) {
                if (color2 != Integer.MAX_VALUE && color2 != charAttr.underlineColor) {
                    paint.setColor(color2);
                    canvas.drawRect((float)dX, (float)(dY + baseline + 1), (float)(dX + w), (float)(dY + baseline + 2), paint);
                    dX += w;
                    color2 = charAttr.underlineColor;
                    w = 0;
                    baseline = 0;
                } else if (color2 == Integer.MAX_VALUE) {
                    color2 = charAttr.underlineColor;
                }
                w += (int)((float)leaf.getWidth() * zoom);
                baseline = Math.max(baseline, (int)((float)leaf.getUnderlinePosition() * zoom));
            } else {
                if (color2 != Integer.MAX_VALUE) {
                    paint.setColor(color2);
                    canvas.drawRect((float)dX, (float)(dY + baseline + 1), (float)(dX + w), (float)(dY + baseline + 2), paint);
                    dX += w;
                    w = 0;
                    baseline = 0;
                }
                dX += (int)((float)leaf.getWidth() * zoom);
                color2 = Integer.MAX_VALUE;
            }
            leaf = (LeafView)leaf.getNextView();
        }
        if (color2 != Integer.MAX_VALUE) {
            paint.setColor(color2);
            canvas.drawRect((float)dX, (float)(dY + baseline + 1), (float)(dX + w), (float)(dY + baseline + 2), paint);
        }
    }

    @Override
    public void free() {
    }

    @Override
    public void dispose() {
        super.dispose();
    }
}

