/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.wp.control;

import android.view.MotionEvent;
import android.view.View;
import com.ahmadullahpk.alldocumentreader.xs.common.hyperlink.Hyperlink;
import com.ahmadullahpk.alldocumentreader.xs.common.picture.PictureKit;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectangle;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.AttrManage;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.IElement;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import com.ahmadullahpk.alldocumentreader.xs.system.beans.AEventManage;
import com.ahmadullahpk.alldocumentreader.xs.wp.control.Word;

public class WPEventManage
extends AEventManage {
    private int oldX;
    private int oldY;
    protected Word word;

    public WPEventManage(Word word, IControl control) {
        super(word.getContext(), control);
        this.word = word;
    }

    @Override
    public boolean onTouch(View v, MotionEvent event) {
        try {
            super.onTouch(v, event);
            int action = event.getAction();
            switch (action) {
                case 0: {
                    PictureKit.instance().setDrawPictrue(true);
                    this.processDown(v, event);
                    break;
                }
                case 2: {
                    break;
                }
                case 1: {
                    if (this.zoomChange) {
                        this.zoomChange = false;
                        if (this.word.getCurrentRootType() == 0) {
                            this.control.actionEvent(0x2000000A, null);
                        }
                        if (this.control.getMainFrame().isZoomAfterLayoutForWord()) {
                            this.control.actionEvent(0x30000005, null);
                        }
                    }
                    this.word.getControl().actionEvent(20, null);
                    break;
                }
            }
        }
        catch (Exception e) {
            this.control.getSysKit().getErrorKit().writerLog(e);
        }
        return false;
    }

    protected void processDown(View v, MotionEvent event) {
        int x = this.convertCoorForX(event.getX());
        int y = this.convertCoorForY(event.getY());
        long offset = this.word.viewToModel(x, y, false);
        if (this.word.getHighlight().isSelectText()) {
            this.word.getHighlight().removeHighlight();
            this.word.getStatus().setPressOffset(offset);
            this.word.postInvalidate();
        }
    }

    @Override
    public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
        if (this.word.getStatus().isSelectTextStatus()) {
            return true;
        }
        super.onScroll(e1, e2, distanceX, distanceY);
        boolean change = false;
        boolean isScrollX = Math.abs(distanceX) > Math.abs(distanceY);
        Rectangle r = this.word.getVisibleRect();
        int sX = r.x;
        int sY = r.y;
        float zoom = this.word.getZoom();
        int wW = 0;
        wW = this.word.getCurrentRootType() == 1 && this.control.getMainFrame().isZoomAfterLayoutForWord() ? (this.word.getWidth() == this.word.getWordWidth() ? this.word.getWidth() : (int)((float)this.word.getWordWidth() * zoom)) : (int)((float)this.word.getWordWidth() * zoom);
        int wH = (int)((float)this.word.getWordHeight() * zoom);
        if (isScrollX) {
            if (distanceX > 0.0f && sX + r.width < wW) {
                if ((sX = (int)((float)sX + distanceX)) + r.width > wW) {
                    sX = wW - r.width;
                }
                change = true;
            } else if (distanceX < 0.0f && sX > 0) {
                if ((sX = (int)((float)sX + distanceX)) < 0) {
                    sX = 0;
                }
                change = true;
            }
        } else if (distanceY > 0.0f && sY + r.height < wH) {
            if ((sY = (int)((float)sY + distanceY)) + r.height > wH) {
                sY = wH - r.height;
            }
            change = true;
        } else if (distanceY < 0.0f && sY > 0) {
            if ((sY = (int)((float)sY + distanceY)) < 0) {
                sY = 0;
            }
            change = true;
        }
        if (change) {
            this.isScroll = true;
            this.word.scrollTo(sX, sY);
        }
        return true;
    }

    @Override
    public void fling(int velocityX, int velocityY) {
        super.fling(velocityX, velocityY);
        Rectangle r = this.word.getVisibleRect();
        float zoom = this.word.getZoom();
        this.oldY = 0;
        this.oldX = 0;
        int wW = 0;
        wW = this.word.getCurrentRootType() == 1 && this.control.getMainFrame().isZoomAfterLayoutForWord() ? (this.word.getWidth() == this.word.getWordWidth() ? this.word.getWidth() : (int)((float)this.word.getWordWidth() * zoom) + 5) : (int)((float)this.word.getWordWidth() * zoom);
        if (Math.abs(velocityY) > Math.abs(velocityX)) {
            this.oldY = r.y;
            this.mScroller.fling(r.x, r.y, 0, velocityY, 0, r.x, 0, (int)((float)this.word.getWordHeight() * zoom) - r.height);
        } else {
            this.oldX = r.x;
            this.mScroller.fling(r.x, r.y, velocityX, 0, 0, wW - r.width, r.y, 0);
        }
        this.word.postInvalidate();
    }

    @Override
    public boolean onDoubleTapEvent(MotionEvent e) {
        super.onDoubleTapEvent(e);
        return true;
    }

    @Override
    public boolean onSingleTapUp(MotionEvent e) {
        Hyperlink hylink;
        int hyID;
        IElement leaf;
        int y;
        int x;
        long offset;
        super.onSingleTapUp(e);
        if (e.getAction() == 1 && (offset = this.word.viewToModel(x = this.convertCoorForX(e.getX()), y = this.convertCoorForY(e.getY()), false)) >= 0L && (leaf = this.word.getDocument().getLeaf(offset)) != null && (hyID = AttrManage.instance().getHperlinkID(leaf.getAttribute())) >= 0 && (hylink = this.control.getSysKit().getHyperlinkManage().getHyperlink(hyID)) != null) {
            this.control.actionEvent(0x20000008, hylink);
        }
        return true;
    }

    @Override
    public void computeScroll() {
        super.computeScroll();
        if (this.mScroller.computeScrollOffset()) {
            this.isFling = true;
            PictureKit.instance().setDrawPictrue(false);
            int sX = this.mScroller.getCurrX();
            int sY = this.mScroller.getCurrY();
            if (this.oldX == sX && this.oldY == sY || sX == this.word.getScrollX() && sY == this.word.getScrollY()) {
                PictureKit.instance().setDrawPictrue(true);
                this.mScroller.abortAnimation();
                this.word.postInvalidate();
                return;
            }
            this.oldX = sX;
            this.oldY = sY;
            this.word.scrollTo(sX, sY);
        } else if (!PictureKit.instance().isDrawPictrue()) {
            PictureKit.instance().setDrawPictrue(true);
            this.word.postInvalidate();
        }
    }

    protected int convertCoorForX(float x) {
        return (int)((x + (float)this.word.getScrollX()) / this.word.getZoom());
    }

    protected int convertCoorForY(float y) {
        return (int)((y + (float)this.word.getScrollY()) / this.word.getZoom());
    }

    @Override
    public void dispose() {
        super.dispose();
        this.word = null;
    }
}

