/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.io;

import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.io.DecodingInputStream;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.io.EncodingException;
import java.io.IOException;
import java.io.InputStream;

public class Base64InputStream
extends DecodingInputStream {
    private int[] b = new int[3];
    private int bIndex;
    private int bLength;
    private boolean endReached;
    private int lineNo;
    private InputStream in;
    private static final int ILLEGAL = -1;
    private static final int LINEFEED = -3;
    private static final int CARRIAGERETURN = -4;
    private static final int EQUALS = -5;
    private static final byte[] base64toInt = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -2, -3, -1, -1, -4, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -5, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1};

    public Base64InputStream(InputStream input) {
        this.in = input;
        this.endReached = false;
        this.bIndex = 0;
        this.bLength = 0;
        this.lineNo = 1;
    }

    @Override
    public int read() throws IOException {
        if (this.bIndex >= this.bLength) {
            if (this.endReached) {
                return -1;
            }
            this.bLength = this.readTuple();
            if (this.bLength <= 0) {
                return -1;
            }
            this.bIndex = 0;
        }
        int a = this.b[this.bIndex];
        ++this.bIndex;
        if (a < 0 || a > 255) {
            throw new EncodingException(this.getClass() + " internal error, byte output out of range: " + a);
        }
        return a;
    }

    public int getLineNo() {
        return this.lineNo;
    }

    private int readTuple() throws IOException, EncodingException {
        byte[] c = new byte[4];
        int cIndex = 0;
        byte encoding = 0;
        byte prevEncoding = 0;
        int i = 0;
        if (this.endReached) {
            return 0;
        }
        block11: while (i < c.length) {
            int ch = this.in.read();
            if (ch < 0) {
                this.endReached = true;
                if (cIndex == 0) {
                    return 0;
                }
                throw new EncodingException("Improperly padded Base64 Input.");
            }
            prevEncoding = encoding;
            encoding = base64toInt[ch & 0x7F];
            switch (encoding) {
                case -1: {
                    if (ch < 0) {
                        throw new EncodingException("Illegal character in Base64 encoding '" + ch + "'.");
                    }
                }
                case -5: {
                    ++i;
                    continue block11;
                }
                case -4: {
                    ++this.lineNo;
                    continue block11;
                }
                case -3: {
                    if (prevEncoding == -4) continue block11;
                    ++this.lineNo;
                    continue block11;
                }
            }
            c[cIndex] = (byte)(encoding & 0xFF);
            ++cIndex;
            ++i;
        }
        switch (cIndex) {
            case 2: {
                int data = c[0] << 18 | c[1] << 12;
                this.b[0] = data >>> 16 & 0xFF;
                return 1;
            }
            case 3: {
                int data = c[0] << 18 | c[1] << 12 | c[2] << 6;
                this.b[0] = data >>> 16 & 0xFF;
                this.b[1] = data >>> 8 & 0xFF;
                return 2;
            }
            case 4: {
                int data = c[0] << 18 | c[1] << 12 | c[2] << 6 | c[3];
                this.b[0] = data >>> 16 & 0xFF;
                this.b[1] = data >>> 8 & 0xFF;
                this.b[2] = data & 0xFF;
                return 3;
            }
        }
        throw new EncodingException("Base64InputStream: internal error.");
    }
}

