/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.data;

import com.ahmadullahpk.alldocumentreader.xs.simpletext.font.Font;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.EMFConstants;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.EMFInputStream;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.EMFRenderer;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.data.GDIObject;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.data.LogFontW;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.data.Panose;
import java.io.IOException;

public class ExtLogFontW
implements EMFConstants,
GDIObject {
    private LogFontW font;
    private String fullName;
    private String style;
    private int version;
    private int styleSize;
    private int match;
    private byte[] vendorID;
    private int culture;
    private Panose panose;

    public ExtLogFontW(LogFontW font, String fullName, String style2, int version, int styleSize, int match, byte[] vendorID, int culture, Panose panose) {
        this.font = font;
        this.fullName = fullName;
        this.style = style2;
        this.version = version;
        this.styleSize = styleSize;
        this.match = match;
        this.vendorID = vendorID;
        this.culture = culture;
        this.panose = panose;
    }

    public ExtLogFontW(Font font) {
        this.font = new LogFontW(font);
        this.fullName = "";
        this.style = "";
        this.version = 0;
        this.styleSize = 0;
        this.match = 0;
        this.vendorID = new byte[]{0, 0, 0, 0};
        this.culture = 0;
        this.panose = new Panose();
    }

    public ExtLogFontW(EMFInputStream emf) throws IOException {
        this.font = new LogFontW(emf);
        this.fullName = emf.readWCHAR(64);
        this.style = emf.readWCHAR(32);
        this.version = emf.readDWORD();
        this.styleSize = emf.readDWORD();
        this.match = emf.readDWORD();
        emf.readDWORD();
        this.vendorID = emf.readBYTE(4);
        this.culture = emf.readDWORD();
        this.panose = new Panose(emf);
        emf.readWORD();
        emf.popBuffer();
    }

    public String toString() {
        return super.toString() + "\n  LogFontW\n" + this.font.toString() + "\n    fullname: " + this.fullName + "\n    style: " + this.style + "\n    version: " + this.version + "\n    stylesize: " + this.styleSize + "\n    match: " + this.match + "\n    vendorID: " + this.vendorID + "\n    culture: " + this.culture + "\n" + this.panose.toString();
    }

    @Override
    public void render(EMFRenderer renderer) {
        renderer.setFont(this.font.getFont());
        renderer.setEscapement(this.font.getEscapement());
    }
}

