/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf;

import android.graphics.Bitmap;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Color;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.EMFInputStream;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.data.BitmapInfoHeader;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.emf.data.BlendFunction;
import java.io.IOException;
import java.util.Arrays;

public class EMFImageLoader {
    public static Bitmap readImage(BitmapInfoHeader bmi, int width, int height, EMFInputStream emf, int len, BlendFunction blendFunction) throws IOException {
        if (bmi.getBitCount() == 1) {
            int blue = emf.readUnsignedByte();
            int green = emf.readUnsignedByte();
            int red = emf.readUnsignedByte();
            emf.readUnsignedByte();
            int color1 = new Color(red, green, blue).getRGB();
            blue = emf.readUnsignedByte();
            green = emf.readUnsignedByte();
            red = emf.readUnsignedByte();
            emf.readUnsignedByte();
            int color2 = new Color(red, green, blue).getRGB();
            Bitmap result = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.RGB_565);
            int[] data = emf.readUnsignedByte(len - 8);
            int strangeOffset = width % 8;
            if (strangeOffset != 0) {
                strangeOffset = 8 - strangeOffset;
            }
            int pixel = 0;
            int[] mask = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
            for (int y = height - 1; y > -1; --y) {
                for (int x = 0; x < width; ++x) {
                    int pixelDataGroup = data[pixel / 8];
                    int pixelData = pixelDataGroup & mask[pixel % 8];
                    ++pixel;
                    if (pixelData > 0) {
                        result.setPixel(x, y, color2);
                        continue;
                    }
                    result.setPixel(x, y, color1);
                }
                pixel += strangeOffset;
            }
            return result;
        }
        if (bmi.getBitCount() == 4 && bmi.getCompression() == 0) {
            int colorsUsed = bmi.getClrUsed();
            int[] colors = emf.readUnsignedByte(colorsUsed * 4);
            int[] data = new int[len - colorsUsed * 4];
            for (int i = 0; i < (len - colorsUsed * 4) / 12; ++i) {
                int[] bytes = emf.readUnsignedByte(10);
                emf.readUnsignedByte(2);
                System.arraycopy(bytes, 0, data, i * 10, 10);
            }
            int[] colorTable = new int[256];
            int color2 = 0;
            int i = 0;
            while (i < colorsUsed) {
                colorTable[i] = new Color(colors[color2 + 2], colors[color2 + 1], colors[color2]).getRGB();
                color2 = ++i * 4;
            }
            if (colorsUsed < 256) {
                Arrays.fill(colorTable, colorsUsed, 256, 0);
            }
            Bitmap result = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            int pixel = 0;
            for (int y = height - 1; y > -1; --y) {
                for (int x = 0; x < width && pixel < data.length; ++pixel, x += 2) {
                    result.setPixel(x, y, colorTable[data[pixel] % 8]);
                    result.setPixel(x + 1, y, colorTable[data[pixel] % 8]);
                }
            }
            return result;
        }
        if (bmi.getBitCount() == 8 && bmi.getCompression() == 0) {
            int strangeOffset;
            int colorsUsed = bmi.getClrUsed();
            int[] colors = emf.readUnsignedByte(colorsUsed * 4);
            int[] data = emf.readUnsignedByte(len - colorsUsed * 4);
            int[] colorTable = new int[256];
            int color3 = 0;
            int i = 0;
            while (i < colorsUsed) {
                colorTable[i] = new Color(colors[color3 + 2], colors[color3 + 1], colors[color3]).getRGB();
                color3 = ++i * 4;
            }
            if (colorsUsed < 256) {
                Arrays.fill(colorTable, colorsUsed, 256, 0);
            }
            if ((strangeOffset = width % 4) != 0) {
                strangeOffset = 4 - strangeOffset;
            }
            Bitmap result = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.RGB_565);
            int pixel = 0;
            for (int y = height - 1; y > -1; --y) {
                for (int x = 0; x < width; ++x) {
                    result.setPixel(x, y, colorTable[data[pixel++]]);
                }
                pixel += strangeOffset;
            }
            return result;
        }
        if (bmi.getBitCount() == 16 && bmi.getCompression() == 0) {
            int[] data = emf.readDWORD(len / 4);
            width = (width + width % 2) / 2;
            height = data.length / width / 2;
            Bitmap result = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.RGB_565);
            int off = 0;
            int y = height - 1;
            while (y > -1) {
                for (int x = 0; x < width; ++x) {
                    int neighbor = data[off + width];
                    int pixel = data[off++];
                    result.setPixel(x, y, new Color((float)((pixel & 0x7C00) + (neighbor & 0x7C00)) / 63488.0f, (float)((pixel & 0x3E0) + (neighbor & 0x3E0)) / 1984.0f, (float)((pixel & 0x1F) + (neighbor & 0x1F)) / 62.0f).getRGB());
                }
                --y;
                off += width;
            }
            return result;
        }
        if (bmi.getBitCount() == 32 && bmi.getCompression() == 0) {
            Bitmap result = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.RGB_565);
            len /= 4;
            int off = 0;
            int sourceConstantAlpha = 255;
            int alphaFormat = 0;
            if (blendFunction != null) {
                sourceConstantAlpha = blendFunction.getSourceConstantAlpha();
                alphaFormat = blendFunction.getAlphaFormat();
            }
            if (alphaFormat != 1) {
                for (int y = height - 1; y > -1 && off < len; --y) {
                    for (int x = 0; x < width && off < len; ++x, ++off) {
                        int pixel = emf.readDWORD();
                        result.setPixel(x, y, new Color((pixel & 0xFF0000) >> 16, (pixel & 0xFF00) >> 8, pixel & 0xFF, sourceConstantAlpha).getRGB());
                    }
                }
            } else if (sourceConstantAlpha == 255) {
                for (int y = height - 1; y > -1 && off < len; --y) {
                    for (int x = 0; x < width && off < len; ++x, ++off) {
                        int pixel = emf.readDWORD();
                        int alpha = (pixel & 0xFF000000) >> 24;
                        if (alpha == -1) {
                            alpha = 255;
                        }
                        result.setPixel(x, y, new Color((pixel & 0xFF0000) >> 16, (pixel & 0xFF00) >> 8, pixel & 0xFF, alpha).getRGB());
                    }
                }
            } else {
                for (int y = height - 1; y > -1 && off < len; --y) {
                    for (int x = 0; x < width && off < len; ++x, ++off) {
                        int pixel = emf.readDWORD();
                        int alpha = (pixel & 0xFF000000) >> 24;
                        if (alpha == -1) {
                            alpha = 255;
                        }
                        alpha = alpha * sourceConstantAlpha / 255;
                        result.setPixel(x, y, new Color((pixel & 0xFF0000) >> 16, (pixel & 0xFF00) >> 8, pixel & 0xFF, alpha).getRGB());
                    }
                }
            }
            return result;
        }
        if (bmi.getBitCount() == 32 && bmi.getCompression() == 3) {
            emf.readByte(len);
            return null;
        }
        emf.readByte(len);
        return null;
    }
}

