/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.renderers;

import android.graphics.Paint;
import com.ahmadullahpk.alldocumentreader.xs.common.bg.BackgroundAndFill;
import com.ahmadullahpk.alldocumentreader.xs.common.borders.Line;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.renderers.DefaultRenderer;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.renderers.SimpleSeriesRenderer;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class XYMultipleSeriesRenderer
extends DefaultRenderer {
    private String mXTitle = "";
    private String[] mYTitle;
    private float mXTitleTextSize = 12.0f;
    private float mYTitleTextSize = 12.0f;
    private double[] mMinX;
    private double[] mMaxX;
    private double[] mMinY;
    private double[] mMaxY;
    private int mXLabels = 5;
    private int mYLabels = 7;
    private Orientation mOrientation = Orientation.HORIZONTAL;
    private Map<Double, String> mXTextLabels = new HashMap<Double, String>();
    private Map<Integer, Map<Double, String>> mYTextLabels = new LinkedHashMap<Integer, Map<Double, String>>();
    private boolean mPanXEnabled = true;
    private boolean mPanYEnabled = true;
    private boolean mZoomXEnabled = true;
    private boolean mZoomYEnabled = true;
    private double mBarSpacing = 0.0;
    private int mMarginsColor = 0;
    private double[] mPanLimits;
    private double[] mZoomLimits;
    private float mXLabelsAngle;
    private float mYLabelsAngle;
    private Map<Integer, double[]> initialRange = new LinkedHashMap<Integer, double[]>();
    private float mPointSize = 5.0f;
    private BackgroundAndFill seriesFill = null;
    private Line seriesFrame = null;
    private int mGridColor = -16777216;
    private int scalesCount;
    private Paint.Align xLabelsAlign = Paint.Align.CENTER;
    private Paint.Align[] yLabelsAlign;
    private Paint.Align[] yAxisAlign;

    public XYMultipleSeriesRenderer() {
        this(1);
    }

    public XYMultipleSeriesRenderer(int scaleNumber) {
        this.scalesCount = scaleNumber;
        this.initAxesRange(scaleNumber);
    }

    public void initAxesRange(int scales) {
        this.mYTitle = new String[scales];
        this.yLabelsAlign = new Paint.Align[scales];
        this.yAxisAlign = new Paint.Align[scales];
        this.mMinX = new double[scales];
        this.mMaxX = new double[scales];
        this.mMinY = new double[scales];
        this.mMaxY = new double[scales];
        for (int i = 0; i < scales; ++i) {
            this.initAxesRangeForScale(i);
        }
    }

    public void initAxesRangeForScale(int i) {
        this.mMinX[i] = Double.MAX_VALUE;
        this.mMaxX[i] = -1.7976931348623157E308;
        this.mMinY[i] = Double.MAX_VALUE;
        this.mMaxY[i] = -1.7976931348623157E308;
        double[] range = new double[]{this.mMinX[i], this.mMaxX[i], this.mMinY[i], this.mMaxY[i]};
        this.initialRange.put(i, range);
        this.mYTitle[i] = "";
        this.mYTextLabels.put(i, new HashMap());
        this.yLabelsAlign[i] = Paint.Align.CENTER;
        this.yAxisAlign[i] = Paint.Align.LEFT;
    }

    public Orientation getOrientation() {
        return this.mOrientation;
    }

    public void setOrientation(Orientation orientation) {
        this.mOrientation = orientation;
    }

    public String getXTitle() {
        return this.mXTitle;
    }

    public void setXTitle(String title) {
        this.mXTitle = title;
    }

    public String getYTitle() {
        return this.getYTitle(0);
    }

    public String getYTitle(int scale) {
        return this.mYTitle[scale];
    }

    public void setYTitle(String title) {
        this.setYTitle(title, 0);
    }

    public void setYTitle(String title, int scale) {
        this.mYTitle[scale] = title;
    }

    public float getXTitleTextSize() {
        return this.mXTitleTextSize;
    }

    public void setXTitleTextSize(float textSize) {
        this.mXTitleTextSize = textSize;
    }

    public float getYTitleTextSize() {
        return this.mYTitleTextSize;
    }

    public void setYTitleTextSize(float textSize) {
        this.mYTitleTextSize = textSize;
    }

    public double getXAxisMin() {
        return this.getXAxisMin(0);
    }

    public void setXAxisMin(double min) {
        this.setXAxisMin(min, 0);
    }

    public boolean isMinXSet() {
        return this.isMinXSet(0);
    }

    public double getXAxisMax() {
        return this.getXAxisMax(0);
    }

    public void setXAxisMax(double max) {
        this.setXAxisMax(max, 0);
    }

    public boolean isMaxXSet() {
        return this.isMaxXSet(0);
    }

    public double getYAxisMin() {
        return this.getYAxisMin(0);
    }

    public void setYAxisMin(double min) {
        this.setYAxisMin(min, 0);
    }

    public boolean isMinYSet() {
        return this.isMinYSet(0);
    }

    public double getYAxisMax() {
        return this.getYAxisMax(0);
    }

    public void setYAxisMax(double max) {
        this.setYAxisMax(max, 0);
    }

    public boolean isMaxYSet() {
        return this.isMaxYSet(0);
    }

    public double getXAxisMin(int scale) {
        return this.mMinX[scale];
    }

    public void setXAxisMin(double min, int scale) {
        if (!this.isMinXSet(scale)) {
            this.initialRange.get((Object)Integer.valueOf((int)scale))[0] = min;
        }
        this.mMinX[scale] = min;
    }

    public boolean isMinXSet(int scale) {
        return this.mMinX[scale] != Double.MAX_VALUE;
    }

    public double getXAxisMax(int scale) {
        return this.mMaxX[scale];
    }

    public void setXAxisMax(double max, int scale) {
        if (!this.isMaxXSet(scale)) {
            this.initialRange.get((Object)Integer.valueOf((int)scale))[1] = max;
        }
        this.mMaxX[scale] = max;
    }

    public boolean isMaxXSet(int scale) {
        return this.mMaxX[scale] != -1.7976931348623157E308;
    }

    public double getYAxisMin(int scale) {
        return this.mMinY[scale];
    }

    public void setYAxisMin(double min, int scale) {
        if (!this.isMinYSet(scale)) {
            this.initialRange.get((Object)Integer.valueOf((int)scale))[2] = min;
        }
        this.mMinY[scale] = min;
    }

    public boolean isMinYSet(int scale) {
        return this.mMinY[scale] != Double.MAX_VALUE;
    }

    public double getYAxisMax(int scale) {
        return this.mMaxY[scale];
    }

    public void setYAxisMax(double max, int scale) {
        if (!this.isMaxYSet(scale)) {
            this.initialRange.get((Object)Integer.valueOf((int)scale))[3] = max;
        }
        this.mMaxY[scale] = max;
    }

    public boolean isMaxYSet(int scale) {
        return this.mMaxY[scale] != -1.7976931348623157E308;
    }

    public int getXLabels() {
        return this.mXLabels;
    }

    public void setXLabels(int xLabels) {
        this.mXLabels = xLabels;
    }

    public int getXTextLabels() {
        return this.mXTextLabels.size();
    }

    public void addTextLabel(double x, String text) {
        this.addXTextLabel(x, text);
    }

    public void addXTextLabel(double x, String text) {
        this.mXTextLabels.put(x, text);
    }

    public String getXTextLabel(Double x) {
        return this.mXTextLabels.get(x);
    }

    public Double[] getXTextLabelLocations() {
        return this.mXTextLabels.keySet().toArray(new Double[0]);
    }

    public void clearTextLabels() {
        this.clearXTextLabels();
    }

    public void clearXTextLabels() {
        this.mXTextLabels.clear();
    }

    public void addYTextLabel(double y, String text) {
        this.addYTextLabel(y, text, 0);
    }

    public void addYTextLabel(double y, String text, int scale) {
        this.mYTextLabels.get(scale).put(y, text);
    }

    public String getYTextLabel(Double y) {
        return this.getYTextLabel(y, 0);
    }

    public String getYTextLabel(Double y, int scale) {
        return this.mYTextLabels.get(scale).get(y);
    }

    public Double[] getYTextLabelLocations() {
        return this.getYTextLabelLocations(0);
    }

    public Double[] getYTextLabelLocations(int scale) {
        return this.mYTextLabels.get(scale).keySet().toArray(new Double[0]);
    }

    public void clearYTextLabels() {
        this.mYTextLabels.clear();
    }

    public int getYLabels() {
        return this.mYLabels;
    }

    public void setYLabels(int yLabels) {
        this.mYLabels = yLabels;
    }

    public void setDisplayChartValues(boolean display) {
        SimpleSeriesRenderer[] renderers;
        for (SimpleSeriesRenderer renderer : renderers = this.getSeriesRenderers()) {
            renderer.setDisplayChartValues(display);
        }
    }

    public void setChartValuesTextSize(float textSize) {
        SimpleSeriesRenderer[] renderers;
        for (SimpleSeriesRenderer renderer : renderers = this.getSeriesRenderers()) {
            renderer.setChartValuesTextSize(textSize);
        }
    }

    @Override
    public boolean isPanEnabled() {
        return this.isPanXEnabled() && this.isPanYEnabled();
    }

    public boolean isPanXEnabled() {
        return this.mPanXEnabled;
    }

    public boolean isPanYEnabled() {
        return this.mPanYEnabled;
    }

    public void setPanEnabled(boolean enabledX, boolean enabledY) {
        this.mPanXEnabled = enabledX;
        this.mPanYEnabled = enabledY;
    }

    @Override
    public boolean isZoomEnabled() {
        return this.isZoomXEnabled() || this.isZoomYEnabled();
    }

    public boolean isZoomXEnabled() {
        return this.mZoomXEnabled;
    }

    public boolean isZoomYEnabled() {
        return this.mZoomYEnabled;
    }

    public void setZoomEnabled(boolean enabledX, boolean enabledY) {
        this.mZoomXEnabled = enabledX;
        this.mZoomYEnabled = enabledY;
    }

    public double getBarsSpacing() {
        return this.getBarSpacing();
    }

    public double getBarSpacing() {
        return this.mBarSpacing;
    }

    public void setBarSpacing(double spacing) {
        this.mBarSpacing = spacing;
    }

    public int getMarginsColor() {
        return this.mMarginsColor;
    }

    public void setMarginsColor(int color2) {
        this.mMarginsColor = color2;
    }

    public BackgroundAndFill getSeriesBackgroundColor() {
        return this.seriesFill;
    }

    public void setSeriesBackgroundColor(BackgroundAndFill fill) {
        this.seriesFill = fill;
    }

    public Line getSeriesFrame() {
        return this.seriesFrame;
    }

    public void setSeriesFrame(Line seriesFrame) {
        this.seriesFrame = seriesFrame;
    }

    public int getGridColor() {
        return this.mGridColor;
    }

    public void setGridColor(int color2) {
        this.mGridColor = color2;
    }

    public double[] getPanLimits() {
        return this.mPanLimits;
    }

    public void setPanLimits(double[] panLimits) {
        this.mPanLimits = panLimits;
    }

    public double[] getZoomLimits() {
        return this.mZoomLimits;
    }

    public void setZoomLimits(double[] zoomLimits) {
        this.mZoomLimits = zoomLimits;
    }

    public float getXLabelsAngle() {
        return this.mXLabelsAngle;
    }

    public void setXLabelsAngle(float angle) {
        this.mXLabelsAngle = angle;
    }

    public float getYLabelsAngle() {
        return this.mYLabelsAngle;
    }

    public void setYLabelsAngle(float angle) {
        this.mYLabelsAngle = angle;
    }

    public float getPointSize() {
        return this.mPointSize;
    }

    public void setPointSize(float size) {
        this.mPointSize = size;
    }

    public void setRange(double[] range) {
        this.setRange(range, 0);
    }

    public void setRange(double[] range, int scale) {
        this.setXAxisMin(range[0], scale);
        this.setXAxisMax(range[1], scale);
        this.setYAxisMin(range[2], scale);
        this.setYAxisMax(range[3], scale);
    }

    public boolean isInitialRangeSet() {
        return this.isInitialRangeSet(0);
    }

    public boolean isInitialRangeSet(int scale) {
        return this.initialRange.get(scale) != null;
    }

    public double[] getInitialRange() {
        return this.getInitialRange(0);
    }

    public double[] getInitialRange(int scale) {
        return this.initialRange.get(scale);
    }

    public void setInitialRange(double[] range) {
        this.setInitialRange(range, 0);
    }

    public void setInitialRange(double[] range, int scale) {
        this.initialRange.put(scale, range);
    }

    public Paint.Align getXLabelsAlign() {
        return this.xLabelsAlign;
    }

    public void setXLabelsAlign(Paint.Align align) {
        this.xLabelsAlign = align;
    }

    public Paint.Align getYLabelsAlign(int scale) {
        return this.yLabelsAlign[scale];
    }

    public void setYLabelsAlign(Paint.Align align) {
        this.setYLabelsAlign(align, 0);
    }

    public Paint.Align getYAxisAlign(int scale) {
        return this.yAxisAlign[scale];
    }

    public void setYAxisAlign(Paint.Align align, int scale) {
        this.yAxisAlign[scale] = align;
    }

    public void setYLabelsAlign(Paint.Align align, int scale) {
        this.yLabelsAlign[scale] = align;
    }

    public int getScalesCount() {
        return this.scalesCount;
    }

    public static enum Orientation {
        HORIZONTAL(0),
        VERTICAL(90);

        private int mAngle = 0;

        private Orientation(int angle) {
            this.mAngle = angle;
        }

        public int getAngle() {
            return this.mAngle;
        }
    }
}

