/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.chart;

import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.Typeface;
import com.ahmadullahpk.alldocumentreader.xs.common.BackgroundDrawer;
import com.ahmadullahpk.alldocumentreader.xs.common.bg.BackgroundAndFill;
import com.ahmadullahpk.alldocumentreader.xs.common.borders.Line;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectangle;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.chart.AbstractChart;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.chart.ScatterChart;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.model.XYMultipleSeriesDataset;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.model.XYSeries;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.renderers.BasicStroke;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.renderers.SimpleSeriesRenderer;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.renderers.XYMultipleSeriesRenderer;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.util.MathHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class XYChart
extends AbstractChart {
    protected XYMultipleSeriesDataset mDataset;
    protected XYMultipleSeriesRenderer mRenderer;
    private float mScale;
    private float mTranslate;
    private PointF mCenter;
    private Rect mScreenR;
    private Map<Integer, double[]> mCalcRange = new HashMap<Integer, double[]>();
    protected static final int SHAPE_WIDTH = 12;

    protected XYChart() {
    }

    public XYChart(XYMultipleSeriesDataset dataset, XYMultipleSeriesRenderer renderer) {
        this.mDataset = dataset;
        this.mRenderer = renderer;
    }

    protected void setDatasetRenderer(XYMultipleSeriesDataset dataset, XYMultipleSeriesRenderer renderer) {
        this.mDataset = dataset;
        this.mRenderer = renderer;
    }

    @Override
    public void setZoomRate(float rate) {
        this.mRenderer.setZoomRate(rate);
    }

    @Override
    public float getZoomRate() {
        return this.mRenderer.getZoomRate();
    }

    protected void drawSeriesBackgroundAndFrame(XYMultipleSeriesRenderer renderer, Canvas canvas, Rect rect, Paint paint) {
        Line frame;
        int alpha = paint.getAlpha();
        Path path = new Path();
        path.addRect((float)rect.left, (float)rect.top, (float)rect.right, (float)rect.bottom, Path.Direction.CCW);
        BackgroundAndFill fill = renderer.getSeriesBackgroundColor();
        if (fill != null) {
            paint.setStyle(Paint.Style.FILL);
            BackgroundDrawer.drawPathBackground(canvas, null, 1, fill, rect, null, 1.0f, path, paint);
            paint.setAlpha(alpha);
        }
        if ((frame = renderer.getSeriesFrame()) != null) {
            paint.setStyle(Paint.Style.STROKE);
            paint.setStrokeWidth(2.0f);
            if (frame.isDash()) {
                DashPathEffect dashPathEffect = new DashPathEffect(new float[]{5.0f, 5.0f}, 10.0f);
                paint.setPathEffect((PathEffect)dashPathEffect);
            }
            BackgroundDrawer.drawPathBackground(canvas, null, 1, frame.getBackgroundAndFill(), rect, null, 1.0f, path, paint);
            paint.setStyle(Paint.Style.FILL);
            paint.setAlpha(alpha);
        }
        paint.reset();
        paint.setAntiAlias(true);
    }

    @Override
    public void draw(Canvas canvas, IControl control, int x, int y, int width, int height, Paint paint) {
        int i;
        int i2;
        int angle;
        XYMultipleSeriesRenderer.Orientation or;
        Rect rect = new Rect(x, y, x + width, y + height);
        canvas.save();
        canvas.clipRect(rect);
        paint.setAntiAlias(this.mRenderer.isAntialiasing());
        int preColor = paint.getColor();
        float preSize = paint.getStrokeWidth();
        this.drawBackgroundAndFrame(this.mRenderer, canvas, control, rect, paint);
        int legendHeight = this.mRenderer.getLegendHeight();
        if (this.mRenderer.isShowLegend() && legendHeight == 0) {
            legendHeight = height / 5;
        }
        int sLength = this.mDataset.getSeriesCount();
        String[] titles = new String[sLength];
        for (int i3 = 0; i3 < sLength; ++i3) {
            titles[i3] = this.mDataset.getSeriesAt(i3).getTitle();
        }
        Rectangle titleAreaSize = this.getTitleTextAreaSize(this.mRenderer, width, height, paint);
        Rectangle xTitleAreaSize = this.getXTitleTextAreaSize(width, height, paint);
        Rectangle yTitleAreaSize = this.getYTitleTextAreaSize(width, height, paint);
        int legendH = height;
        if (titleAreaSize != null) {
            legendH -= titleAreaSize.height;
        }
        Rectangle legendSize = this.getLegendAutoSize(this.mRenderer, titles, width, legendH, paint);
        double[] margins = this.mRenderer.getMargins();
        int left = x + (int)(margins[1] * (double)width + (double)(this.mRenderer.getYTitleTextSize() * this.mRenderer.getZoomRate()));
        if (yTitleAreaSize != null) {
            left += yTitleAreaSize.width;
        }
        int top = y + (int)(margins[0] * (double)height);
        if (titleAreaSize != null) {
            top += titleAreaSize.height;
        }
        int right = x + width - (int)(margins[3] * (double)width);
        if (legendSize != null && (this.legendPos == 0 || this.legendPos == 2)) {
            right -= legendSize.width;
        }
        int bottom = y + height - (int)(margins[2] * (double)height);
        if (legendSize != null && (this.legendPos == 1 || this.legendPos == 3)) {
            bottom -= legendSize.height;
        }
        if (xTitleAreaSize != null) {
            bottom -= xTitleAreaSize.height;
        }
        paint.setTextSize(this.mRenderer.getLabelsTextSize() * this.mRenderer.getZoomRate());
        Paint.FontMetrics fm = paint.getFontMetrics();
        bottom = (int)((float)bottom - (fm.descent - fm.ascent));
        if (paint.getTypeface() == null || !paint.getTypeface().toString().equals(this.mRenderer.getTextTypefaceName()) || paint.getTypeface().getStyle() != this.mRenderer.getTextTypefaceStyle()) {
            paint.setTypeface(Typeface.create((String)this.mRenderer.getTextTypefaceName(), (int)this.mRenderer.getTextTypefaceStyle()));
        }
        if ((or = this.mRenderer.getOrientation()) == XYMultipleSeriesRenderer.Orientation.VERTICAL) {
            right -= legendHeight;
            bottom += legendHeight - 20;
        }
        boolean rotate = (angle = or.getAngle()) == 90;
        this.mScale = (float)height / (float)width;
        this.mTranslate = Math.abs(width - height) / 2;
        if (this.mScale < 1.0f) {
            this.mTranslate *= -1.0f;
        }
        this.mCenter = new PointF((float)((x + width) / 2), (float)((y + height) / 2));
        if (rotate) {
            this.transform(canvas, angle, false);
        }
        int maxScaleNumber = -2147483647;
        for (int i4 = 0; i4 < sLength; ++i4) {
            maxScaleNumber = Math.max(maxScaleNumber, this.mDataset.getSeriesAt(i4).getScaleNumber());
        }
        if (++maxScaleNumber < 0) {
            canvas.restore();
            return;
        }
        double[] minX = new double[maxScaleNumber];
        double[] maxX = new double[maxScaleNumber];
        double[] minY = new double[maxScaleNumber];
        double[] maxY = new double[maxScaleNumber];
        boolean[] isMinXSet = new boolean[maxScaleNumber];
        boolean[] isMaxXSet = new boolean[maxScaleNumber];
        boolean[] isMinYSet = new boolean[maxScaleNumber];
        boolean[] isMaxYSet = new boolean[maxScaleNumber];
        for (int i5 = 0; i5 < maxScaleNumber; ++i5) {
            minX[i5] = this.mRenderer.getXAxisMin(i5);
            maxX[i5] = this.mRenderer.getXAxisMax(i5);
            minY[i5] = this.mRenderer.getYAxisMin(i5);
            maxY[i5] = this.mRenderer.getYAxisMax(i5);
            isMinXSet[i5] = this.mRenderer.isMinXSet(i5);
            isMaxXSet[i5] = this.mRenderer.isMaxXSet(i5);
            isMinYSet[i5] = this.mRenderer.isMinYSet(i5);
            isMaxYSet[i5] = this.mRenderer.isMaxYSet(i5);
            if (this.mCalcRange.get(i5) != null) continue;
            this.mCalcRange.put(i5, new double[4]);
        }
        HashMap<Integer, List<Double>> allYLabels = new HashMap<Integer, List<Double>>();
        for (i2 = 0; i2 < maxScaleNumber; ++i2) {
            paint.setTextSize(this.mRenderer.getLabelsTextSize() * this.mRenderer.getZoomRate());
            fm = paint.getFontMetrics();
            float yLabelHeight = fm.descent - fm.ascent;
            int lines = (int)((float)(bottom - top) / yLabelHeight) / 2;
            int approxNumLabels = Math.min(this.mRenderer.getYLabels(), lines);
            allYLabels.put(i2, this.getValidLabels(MathHelper.getLabels(minY[i2], maxY[i2], approxNumLabels)));
        }
        for (i2 = 0; i2 < maxScaleNumber; ++i2) {
            if (!(Math.abs(minY[i2]) > 0.001)) continue;
            List yLabels = (List)allYLabels.get(i2);
            double miny = (Double)yLabels.get(0) - ((Double)yLabels.get(1) - (Double)yLabels.get(0));
            if (!(minY[i2] > 0.0) || !(miny > 0.0)) continue;
            minY[i2] = miny;
        }
        float yLabelMaxWidth = 0.0f;
        paint.setTextSize(this.mRenderer.getLabelsTextSize() * this.mRenderer.getZoomRate());
        for (int i6 = 0; i6 < maxScaleNumber; ++i6) {
            List yLabels = (List)allYLabels.get(i6);
            int length = yLabels.size();
            for (int j = 0; j < length; ++j) {
                double label = (Double)yLabels.get(j);
                minY[i6] = Math.min(minY[i6], label);
                maxY[i6] = Math.max(maxY[i6], label);
                yLabelMaxWidth = Math.max(yLabelMaxWidth, paint.measureText(this.getLabel(label)));
            }
        }
        left = (int)((float)left + yLabelMaxWidth);
        if (this.mScreenR == null) {
            this.mScreenR = new Rect();
        }
        this.mScreenR.set(left, top, right, bottom);
        this.drawSeriesBackgroundAndFrame(this.mRenderer, canvas, this.mScreenR, paint);
        double[] xPixelsPerUnit = new double[maxScaleNumber];
        double[] yPixelsPerUnit = new double[maxScaleNumber];
        for (i = 0; i < sLength; ++i) {
            XYSeries series = this.mDataset.getSeriesAt(i);
            int scale = series.getScaleNumber();
            if (series.getItemCount() == 0) continue;
            if (!isMinXSet[scale]) {
                double minimumX = series.getMinX();
                minX[scale] = Math.min(minX[scale], minimumX);
                this.mCalcRange.get((Object)Integer.valueOf((int)scale))[0] = minX[scale];
            }
            if (!isMaxXSet[scale]) {
                double maximumX = series.getMaxX();
                maxX[scale] = Math.max(maxX[scale], maximumX);
                this.mCalcRange.get((Object)Integer.valueOf((int)scale))[1] = maxX[scale];
            }
            if (!isMinYSet[scale]) {
                double minimumY = series.getMinY();
                minY[scale] = Math.min(minY[scale], (double)((float)minimumY));
                this.mCalcRange.get((Object)Integer.valueOf((int)scale))[2] = minY[scale];
            }
            if (isMaxYSet[scale]) continue;
            double maximumY = series.getMaxY();
            maxY[scale] = Math.max(maxY[scale], (double)((float)maximumY));
            this.mCalcRange.get((Object)Integer.valueOf((int)scale))[3] = maxY[scale];
        }
        for (i = 0; i < maxScaleNumber; ++i) {
            if (maxX[i] - minX[i] != 0.0) {
                xPixelsPerUnit[i] = (double)(right - left) / (maxX[i] - minX[i]);
            }
            if (maxY[i] - minY[i] == 0.0) continue;
            yPixelsPerUnit[i] = (float)((double)(bottom - top) / (maxY[i] - minY[i]));
        }
        float off = Math.max(this.mRenderer.getZoomRate() / 2.0f, 0.5f);
        boolean hasValues = false;
        for (int i7 = 0; i7 < sLength; ++i7) {
            if (this.mDataset.getSeriesAt(i7).getItemCount() <= 0) continue;
            hasValues = true;
            break;
        }
        boolean showLabels = this.mRenderer.isShowLabels() && hasValues;
        boolean showGrid = this.mRenderer.isShowGridH();
        boolean showCustomTextGrid = this.mRenderer.isShowCustomTextGrid();
        if (showLabels || showGrid) {
            int i8;
            List<Object> xLabels;
            if (!this.getChartType().equals("Scatter")) {
                xLabels = new ArrayList();
                for (double xLabel = minX[0] + 1.0; xLabel <= maxX[0]; xLabel += 1.0) {
                    xLabels.add(Math.floor(xLabel));
                }
            } else {
                xLabels = this.getValidLabels(MathHelper.getLabels(minX[0], maxX[0], this.mRenderer.getXLabels()));
                minX[0] = (Double)xLabels.get(0);
                maxX[0] = (Double)xLabels.get(xLabels.size() - 1);
                xPixelsPerUnit[0] = (double)(right - left) / (maxX[0] - minX[0]);
            }
            int xLabelsLeft = left;
            if (showLabels) {
                paint.setColor(this.mRenderer.getLabelsColor());
                paint.setTextSize(this.mRenderer.getLabelsTextSize() * this.mRenderer.getZoomRate());
                paint.setTextAlign(this.mRenderer.getXLabelsAlign());
                if (this.mRenderer.getXLabelsAlign() == Paint.Align.LEFT) {
                    xLabelsLeft = (int)((float)xLabelsLeft + this.mRenderer.getLabelsTextSize() / 4.0f);
                }
            }
            float yAxeX = bottom;
            if (minY[0] < 0.0) {
                yAxeX = (float)((double)bottom + yPixelsPerUnit[0] * minY[0]);
            }
            if (!this.getChartType().equals("Scatter")) {
                this.drawXLabels(xLabels, this.mRenderer.getXTextLabelLocations(), canvas, paint, xLabelsLeft, top, yAxeX, xPixelsPerUnit[0], minX[0]);
            } else {
                this.drawXLabels(xLabels, null, canvas, paint, xLabelsLeft, top, yAxeX, xPixelsPerUnit[0], minX[0]);
            }
            for (i8 = 0; i8 < maxScaleNumber; ++i8) {
                paint.setTextAlign(this.mRenderer.getYLabelsAlign(i8));
                List yLabels = (List)allYLabels.get(i8);
                if (Math.abs((Double)yLabels.get(0) - minY[0]) > (double)1.0E-6f) {
                    yLabels.add(minY[0]);
                }
                int length = yLabels.size();
                for (int j = 0; j < length; ++j) {
                    double label = (Double)yLabels.get(j);
                    Paint.Align axisAlign = this.mRenderer.getYAxisAlign(i8);
                    boolean textLabel = this.mRenderer.getYTextLabel(label, i8) != null;
                    float yLabel = (float)((double)bottom - yPixelsPerUnit[i8] * (label - minY[i8]));
                    if (or == XYMultipleSeriesRenderer.Orientation.HORIZONTAL) {
                        if (showLabels && !textLabel) {
                            paint.setColor(this.mRenderer.getLabelsColor());
                            if (axisAlign == Paint.Align.LEFT) {
                                this.drawText(canvas, this.getLabel(label), (float)left - paint.measureText(this.getLabel(label)), yLabel, paint, this.mRenderer.getYLabelsAngle());
                            } else {
                                this.drawText(canvas, this.getLabel(label), right, yLabel - 2.0f, paint, this.mRenderer.getYLabelsAngle());
                            }
                        }
                        if (!showGrid) continue;
                        paint.setColor(this.mRenderer.getGridColor());
                        canvas.drawRect((float)left, yLabel - off, (float)right, yLabel + off, paint);
                        continue;
                    }
                    if (or != XYMultipleSeriesRenderer.Orientation.VERTICAL) continue;
                    if (showLabels && !textLabel) {
                        paint.setColor(this.mRenderer.getLabelsColor());
                        this.drawText(canvas, this.getLabel(label), right + 10, yLabel - 2.0f, paint, this.mRenderer.getYLabelsAngle());
                    }
                    if (!showGrid) continue;
                    paint.setColor(this.mRenderer.getGridColor());
                    canvas.drawRect((float)right, (float)(Math.round(yLabel) - 1), (float)left, (float)Math.round(yLabel), paint);
                }
            }
            if (showLabels) {
                paint.setColor(this.mRenderer.getLabelsColor());
                for (i8 = 0; i8 < maxScaleNumber; ++i8) {
                    Double[] yTextLabelLocations;
                    Paint.Align axisAlign = this.mRenderer.getYAxisAlign(i8);
                    for (Double location : yTextLabelLocations = this.mRenderer.getYTextLabelLocations(i8)) {
                        if (!(minY[i8] <= location) || !(location <= maxY[i8])) continue;
                        float yLabel = (float)((double)bottom - yPixelsPerUnit[i8] * (location - minY[i8]));
                        String label = this.mRenderer.getYTextLabel(location, i8);
                        paint.setColor(this.mRenderer.getLabelsColor());
                        if (or == XYMultipleSeriesRenderer.Orientation.HORIZONTAL) {
                            if (axisAlign == Paint.Align.LEFT) {
                                canvas.drawLine((float)(left + this.getLabelLinePos(axisAlign)), yLabel, (float)left, yLabel, paint);
                                this.drawText(canvas, label, left, yLabel - 2.0f, paint, this.mRenderer.getYLabelsAngle());
                            } else {
                                canvas.drawLine((float)right, yLabel, (float)(right + this.getLabelLinePos(axisAlign)), yLabel, paint);
                                this.drawText(canvas, label, right, yLabel - 2.0f, paint, this.mRenderer.getYLabelsAngle());
                            }
                            if (!showCustomTextGrid) continue;
                            paint.setColor(this.mRenderer.getGridColor());
                            canvas.drawLine((float)left, yLabel, (float)right, yLabel, paint);
                            continue;
                        }
                        canvas.drawLine((float)(right - this.getLabelLinePos(axisAlign)), yLabel, (float)right, yLabel, paint);
                        this.drawText(canvas, label, right + 10, yLabel - 2.0f, paint, this.mRenderer.getYLabelsAngle());
                        if (!showCustomTextGrid) continue;
                        paint.setColor(this.mRenderer.getGridColor());
                        canvas.drawLine((float)right, yLabel, (float)left, yLabel, paint);
                    }
                }
            }
            if (showLabels) {
                paint.setColor(this.mRenderer.getLabelsColor());
                paint.setTextAlign(Paint.Align.CENTER);
                paint.setFakeBoldText(true);
                if (or == XYMultipleSeriesRenderer.Orientation.HORIZONTAL) {
                    if (this.mRenderer.isShowChartTitle()) {
                        paint.setTextSize(this.mRenderer.getChartTitleTextSize() * this.mRenderer.getZoomRate());
                        Rectangle maxTitleAreaSize = this.getMaxTitleAreaSize(width, height);
                        this.drawTitle(canvas, this.mRenderer.getChartTitle(), 1.0f, x + width / 2, (float)y + this.mRenderer.getChartTitleTextSize() * this.mRenderer.getZoomRate() * 2.0f, maxTitleAreaSize.width, maxTitleAreaSize.height, paint, 0.0f);
                    }
                    if (yTitleAreaSize != null) {
                        paint.setTextSize(this.mRenderer.getYTitleTextSize() * this.mRenderer.getZoomRate());
                        float maxWidth = (float)height * 0.8f;
                        float maxHeight = (float)width * 0.2f;
                        float yTitleTop = y;
                        yTitleTop = titleAreaSize != null && yTitleAreaSize.height == (int)maxWidth ? (float)(y + titleAreaSize.height + height / 2) : (float)(y + height / 2);
                        this.drawTitle(canvas, this.mRenderer.getYTitle(), 1.0f, (float)x + this.mRenderer.getYTitleTextSize() * this.mRenderer.getZoomRate() * 1.5f, yTitleTop, maxWidth, maxHeight, paint, -90.0f);
                    }
                    if (xTitleAreaSize != null) {
                        float maxWidth = (float)width * 0.8f;
                        float maxHeight = (float)height * 0.2f;
                        paint.setTextSize(this.mRenderer.getXTitleTextSize() * this.mRenderer.getZoomRate());
                        fm = paint.getFontMetrics();
                        float xTitleLeft = x;
                        float yTitleTop = y + height - xTitleAreaSize.height;
                        xTitleLeft = yTitleAreaSize != null ? (float)(x + (width + yTitleAreaSize.width) / 2) : (float)(x + width / 2);
                        if (legendSize != null && (this.legendPos == 1 || this.legendPos == 3)) {
                            yTitleTop = y + height - legendSize.height - xTitleAreaSize.height;
                        }
                        this.drawTitle(canvas, this.mRenderer.getXTitle(), 1.0f, xTitleLeft, yTitleTop + fm.descent, maxWidth, maxHeight, paint, 0.0f);
                    }
                } else if (or == XYMultipleSeriesRenderer.Orientation.VERTICAL) {
                    this.drawText(canvas, this.mRenderer.getXTitle(), x + width / 2, y + height, paint, -90.0f);
                    this.drawText(canvas, this.mRenderer.getYTitle(), (float)right + 20.0f * this.mRenderer.getZoomRate(), y + height / 2, paint, 0.0f);
                    paint.setTextSize(this.mRenderer.getChartTitleTextSize() * this.mRenderer.getZoomRate());
                    this.drawText(canvas, this.mRenderer.getChartTitle(), x, top + height / 2, paint, 0.0f);
                }
                paint.setFakeBoldText(false);
            }
        }
        for (int i9 = 0; i9 < sLength; ++i9) {
            int originalValuesLength;
            XYSeries series = this.mDataset.getSeriesAt(i9);
            int scale = series.getScaleNumber();
            if (series.getItemCount() == 0) continue;
            SimpleSeriesRenderer seriesRenderer = this.mRenderer.getSeriesRendererAt(i9);
            int valuesLength = originalValuesLength = series.getItemCount();
            int length = valuesLength * 2;
            ArrayList<Float> points = new ArrayList<Float>();
            for (int j = 0; j < length; j += 2) {
                int index = j / 2;
                double yValue = series.getY(index);
                if (yValue != Double.MAX_VALUE) {
                    points.add(Float.valueOf((float)((double)left + xPixelsPerUnit[scale] * (series.getX(index) - minX[scale]))));
                    points.add(Float.valueOf((float)((double)bottom - yPixelsPerUnit[scale] * (yValue - minY[scale]))));
                    continue;
                }
                if (points.size() <= 0) continue;
                this.drawSeries(series, canvas, paint, points, seriesRenderer, Math.min((float)bottom, (float)((double)bottom + yPixelsPerUnit[scale] * minY[scale])), i9, or);
                points.clear();
            }
            if (points.size() <= 0) continue;
            this.drawSeries(series, canvas, paint, points, seriesRenderer, Math.min((float)bottom, (float)((double)bottom + yPixelsPerUnit[scale] * minY[scale])), i9, or);
            paint.setStyle(Paint.Style.FILL);
        }
        this.drawBackground(this.mRenderer, canvas, x, bottom, width, height - bottom, paint, true, this.mRenderer.getMarginsColor());
        this.drawBackground(this.mRenderer, canvas, x, y, width, (int)(margins[0] * (double)height), paint, true, this.mRenderer.getMarginsColor());
        if (or == XYMultipleSeriesRenderer.Orientation.HORIZONTAL) {
            this.drawBackground(this.mRenderer, canvas, x, y, left - x, height - y, paint, true, this.mRenderer.getMarginsColor());
            this.drawBackground(this.mRenderer, canvas, right, y, (int)(margins[3] * (double)width), height - y, paint, true, this.mRenderer.getMarginsColor());
        } else if (or == XYMultipleSeriesRenderer.Orientation.VERTICAL) {
            this.drawBackground(this.mRenderer, canvas, right, y, width - right, height - y, paint, true, this.mRenderer.getMarginsColor());
            this.drawBackground(this.mRenderer, canvas, x, y, left - x, height - y, paint, true, this.mRenderer.getMarginsColor());
        }
        if (or == XYMultipleSeriesRenderer.Orientation.HORIZONTAL) {
            if (this.mRenderer.isShowLegend()) {
                int legendWidth = legendSize.width;
                int legendHeight2 = Math.min(height, legendSize.height);
                int legendLeft = x;
                int legendTop = y;
                switch (this.getLegendPosition()) {
                    case 0: 
                    case 2: {
                        legendLeft = x + width - legendWidth - (int)(this.mRenderer.getLegendTextSize() * this.mRenderer.getZoomRate());
                        if (titleAreaSize != null) {
                            legendTop = y + (height + titleAreaSize.height) / 2;
                            break;
                        }
                        legendTop = y + (height - legendHeight2) / 2;
                        break;
                    }
                    case 1: 
                    case 3: {
                        legendLeft = x + (width - legendWidth) / 2;
                        legendTop = y + height - legendHeight2;
                    }
                }
                this.drawLegend(canvas, this.mRenderer, titles, legendLeft, legendTop, legendWidth, legendHeight2, paint, false);
            }
        } else if (or == XYMultipleSeriesRenderer.Orientation.VERTICAL) {
            this.transform(canvas, angle, true);
            this.drawLegend(canvas, this.mRenderer, titles, x + 2, y, width, height, paint, false);
            this.transform(canvas, angle, false);
        }
        if (this.mRenderer.isShowAxes()) {
            paint.setColor(this.mRenderer.getAxesColor());
            paint.setFakeBoldText(true);
            float yAxeX = bottom;
            if (minY[0] < 0.0) {
                yAxeX = (float)((double)bottom + yPixelsPerUnit[0] * minY[0]);
            }
            canvas.drawRect((float)left, (float)Math.round(bottom) - off, (float)right, (float)Math.round(bottom) + off, paint);
            boolean rightAxis = false;
            for (int i10 = 0; i10 < maxScaleNumber && !rightAxis; ++i10) {
                rightAxis = this.mRenderer.getYAxisAlign(i10) == Paint.Align.RIGHT;
            }
            if (or == XYMultipleSeriesRenderer.Orientation.HORIZONTAL) {
                canvas.drawRect((float)left - off, (float)top, (float)left + off, (float)bottom, paint);
                if (rightAxis) {
                    canvas.drawRect((float)right - off, (float)top, (float)right + off, (float)bottom, paint);
                }
            } else if (or == XYMultipleSeriesRenderer.Orientation.VERTICAL) {
                canvas.drawRect((float)right - off, (float)top, (float)right + off, (float)bottom, paint);
            }
            paint.setFakeBoldText(false);
        }
        if (rotate) {
            this.transform(canvas, angle, true);
        }
        paint.setColor(preColor);
        paint.setStrokeWidth(preSize);
        canvas.restore();
    }

    protected Rect getScreenR() {
        return this.mScreenR;
    }

    protected void setScreenR(Rect screenR) {
        this.mScreenR = screenR;
    }

    private List<Double> getValidLabels(List<Double> labels) {
        ArrayList<Double> result = new ArrayList<Double>(labels);
        for (Double label : labels) {
            if (!label.isNaN()) continue;
            result.remove(label);
        }
        return result;
    }

    protected void drawSeries(XYSeries series, Canvas canvas, Paint paint, List<Float> pointsList, SimpleSeriesRenderer seriesRenderer, float yAxisValue, int seriesIndex, XYMultipleSeriesRenderer.Orientation or) {
        ScatterChart pointsChart;
        BasicStroke stroke = seriesRenderer.getStroke();
        Paint.Cap cap = paint.getStrokeCap();
        Paint.Join join = paint.getStrokeJoin();
        float miter = paint.getStrokeMiter();
        PathEffect pathEffect = paint.getPathEffect();
        Paint.Style style2 = paint.getStyle();
        if (stroke != null) {
            DashPathEffect effect = null;
            if (stroke.getIntervals() != null) {
                effect = new DashPathEffect(stroke.getIntervals(), stroke.getPhase());
            }
            this.setStroke(stroke.getCap(), stroke.getJoin(), stroke.getMiter(), Paint.Style.FILL_AND_STROKE, (PathEffect)effect, paint);
        }
        float[] points = MathHelper.getFloats(pointsList);
        this.drawSeries(canvas, paint, points, seriesRenderer, yAxisValue, seriesIndex);
        if (this.isRenderPoints(seriesRenderer) && (pointsChart = this.getPointsChart()) != null) {
            pointsChart.drawSeries(canvas, paint, points, seriesRenderer, yAxisValue, seriesIndex);
        }
        paint.setTextSize(seriesRenderer.getChartValuesTextSize());
        if (or == XYMultipleSeriesRenderer.Orientation.HORIZONTAL) {
            paint.setTextAlign(Paint.Align.CENTER);
        } else {
            paint.setTextAlign(Paint.Align.LEFT);
        }
        if (seriesRenderer.isDisplayChartValues()) {
            this.drawChartValuesText(canvas, series, paint, points, seriesIndex);
        }
        if (stroke != null) {
            this.setStroke(cap, join, miter, style2, pathEffect, paint);
        }
    }

    private void setStroke(Paint.Cap cap, Paint.Join join, float miter, Paint.Style style2, PathEffect pathEffect, Paint paint) {
        paint.setStrokeCap(cap);
        paint.setStrokeJoin(join);
        paint.setStrokeMiter(miter);
        paint.setPathEffect(pathEffect);
        paint.setStyle(style2);
    }

    protected void drawChartValuesText(Canvas canvas, XYSeries series, Paint paint, float[] points, int seriesIndex) {
        for (int k = 0; k < points.length; k += 2) {
            this.drawText(canvas, this.getLabel(series.getY(k / 2)), points[k], points[k + 1] - 3.5f, paint, 0.0f);
        }
    }

    protected void drawText(Canvas canvas, String text, float x, float y, Paint paint, float extraAngle) {
        float angle = (float)(-this.mRenderer.getOrientation().getAngle()) + extraAngle;
        if (angle != 0.0f) {
            canvas.rotate(angle, x, y);
        }
        canvas.drawText(text, x, y, paint);
        if (angle != 0.0f) {
            canvas.rotate(-angle, x, y);
        }
    }

    private Rectangle getXTitleTextAreaSize(int chartWidth, int chartHeight, Paint paint) {
        if (this.mRenderer.getXTitle().length() > 0) {
            float maxWidth = (float)chartWidth * 0.8f;
            float maxHeight = (float)chartHeight * 0.2f;
            return this.getTextSize(this.mRenderer.getXTitle(), this.mRenderer.getXTitleTextSize() * this.mRenderer.getZoomRate(), maxWidth, maxHeight, paint);
        }
        return null;
    }

    private Rectangle getYTitleTextAreaSize(int chartWidth, int chartHeight, Paint paint) {
        if (this.mRenderer.getYTitle().length() > 0) {
            float maxWidth = (float)chartHeight * 0.8f;
            float maxHeight = (float)chartWidth * 0.2f;
            Rectangle size = this.getTextSize(this.mRenderer.getYTitle(), this.mRenderer.getXTitleTextSize() * this.mRenderer.getZoomRate(), maxWidth, maxHeight, paint);
            int w = size.width;
            size.width = size.height;
            size.height = w;
            return size;
        }
        return null;
    }

    private void transform(Canvas canvas, float angle, boolean inverse) {
        if (inverse) {
            canvas.scale(1.0f / this.mScale, this.mScale);
            canvas.translate(this.mTranslate, -this.mTranslate);
            canvas.rotate(-angle, this.mCenter.x, this.mCenter.y);
        } else {
            canvas.rotate(angle, this.mCenter.x, this.mCenter.y);
            canvas.translate(-this.mTranslate, this.mTranslate);
            canvas.scale(this.mScale, 1.0f / this.mScale);
        }
    }

    protected String getLabel(double label) {
        String text = "";
        text = label == (double)Math.round(label) ? Math.round(label) + "" : label + "";
        return text;
    }

    protected void drawXLabels(List<Double> xLabels, Double[] xTextLabelLocations, Canvas canvas, Paint paint, int left, int top, float bottom, double xPixelsPerUnit, double minX) {
        block7: {
            float off;
            boolean showCustomTextGrid;
            boolean showGrid;
            boolean showLabels;
            block6: {
                int length = xLabels.size();
                showLabels = this.mRenderer.isShowLabels();
                showGrid = this.mRenderer.isShowGridV();
                showCustomTextGrid = this.mRenderer.isShowCustomTextGrid();
                off = Math.max(this.mRenderer.getZoomRate() / 2.0f, 0.5f);
                if (xTextLabelLocations != null && xTextLabelLocations.length != 0) break block6;
                for (int i = 0; i < length; ++i) {
                    double label = xLabels.get(i);
                    float xLabel = (float)((double)left + xPixelsPerUnit * (label - minX));
                    if (showGrid) {
                        canvas.drawRect(xLabel - off, (float)top, xLabel + off, bottom + 4.0f * this.mRenderer.getZoomRate(), paint);
                    } else {
                        canvas.drawRect(xLabel - off, bottom, xLabel + off, bottom + 4.0f * this.mRenderer.getZoomRate(), paint);
                    }
                    this.drawText(canvas, this.getLabel(label), xLabel, bottom + this.mRenderer.getLabelsTextSize() * 4.0f / 3.0f * this.mRenderer.getZoomRate(), paint, this.mRenderer.getXLabelsAngle());
                    if (!showCustomTextGrid) continue;
                    paint.setColor(this.mRenderer.getGridColor());
                    canvas.drawRect(xLabel + (float)xPixelsPerUnit / 2.0f - off, bottom, xLabel + (float)xPixelsPerUnit / 2.0f + off, (float)top, paint);
                }
                break block7;
            }
            if (!showLabels) break block7;
            paint.setColor(this.mRenderer.getLabelsColor());
            for (Double location : xTextLabelLocations) {
                float xLabel = (float)((double)left + xPixelsPerUnit * (location - minX));
                paint.setColor(this.mRenderer.getLabelsColor());
                if (showGrid) {
                    canvas.drawRect(xLabel + (float)xPixelsPerUnit / 2.0f - off, (float)top, xLabel + (float)xPixelsPerUnit / 2.0f + off, bottom + 4.0f * this.mRenderer.getZoomRate(), paint);
                } else {
                    canvas.drawRect(xLabel + (float)xPixelsPerUnit / 2.0f - off, bottom, xLabel + (float)xPixelsPerUnit / 2.0f + off, bottom + 4.0f * this.mRenderer.getZoomRate(), paint);
                }
                this.drawText(canvas, this.mRenderer.getXTextLabel(location), xLabel, bottom + this.mRenderer.getLabelsTextSize() * this.mRenderer.getZoomRate(), paint, this.mRenderer.getXLabelsAngle());
                if (!showCustomTextGrid) continue;
                paint.setColor(this.mRenderer.getGridColor());
                canvas.drawRect(xLabel + (float)xPixelsPerUnit / 2.0f - off, bottom, xLabel + (float)xPixelsPerUnit / 2.0f + off, (float)top, paint);
            }
        }
    }

    public XYMultipleSeriesRenderer getRenderer() {
        return this.mRenderer;
    }

    public XYMultipleSeriesDataset getDataset() {
        return this.mDataset;
    }

    public double[] getCalcRange(int scale) {
        return this.mCalcRange.get(scale);
    }

    public void setCalcRange(double[] range, int scale) {
        this.mCalcRange.put(scale, range);
    }

    public double[] toRealPoint(float screenX, float screenY) {
        return this.toRealPoint(screenX, screenY, 0);
    }

    public double[] toScreenPoint(double[] realPoint) {
        return this.toScreenPoint(realPoint, 0);
    }

    private int getLabelLinePos(Paint.Align align) {
        int pos = 4;
        if (align == Paint.Align.LEFT) {
            pos = -pos;
        }
        return pos;
    }

    public double[] toRealPoint(float screenX, float screenY, int scale) {
        double realMinX = this.mRenderer.getXAxisMin(scale);
        double realMaxX = this.mRenderer.getXAxisMax(scale);
        double realMinY = this.mRenderer.getYAxisMin(scale);
        double realMaxY = this.mRenderer.getYAxisMax(scale);
        return new double[]{(double)(screenX - (float)this.mScreenR.left) * (realMaxX - realMinX) / (double)this.mScreenR.width() + realMinX, (double)((float)(this.mScreenR.top + this.mScreenR.height()) - screenY) * (realMaxY - realMinY) / (double)this.mScreenR.height() + realMinY};
    }

    public double[] toScreenPoint(double[] realPoint, int scale) {
        double realMinX = this.mRenderer.getXAxisMin(scale);
        double realMaxX = this.mRenderer.getXAxisMax(scale);
        double realMinY = this.mRenderer.getYAxisMin(scale);
        double realMaxY = this.mRenderer.getYAxisMax(scale);
        if (!(this.mRenderer.isMinXSet(scale) && this.mRenderer.isMaxXSet(scale) && this.mRenderer.isMinXSet(scale) && this.mRenderer.isMaxYSet(scale))) {
            double[] calcRange = this.getCalcRange(scale);
            realMinX = calcRange[0];
            realMaxX = calcRange[1];
            realMinY = calcRange[2];
            realMaxY = calcRange[3];
        }
        return new double[]{(realPoint[0] - realMinX) * (double)this.mScreenR.width() / (realMaxX - realMinX) + (double)this.mScreenR.left, (realMaxY - realPoint[1]) * (double)this.mScreenR.height() / (realMaxY - realMinY) + (double)this.mScreenR.top};
    }

    public abstract void drawSeries(Canvas var1, Paint var2, float[] var3, SimpleSeriesRenderer var4, float var5, int var6);

    public boolean isRenderPoints(SimpleSeriesRenderer renderer) {
        return false;
    }

    public double getDefaultMinimum() {
        return Double.MAX_VALUE;
    }

    public ScatterChart getPointsChart() {
        return null;
    }

    public abstract String getChartType();
}

