/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.chart;

import android.graphics.Canvas;
import android.graphics.Paint;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.chart.LineChart;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.model.XYMultipleSeriesDataset;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.renderers.XYMultipleSeriesRenderer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class TimeChart
extends LineChart {
    public static final String TYPE = "Time";
    public static final long DAY = 86400000L;
    private String mDateFormat;

    TimeChart() {
    }

    public TimeChart(XYMultipleSeriesDataset dataset, XYMultipleSeriesRenderer renderer) {
        super(dataset, renderer);
    }

    public String getDateFormat() {
        return this.mDateFormat;
    }

    public void setDateFormat(String format) {
        this.mDateFormat = format;
    }

    @Override
    protected void drawXLabels(List<Double> xLabels, Double[] xTextLabelLocations, Canvas canvas, Paint paint, int left, int top, float bottom, double xPixelsPerUnit, double minX) {
        int length = xLabels.size();
        if (length > 0) {
            boolean showLabels = this.mRenderer.isShowLabels();
            boolean showGrid = this.mRenderer.isShowGridH();
            DateFormat format = this.getDateFormat(xLabels.get(0), xLabels.get(length - 1));
            for (int i = 0; i < length; ++i) {
                long label = Math.round(xLabels.get(i));
                float xLabel = (float)((double)left + xPixelsPerUnit * ((double)label - minX));
                if (showLabels) {
                    paint.setColor(this.mRenderer.getLabelsColor());
                    canvas.drawLine(xLabel, bottom, xLabel, bottom + this.mRenderer.getLabelsTextSize() / 3.0f, paint);
                    this.drawText(canvas, format.format(new Date(label)), xLabel, bottom + this.mRenderer.getLabelsTextSize() * 4.0f / 3.0f, paint, this.mRenderer.getXLabelsAngle());
                }
                if (!showGrid) continue;
                paint.setColor(this.mRenderer.getGridColor());
                canvas.drawLine(xLabel, bottom, xLabel, (float)top, paint);
            }
        }
    }

    private DateFormat getDateFormat(double start, double end) {
        DateFormat format;
        if (this.mDateFormat != null) {
            format = null;
            try {
                format = new SimpleDateFormat(this.mDateFormat);
                return format;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        format = SimpleDateFormat.getDateInstance(2);
        double diff = end - start;
        if (diff > 8.64E7 && diff < 4.32E8) {
            format = SimpleDateFormat.getDateTimeInstance(3, 3);
        } else if (diff < 8.64E7) {
            format = SimpleDateFormat.getTimeInstance(2);
        }
        return format;
    }

    @Override
    public String getChartType() {
        return TYPE;
    }
}

