/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.chart;

import android.graphics.Canvas;
import android.graphics.Paint;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.chart.PointStyle;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.chart.ScatterChart;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.chart.XYChart;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.model.XYMultipleSeriesDataset;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.renderers.SimpleSeriesRenderer;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.renderers.XYMultipleSeriesRenderer;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.renderers.XYSeriesRenderer;

public class LineChart
extends XYChart {
    public static final String TYPE = "Line";
    private static final int SHAPE_WIDTH = 30;
    private ScatterChart pointsChart;

    LineChart() {
    }

    public LineChart(XYMultipleSeriesDataset dataset, XYMultipleSeriesRenderer renderer) {
        super(dataset, renderer);
        this.pointsChart = new ScatterChart(dataset, renderer);
    }

    @Override
    protected void setDatasetRenderer(XYMultipleSeriesDataset dataset, XYMultipleSeriesRenderer renderer) {
        super.setDatasetRenderer(dataset, renderer);
        this.pointsChart = new ScatterChart(dataset, renderer);
    }

    @Override
    public void drawSeries(Canvas canvas, Paint paint, float[] points, SimpleSeriesRenderer seriesRenderer, float yAxisValue, int seriesIndex) {
        int length = points.length;
        XYSeriesRenderer renderer = (XYSeriesRenderer)seriesRenderer;
        float lineWidth = paint.getStrokeWidth();
        paint.setStrokeWidth(Math.max(renderer.getLineWidth() * this.mRenderer.getZoomRate(), 1.0f));
        if (renderer.isFillBelowLine()) {
            paint.setColor(renderer.getFillBelowLineColor());
            int pLength = points.length;
            float[] fillPoints = new float[pLength + 4];
            System.arraycopy(points, 0, fillPoints, 0, length);
            fillPoints[0] = points[0] + 1.0f;
            fillPoints[length] = fillPoints[length - 2];
            fillPoints[length + 1] = yAxisValue;
            fillPoints[length + 2] = fillPoints[0];
            fillPoints[length + 3] = fillPoints[length + 1];
            paint.setStyle(Paint.Style.FILL);
            this.drawPath(canvas, fillPoints, paint, true);
        }
        paint.setColor(seriesRenderer.getColor());
        paint.setStyle(Paint.Style.STROKE);
        this.drawPath(canvas, points, paint, false);
        paint.setStyle(Paint.Style.FILL);
        paint.setStrokeWidth(lineWidth);
    }

    @Override
    public int getLegendShapeWidth(int seriesIndex) {
        return (int)this.getRenderer().getLegendTextSize();
    }

    @Override
    public void drawLegendShape(Canvas canvas, SimpleSeriesRenderer renderer, float x, float y, int seriesIndex, Paint paint) {
        if (this.isRenderPoints(renderer)) {
            this.pointsChart.setDrawFrameFlag(false);
            this.pointsChart.drawLegendShape(canvas, renderer, x, y, seriesIndex, paint);
        }
    }

    @Override
    public boolean isRenderPoints(SimpleSeriesRenderer renderer) {
        return ((XYSeriesRenderer)renderer).getPointStyle() != PointStyle.POINT;
    }

    @Override
    public ScatterChart getPointsChart() {
        return this.pointsChart;
    }

    @Override
    public String getChartType() {
        return TYPE;
    }
}

