/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.system.beans.CalloutView;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.view.MotionEvent;
import android.view.View;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import com.ahmadullahpk.alldocumentreader.xs.system.beans.CalloutView.CalloutManager;
import com.ahmadullahpk.alldocumentreader.xs.system.beans.CalloutView.IExportListener;
import com.ahmadullahpk.alldocumentreader.xs.system.beans.CalloutView.MyPaint;
import com.ahmadullahpk.alldocumentreader.xs.system.beans.CalloutView.PathInfo;
import java.util.List;

public class CalloutView
extends View {
    private float zoom = 1.0f;
    private float mX;
    private float mY;
    private static final float TOUCH_TOLERANCE = 4.0f;
    private List<PathInfo> mPathList = null;
    private PathInfo mPathInfo = null;
    private final int offset = 5;
    private IExportListener mListener;
    private int left = 0;
    private int top = 0;
    private IControl control;
    private CalloutManager calloutMgr;
    private Runnable runnable = null;
    private int index = 0;

    public CalloutView(Context context, IControl control, IExportListener listener) {
        super(context);
        this.control = control;
        this.mListener = listener;
        this.calloutMgr = control.getSysKit().getCalloutManager();
    }

    public void setZoom(float zoom) {
        this.zoom = zoom;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        Rect clipRect = canvas.getClipBounds();
        this.mPathList = this.calloutMgr.getPath(this.index, false);
        if (this.mPathList != null) {
            for (int i = 0; i < this.mPathList.size(); ++i) {
                PathInfo pathInfo = this.mPathList.get(i);
                MyPaint paint = new MyPaint();
                paint.setStrokeWidth(pathInfo.width);
                paint.setColor(pathInfo.color);
                canvas.save();
                canvas.clipRect(this.left, this.top, clipRect.right, clipRect.bottom);
                canvas.scale(this.zoom, this.zoom);
                canvas.drawPath(pathInfo.path, (Paint)paint);
                canvas.restore();
            }
        }
    }

    public void setClip(int left, int top) {
        this.left = left;
        this.top = top;
    }

    private void touch_start(float x, float y) {
        this.mX = x /= this.zoom;
        this.mY = y /= this.zoom;
        if (this.calloutMgr.getDrawingMode() == 1) {
            this.mPathInfo = new PathInfo();
            this.mPathInfo.path = new Path();
            this.mPathInfo.path.moveTo(x, y);
            this.mPathInfo.color = this.calloutMgr.getColor();
            this.mPathInfo.width = this.calloutMgr.getWidth();
            this.mPathList = this.calloutMgr.getPath(this.index, true);
            this.mPathList.add(this.mPathInfo);
        }
    }

    private void touch_move(float x, float y) {
        if (this.calloutMgr.getDrawingMode() == 1) {
            float dx = Math.abs((x /= this.zoom) - this.mX);
            float dy = Math.abs((y /= this.zoom) - this.mY);
            if (dx >= 4.0f || dy >= 4.0f) {
                this.mPathInfo.path.quadTo(this.mX, this.mY, (x + this.mX) / 2.0f, (y + this.mY) / 2.0f);
                this.mX = x;
                this.mY = y;
            }
        }
    }

    private void touch_up() {
        if (this.calloutMgr.getDrawingMode() == 1) {
            this.mPathInfo.path.lineTo(this.mX, this.mY);
            this.mPathInfo.x = this.mX + 1.0f;
            this.mPathInfo.y = this.mY + 1.0f;
        } else if (this.calloutMgr.getDrawingMode() == 2 && this.mPathList != null) {
            for (int i = 0; i < this.mPathList.size(); ++i) {
                PathInfo pathInfo = this.mPathList.get(i);
                Path path = new Path(pathInfo.path);
                path.lineTo(pathInfo.x, pathInfo.y);
                RectF bounds = new RectF();
                path.computeBounds(bounds, false);
                Region region = new Region();
                region.setPath(path, new Region((int)bounds.left, (int)bounds.top, (int)bounds.right, (int)bounds.bottom));
                if (!region.op(new Region((int)this.mX - 5, (int)this.mY - 5, (int)this.mX + 5, (int)this.mY + 5), Region.Op.INTERSECT)) continue;
                this.mPathList.remove(i);
            }
        }
    }

    private void exportImage() {
        if (this.runnable != null) {
            this.removeCallbacks(this.runnable);
        }
        this.runnable = new Runnable(){

            @Override
            public void run() {
                CalloutView.this.mListener.exportImage();
            }
        };
        this.postDelayed(this.runnable, 1000L);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.calloutMgr.getDrawingMode() == 0) {
            return false;
        }
        float x = event.getX();
        float y = event.getY();
        switch (event.getAction()) {
            case 0: {
                this.touch_start(x, y);
                this.invalidate();
                break;
            }
            case 2: {
                this.touch_move(x, y);
                this.invalidate();
                break;
            }
            case 1: {
                this.touch_up();
                this.invalidate();
                this.exportImage();
            }
        }
        return true;
    }
}

