/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.system;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.net.Uri;
import android.os.Environment;
import android.os.StatFs;
import com.ahmadullahpk.alldocumentreader.xs.common.bookmark.BookmarkManage;
import com.ahmadullahpk.alldocumentreader.xs.common.borders.BordersManage;
import com.ahmadullahpk.alldocumentreader.xs.common.bulletnumber.ListManage;
import com.ahmadullahpk.alldocumentreader.xs.common.hyperlink.HyperlinkManage;
import com.ahmadullahpk.alldocumentreader.xs.common.picture.PictureManage;
import com.ahmadullahpk.alldocumentreader.xs.pg.animate.AnimationManager;
import com.ahmadullahpk.alldocumentreader.xs.pg.model.PGBulletText;
import com.ahmadullahpk.alldocumentreader.xs.system.ErrorUtil;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import com.ahmadullahpk.alldocumentreader.xs.system.beans.CalloutView.CalloutManager;
import com.ahmadullahpk.alldocumentreader.xs.wp.control.WPShapeManage;
import java.io.File;

public class SysKit {
    private ErrorUtil errorKit;
    private PictureManage pmKit;
    private HyperlinkManage hmKit;
    private ListManage lmKit;
    private PGBulletText pgLMKit;
    private BordersManage brKit;
    private WPShapeManage wpSMKit;
    private BookmarkManage bmKit;
    private IControl control;
    private static ShapeDrawable pageNumberDrawable;
    private AnimationManager animationMgr;
    private CalloutManager calloutMgr;

    public SysKit(IControl control) {
        this.control = control;
    }

    public File getSDPath() {
        if (new File("/mnt/extern_sd").exists() || new File("/mnt/usbhost1").exists()) {
            return new File("/mnt");
        }
        String state = Environment.getExternalStorageState();
        if ("mounted".equals(state)) {
            return Environment.getExternalStorageDirectory();
        }
        return null;
    }

    public long getAvailableStore(String filePath) {
        StatFs statFs = new StatFs(filePath);
        long blocSize = statFs.getBlockSize();
        long availaBlock = statFs.getAvailableBlocks();
        long availableSpare = availaBlock * blocSize;
        return availableSpare;
    }

    public boolean isVertical(Context context) {
        return context.getResources().getConfiguration().orientation == 1;
    }

    public String charsetEncode(String str, String encode) {
        if ("".equals(str)) {
            return "";
        }
        StringBuffer strBuff = new StringBuffer("");
        try {
            byte[] b = str.getBytes(encode);
            for (int n = 0; n < b.length; ++n) {
                str = Integer.toHexString(b[n] & 0xFF);
                if (str.length() == 1) {
                    strBuff.append("0").append(str);
                    continue;
                }
                strBuff.append(str);
            }
            char[] chs = strBuff.toString().toCharArray();
            strBuff.delete(0, strBuff.length());
            for (int i = 0; i < chs.length; i += 2) {
                strBuff.append("%").append(chs[i]).append(chs[i + 1]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return strBuff.toString();
    }

    public void internetSearch(String str, Activity activity) {
        str = this.charsetEncode(str, "utf-8");
        String url = "http://www.google.com.hk/#hl=en&newwindow=1&safe=strict&site=&q=a-a-a-a&oq=a-a-a-a&aq=f&aqi=&aql=&gs_sm=3&gs_upl=1075l1602l0l1935l3l3l0l0l0l0l0l0ll0l0&gs_l=hp.3...1075l1602l0l1935l3l3l0l0l0l0l0l0ll0l0&bav=on.2,or.r_gc.r_pw.,cf.osb&fp=207f1fbbc21b7536&biw=1280&bih=876";
        url = url.replaceAll("a-a-a-a", str);
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
        activity.startActivity(intent);
    }

    public boolean isDebug() {
        return false;
    }

    public IControl getControl() {
        return this.control;
    }

    public void setControl(IControl control) {
        this.control = control;
    }

    public static Drawable getPageNubmerDrawable() {
        if (pageNumberDrawable == null) {
            pageNumberDrawable = new ShapeDrawable((Shape)new RoundRectShape(new float[]{6.0f, 6.0f, 6.0f, 6.0f, 6.0f, 6.0f, 6.0f, 6.0f}, null, null));
            pageNumberDrawable.getPaint().setColor(-1996519356);
        }
        return pageNumberDrawable;
    }

    public static boolean isValidateRect(int pageWidth, int pageHeight, int x, int y, int width, int height) {
        return x >= 0 && y >= 0 && x < pageWidth && y < pageHeight && width >= 0 && height >= 0 && x + width <= pageWidth && y + height <= pageHeight;
    }

    public ErrorUtil getErrorKit() {
        if (this.errorKit == null) {
            this.errorKit = new ErrorUtil(this);
        }
        return this.errorKit;
    }

    public PictureManage getPictureManage() {
        if (this.pmKit == null) {
            this.pmKit = new PictureManage(this.control);
        }
        return this.pmKit;
    }

    public HyperlinkManage getHyperlinkManage() {
        if (this.hmKit == null) {
            this.hmKit = new HyperlinkManage();
        }
        return this.hmKit;
    }

    public ListManage getListManage() {
        if (this.lmKit == null) {
            this.lmKit = new ListManage();
        }
        return this.lmKit;
    }

    public PGBulletText getPGBulletText() {
        if (this.pgLMKit == null) {
            this.pgLMKit = new PGBulletText();
        }
        return this.pgLMKit;
    }

    public BordersManage getBordersManage() {
        if (this.brKit == null) {
            this.brKit = new BordersManage();
        }
        return this.brKit;
    }

    public WPShapeManage getWPShapeManage() {
        if (this.wpSMKit == null) {
            this.wpSMKit = new WPShapeManage();
        }
        return this.wpSMKit;
    }

    public BookmarkManage getBookmarkManage() {
        if (this.bmKit == null) {
            this.bmKit = new BookmarkManage();
        }
        return this.bmKit;
    }

    public AnimationManager getAnimationManager() {
        if (this.animationMgr == null) {
            this.animationMgr = new AnimationManager(this.control);
        }
        return this.animationMgr;
    }

    public CalloutManager getCalloutManager() {
        if (this.calloutMgr == null) {
            this.calloutMgr = new CalloutManager(this.control);
        }
        return this.calloutMgr;
    }

    public void dispose() {
        this.control = null;
        if (this.errorKit != null) {
            this.errorKit.dispose();
            this.errorKit = null;
        }
        if (this.pmKit != null) {
            this.pmKit.dispose();
            this.pmKit = null;
        }
        if (this.hmKit != null) {
            this.hmKit.dispose();
            this.hmKit = null;
        }
        if (this.lmKit != null) {
            this.lmKit.dispose();
            this.lmKit = null;
        }
        if (this.pgLMKit != null) {
            this.pgLMKit.dispose();
            this.pgLMKit = null;
        }
        if (this.brKit != null) {
            this.brKit.dispose();
            this.brKit = null;
        }
        if (this.wpSMKit != null) {
            this.wpSMKit.dispose();
            this.wpSMKit = null;
        }
        if (this.bmKit != null) {
            this.bmKit.dispose();
            this.bmKit = null;
        }
        if (this.animationMgr != null) {
            this.animationMgr.dispose();
            this.animationMgr = null;
        }
        if (this.calloutMgr != null) {
            this.calloutMgr.dispose();
            this.calloutMgr = null;
        }
    }
}

