/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.ss.control;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.ahmadullahpk.alldocumentreader.xs.ss.control.Spreadsheet;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Sheet;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Workbook;
import com.ahmadullahpk.alldocumentreader.xs.ss.sheetbar.SheetBar;
import com.ahmadullahpk.alldocumentreader.xs.ss.view.SheetView;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;

public class ExcelView
extends RelativeLayout {
    private boolean isDefaultSheetBar = true;
    private Spreadsheet ss;
    private SheetBar bar;
    private IControl control;

    public ExcelView(Context context, String filepath, Workbook book, IControl control) {
        super(context);
        this.control = control;
        this.ss = new Spreadsheet(context, filepath, book, control, this);
        this.addView((View)this.ss, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
    }

    public void init() {
        this.ss.init();
        this.initSheetbar();
    }

    private void initSheetbar() {
        if (!this.isDefaultSheetBar) {
            return;
        }
        this.bar = new SheetBar(this.getContext(), this.control, this.getResources().getDisplayMetrics().widthPixels);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        params.addRule(12);
        this.addView((View)this.bar, (ViewGroup.LayoutParams)params);
    }

    public Spreadsheet getSpreadsheet() {
        return this.ss;
    }

    public void showSheet(int sheetIndex) {
        this.ss.showSheet(sheetIndex);
        if (this.isDefaultSheetBar) {
            this.bar.setFocusSheetButton(sheetIndex);
        } else {
            this.control.getMainFrame().doActionEvent(0x40000004, sheetIndex);
        }
    }

    public void showSheet(String sheetName) {
        this.ss.showSheet(sheetName);
        Sheet sheet = this.ss.getWorkbook().getSheet(sheetName);
        if (sheet == null) {
            return;
        }
        int sheetIndex = this.ss.getWorkbook().getSheetIndex(sheet);
        if (this.isDefaultSheetBar) {
            this.bar.setFocusSheetButton(sheetIndex);
        } else {
            this.control.getMainFrame().doActionEvent(0x40000004, sheetIndex);
        }
    }

    public SheetView getSheetView() {
        return this.ss.getSheetView();
    }

    public void removeSheetBar() {
        this.isDefaultSheetBar = false;
        this.removeView((View)this.bar);
    }

    public int getBottomBarHeight() {
        if (this.isDefaultSheetBar) {
            return this.bar.getHeight();
        }
        return this.control.getMainFrame().getBottomBarHeight();
    }

    public int getCurrentViewIndex() {
        return this.ss.getCurrentSheetNumber();
    }

    public void dispose() {
        this.control = null;
        if (this.ss != null) {
            this.ss.dispose();
        }
        this.bar = null;
    }
}

