/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.simpletext.model;

import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.IAttributeSet;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.Style;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.StyleManage;

public class AttributeSetImpl
implements IAttributeSet {
    public static final int CAPACITY = 5;
    private int size = 0;
    private int ID;
    private short[] arrayID = new short[10];
    private int[] arrayValue = new int[10];

    @Override
    public int getID() {
        return this.ID;
    }

    @Override
    public void setAttribute(short attrID, int value) {
        int index;
        if (this.size >= this.arrayID.length) {
            this.ensureCapacity();
        }
        if ((index = this.getIDIndex(attrID)) >= 0) {
            this.arrayValue[index] = value;
        } else {
            this.arrayID[this.size] = attrID;
            this.arrayValue[this.size] = value;
            ++this.size;
        }
    }

    @Override
    public void removeAttribute(short attrID) {
        int index = this.getIDIndex(attrID);
        if (index >= 0) {
            for (int i = index + 1; i < this.size; ++i) {
                this.arrayID[i - 1] = this.arrayID[i];
                this.arrayValue[i - 1] = this.arrayValue[i];
            }
            --this.size;
        }
    }

    @Override
    public int getAttribute(short attrID) {
        return this.getAttribute(attrID, true);
    }

    private int getAttribute(short attrID, boolean pStyle) {
        int index = this.getIDIndex(attrID);
        if (index >= 0) {
            return this.arrayValue[index];
        }
        if (!pStyle) {
            return Integer.MIN_VALUE;
        }
        Style style2 = null;
        int value = Integer.MIN_VALUE;
        if (attrID < 4095 && (index = this.getIDIndex(0)) >= 0) {
            style2 = StyleManage.instance().getStyle(this.arrayValue[index]);
            value = this.getAttributeForStyle(style2, attrID);
        }
        if (value != Integer.MIN_VALUE) {
            return value;
        }
        index = this.getIDIndex(4096);
        if (index >= 0) {
            style2 = StyleManage.instance().getStyle(this.arrayValue[index]);
            value = this.getAttributeForStyle(style2, attrID);
        }
        return value;
    }

    private int getAttributeForStyle(Style style2, short attrID) {
        AttributeSetImpl attr = (AttributeSetImpl)style2.getAttrbuteSet();
        int value = attr.getAttribute(attrID, false);
        if (value != Integer.MIN_VALUE) {
            return value;
        }
        if (style2.getBaseID() >= 0) {
            style2 = StyleManage.instance().getStyle(style2.getBaseID());
            return this.getAttributeForStyle(style2, attrID);
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public void mergeAttribute(IAttributeSet attr) {
        if (!(attr instanceof AttributeSetImpl)) {
            return;
        }
        AttributeSetImpl attrSet = (AttributeSetImpl)attr;
        int len = attrSet.arrayID.length;
        for (int i = 0; i < len; ++i) {
            int index = this.getIDIndex(attrSet.arrayID[i]);
            if (index > 0) {
                this.arrayValue[index] = attrSet.arrayValue[i];
                continue;
            }
            if (this.size >= this.arrayID.length) {
                this.ensureCapacity();
            }
            this.arrayID[this.size] = attrSet.arrayID[i];
            this.arrayValue[this.size] = attrSet.arrayValue[i];
            ++this.size;
        }
    }

    @Override
    public IAttributeSet clone() {
        AttributeSetImpl attr = new AttributeSetImpl();
        attr.size = this.size;
        short[] aID = new short[this.size];
        System.arraycopy(this.arrayID, 0, aID, 0, this.size);
        attr.arrayID = aID;
        int[] aValue = new int[this.size];
        System.arraycopy(this.arrayValue, 0, aValue, 0, this.size);
        attr.arrayValue = aValue;
        return attr;
    }

    private int getIDIndex(int attrID) {
        for (int i = 0; i < this.size; ++i) {
            if (this.arrayID[i] != attrID) continue;
            return i;
        }
        return -1;
    }

    private void ensureCapacity() {
        int len = this.size + 5;
        short[] aID = new short[len];
        System.arraycopy(this.arrayID, 0, aID, 0, this.size);
        this.arrayID = aID;
        int[] aValue = new int[len];
        System.arraycopy(this.arrayValue, 0, aValue, 0, this.size);
        this.arrayValue = aValue;
    }

    @Override
    public void dispose() {
        this.arrayID = null;
        this.arrayValue = null;
    }
}

