/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.pg.control;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.FrameLayout;
import com.ahmadullahpk.alldocumentreader.xs.common.IOfficeToPicture;
import com.ahmadullahpk.alldocumentreader.xs.common.ISlideShow;
import com.ahmadullahpk.alldocumentreader.xs.common.picture.PictureKit;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Dimension;
import com.ahmadullahpk.alldocumentreader.xs.pg.animate.ShapeAnimation;
import com.ahmadullahpk.alldocumentreader.xs.pg.control.PGEditor;
import com.ahmadullahpk.alldocumentreader.xs.pg.control.PGEventManage;
import com.ahmadullahpk.alldocumentreader.xs.pg.control.PGFind;
import com.ahmadullahpk.alldocumentreader.xs.pg.control.PGPageListItem;
import com.ahmadullahpk.alldocumentreader.xs.pg.control.PGPrintMode;
import com.ahmadullahpk.alldocumentreader.xs.pg.model.PGModel;
import com.ahmadullahpk.alldocumentreader.xs.pg.model.PGNotes;
import com.ahmadullahpk.alldocumentreader.xs.pg.model.PGSlide;
import com.ahmadullahpk.alldocumentreader.xs.pg.view.SlideDrawKit;
import com.ahmadullahpk.alldocumentreader.xs.pg.view.SlideShowView;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.IDocument;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import com.ahmadullahpk.alldocumentreader.xs.system.IFind;
import com.ahmadullahpk.alldocumentreader.xs.system.SysKit;
import com.ahmadullahpk.alldocumentreader.xs.system.beans.CalloutView.CalloutView;
import com.ahmadullahpk.alldocumentreader.xs.system.beans.CalloutView.IExportListener;
import java.util.List;

public class Presentation
extends FrameLayout
implements IFind,
IExportListener {
    private boolean isConfigurationChanged;
    private boolean init;
    private int preShowSlideIndex = -1;
    private int currentIndex = -1;
    private int mWidth;
    private int mHeight;
    private float zoom = 1.0f;
    private PGFind pgFind;
    private PGEditor editor;
    private IControl control;
    private PGSlide currentSlide;
    private PGModel pgModel;
    private SlideShowView slideView;
    private PGEventManage eventManage;
    private boolean slideshow;
    private int slideIndex_SlideShow;
    private float fitZoom = 1.0f;
    private Rect slideSize = null;
    private PGPrintMode pgPrintMode;
    private CalloutView callouts;

    public Presentation(Activity activity, PGModel pgModel, IControl control) {
        super((Context)activity);
        this.control = control;
        this.pgModel = pgModel;
        this.setLongClickable(true);
        this.pgFind = new PGFind(this);
        this.editor = new PGEditor(this);
        this.pgPrintMode = new PGPrintMode((Context)activity, control, pgModel, this.editor);
        this.addView((View)this.pgPrintMode);
    }

    public void initCalloutView() {
        if (this.slideshow) {
            if (this.callouts == null) {
                this.callouts = new CalloutView(this.getContext(), this.control, this);
                this.callouts.setIndex(this.slideIndex_SlideShow);
                this.addView(this.callouts);
            }
        } else {
            this.pgPrintMode.getListView().getCurrentPageView().initCalloutView();
        }
    }

    @Override
    public void exportImage() {
        if (this.slideshow) {
            this.createPicture();
        } else {
            this.pgPrintMode.exportImage(this.pgPrintMode.getListView().getCurrentPageView(), null);
        }
    }

    public void init() {
        this.init = true;
        this.initSlidebar();
        this.pgPrintMode.init();
    }

    public void initSlidebar() {
    }

    public void setBackgroundColor(int color2) {
        super.setBackgroundColor(color2);
        if (this.pgPrintMode != null) {
            this.pgPrintMode.setBackgroundColor(color2);
        }
    }

    public void setBackgroundResource(int resid) {
        super.setBackgroundResource(resid);
        if (this.pgPrintMode != null) {
            this.pgPrintMode.setBackgroundResource(resid);
        }
    }

    public void setBackgroundDrawable(Drawable d) {
        super.setBackgroundDrawable(d);
        if (this.pgPrintMode != null) {
            this.pgPrintMode.setBackgroundDrawable(d);
        }
    }

    public void setViewVisible(boolean visible) {
        this.pgPrintMode.setVisible(visible);
    }

    public boolean showLoadingSlide() {
        if (this.currentIndex < this.getRealSlideCount()) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    Presentation.this.setViewVisible(true);
                }
            });
            this.pgPrintMode.showSlideForIndex(this.currentIndex);
            return true;
        }
        return false;
    }

    public void showSlide(int index, boolean find) {
        if (!find) {
            this.control.getMainFrame().setFindBackForwardState(false);
        }
        if (index >= this.pgModel.getSlideCount()) {
            return;
        }
        if (!this.slideshow) {
            this.currentIndex = index;
            if (index < this.getRealSlideCount()) {
                this.pgPrintMode.showSlideForIndex(index);
            } else {
                this.setViewVisible(false);
            }
        } else {
            int old = this.currentIndex;
            this.currentIndex = index;
            this.currentSlide = this.pgModel.getSlide(index);
            if (this.slideView == null) {
                this.slideView = new SlideShowView(this, this.currentSlide);
            }
            if (this.slideView != null) {
                this.slideView.changeSlide(this.currentSlide);
            }
            if (old != this.currentIndex) {
                this.control.actionEvent(20, null);
                SlideDrawKit.instance().disposeOldSlideView(this.pgModel, this.pgModel.getSlide(old));
            }
            this.postInvalidate();
            this.post(new Runnable(){

                @Override
                public void run() {
                    if (Presentation.this.control != null) {
                        Presentation.this.control.actionEvent(0x2000000A, null);
                    }
                }
            });
        }
    }

    protected void onDraw(Canvas canvas) {
        if (!this.init || !this.slideshow) {
            return;
        }
        try {
            this.slideView.drawSlide(canvas, this.fitZoom, this.callouts);
            if (this.control.isAutoTest()) {
                if (this.currentIndex < this.getRealSlideCount() - 1) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.showSlide(this.currentIndex + 1, false);
                } else {
                    this.control.actionEvent(22, true);
                }
            }
            if (this.preShowSlideIndex != this.currentIndex) {
                this.control.getMainFrame().changePage();
                this.preShowSlideIndex = this.currentIndex;
            }
        }
        catch (NullPointerException ex) {
            this.control.getSysKit().getErrorKit().writerLog(ex);
        }
    }

    public void createPicture() {
        IOfficeToPicture otp = this.control.getOfficeToPicture();
        if (otp != null && otp.getModeType() == 1) {
            try {
                this.toPicture(otp);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void toPicture(IOfficeToPicture otp) {
        if (!this.init || !this.slideshow) {
            PGPageListItem item = (PGPageListItem)this.pgPrintMode.getListView().getCurrentPageView();
            item.addRepaintImageView(null);
        } else if (this.slideView.animationStoped()) {
            boolean b = PictureKit.instance().isDrawPictrue();
            PictureKit.instance().setDrawPictrue(true);
            float paintZoom = this.slideshow ? this.fitZoom : this.zoom;
            Dimension d = this.getPageSize();
            int originBitmapW = Math.min((int)((float)d.width * paintZoom), this.getWidth());
            int originbitmapH = Math.min((int)((float)d.height * paintZoom), this.getHeight());
            Bitmap bitmap = otp.getBitmap(originBitmapW, originbitmapH);
            if (bitmap == null) {
                return;
            }
            Canvas picCanvas = new Canvas(bitmap);
            picCanvas.drawColor(-16777216);
            this.slideView.drawSlideForToPicture(picCanvas, paintZoom, originBitmapW, originbitmapH);
            this.control.getSysKit().getCalloutManager().drawPath(picCanvas, this.getCurrentIndex(), paintZoom);
            otp.callBack(bitmap);
            PictureKit.instance().setDrawPictrue(b);
        }
    }

    public Bitmap getSnapshot(Bitmap destBitmap) {
        if (destBitmap == null) {
            return null;
        }
        if (!this.init || !this.slideshow) {
            return this.pgPrintMode.getSnapshot(destBitmap);
        }
        float paintZoom = this.slideshow ? this.fitZoom : this.zoom;
        Dimension d = this.getPageSize();
        int originBitmapW = Math.min((int)((float)d.width * paintZoom), this.getWidth());
        int originbitmapH = Math.min((int)((float)d.height * paintZoom), this.getHeight());
        Canvas picCanvas = new Canvas(destBitmap);
        picCanvas.drawColor(-16777216);
        this.slideView.drawSlideForToPicture(picCanvas, paintZoom *= Math.min((float)destBitmap.getWidth() / (float)originBitmapW, (float)destBitmap.getHeight() / (float)originbitmapH), destBitmap.getWidth(), destBitmap.getHeight());
        return destBitmap;
    }

    public Bitmap slideToImage(int slideNumber) {
        if (slideNumber <= 0 || slideNumber > this.getRealSlideCount()) {
            return null;
        }
        return SlideDrawKit.instance().slideToImage(this.pgModel, this.editor, this.pgModel.getSlide(slideNumber - 1));
    }

    public Bitmap slideAreaToImage(int slideNumber, int srcLeft, int srcTop, int srcWidth, int srcHeight, int desWidth, int desHeight) {
        if (slideNumber <= 0 || slideNumber > this.getRealSlideCount() || !SysKit.isValidateRect((int)this.getPageSize().getWidth(), (int)this.getPageSize().getHeight(), srcLeft, srcTop, srcWidth, srcHeight)) {
            return null;
        }
        return SlideDrawKit.instance().slideAreaToImage(this.pgModel, this.editor, this.pgModel.getSlide(slideNumber - 1), srcLeft, srcTop, srcWidth, srcHeight, desWidth, desHeight);
    }

    public Bitmap getThumbnail(int slideNumber, float zoom) {
        if (slideNumber <= 0 || slideNumber > this.getRealSlideCount()) {
            return null;
        }
        return SlideDrawKit.instance().getThumbnail(this.pgModel, this.editor, this.pgModel.getSlide(slideNumber - 1), zoom);
    }

    public String getSldieNote(int slideNumber) {
        if (slideNumber <= 0 || slideNumber > this.getSlideCount()) {
            return null;
        }
        PGNotes note = this.pgModel.getSlide(slideNumber - 1).getNotes();
        return note == null ? "" : note.getNotes();
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.isConfigurationChanged = true;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.processPageSize(w, h);
    }

    private void processPageSize(int width, int height) {
        this.mWidth = width;
        this.mHeight = height;
        if (this.isConfigurationChanged || this.slideshow) {
            if (this.isConfigurationChanged) {
                this.isConfigurationChanged = false;
            }
            this.fitZoom = this.getFitZoom();
            if (this.slideshow) {
                this.post(new Runnable(){

                    @Override
                    public void run() {
                        Presentation.this.control.actionEvent(0x2000000A, null);
                    }
                });
            }
        }
    }

    public float getFitZoom() {
        if (this.slideshow) {
            Dimension pageSize = this.getPageSize();
            return Math.min((float)this.mWidth / (float)pageSize.width, (float)this.mHeight / (float)pageSize.height);
        }
        return this.pgPrintMode.getFitZoom();
    }

    public int getCurrentIndex() {
        return this.slideshow ? this.slideIndex_SlideShow : this.pgPrintMode.getCurrentPageNumber() - 1;
    }

    public int getSlideCount() {
        return this.pgModel.getSlideCount();
    }

    public int getRealSlideCount() {
        return this.pgModel.getRealSlideCount();
    }

    public PGSlide getSlide(int index) {
        return this.pgModel.getSlide(index);
    }

    public IControl getControl() {
        return this.control;
    }

    public int getmWidth() {
        return this.mWidth;
    }

    public void setmWidth(int mWidth) {
        this.mWidth = mWidth;
    }

    public int getmHeight() {
        return this.mHeight;
    }

    public void setmHeight(int mHeight) {
        this.mHeight = mHeight;
    }

    public void setSize(int w, int h) {
        this.mWidth = w;
        this.mHeight = h;
    }

    public float getZoom() {
        return this.slideshow ? this.fitZoom : this.pgPrintMode.getZoom();
    }

    public void setZoom(float zoom, int pointX, int pointY) {
        if (this.slideshow) {
            return;
        }
        this.pgPrintMode.setZoom(zoom, pointX, pointY);
    }

    public void setFitSize(int value) {
        if (this.slideshow) {
            return;
        }
        this.pgPrintMode.setFitSize(value);
    }

    public int getFitSizeState() {
        if (this.slideshow) {
            return 0;
        }
        return this.pgPrintMode.getFitSizeState();
    }

    public Dimension getPageSize() {
        return this.pgModel.getPageSize();
    }

    public IDocument getRenderersDoc() {
        return this.pgModel.getRenderersDoc();
    }

    public PGSlide getCurrentSlide() {
        if (this.slideshow) {
            return this.pgModel.getSlide(this.slideIndex_SlideShow);
        }
        return this.pgPrintMode.getCurrentPGSlide();
    }

    @Override
    public boolean find(String value) {
        if (!this.slideshow) {
            return this.pgFind.find(value);
        }
        return false;
    }

    @Override
    public boolean findBackward() {
        if (!this.slideshow) {
            return this.pgFind.findBackward();
        }
        return false;
    }

    @Override
    public boolean findForward() {
        if (!this.slideshow) {
            return this.pgFind.findForward();
        }
        return false;
    }

    @Override
    public void resetSearchResult() {
    }

    @Override
    public int getPageIndex() {
        return -1;
    }

    public String getSelectedText() {
        return this.editor.getHighlight().getSelectText();
    }

    public PGSlide getSlideMaster(int index) {
        return this.pgModel.getSlideMaster(index);
    }

    public PGEditor getEditor() {
        return this.editor;
    }

    public void setAnimationDuration(int duration) {
        if (this.slideView == null) {
            this.slideView = new SlideShowView(this, this.currentSlide);
        }
        if (this.slideView != null) {
            this.slideView.setAnimationDuration(duration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginSlideShow(int slideIndex) {
        Presentation presentation = this;
        synchronized (presentation) {
            if (slideIndex <= 0 || slideIndex > this.pgModel.getSlideCount()) {
                return;
            }
            if (this.eventManage == null) {
                this.eventManage = new PGEventManage(this, this.control);
            }
            boolean isChangedSlide = false;
            if (this.getCurrentIndex() + 1 != slideIndex) {
                isChangedSlide = true;
            }
            this.setOnTouchListener(this.eventManage);
            this.control.getSysKit().getCalloutManager().setDrawingMode(0);
            this.pgPrintMode.setVisibility(8);
            this.slideshow = true;
            this.processPageSize(this.getWidth(), this.getHeight());
            this.slideIndex_SlideShow = slideIndex - 1;
            this.currentSlide = this.pgModel.getSlide(this.slideIndex_SlideShow);
            if (this.slideView == null) {
                this.slideView = new SlideShowView(this, this.currentSlide);
            }
            this.slideView.initSlideShow(this.currentSlide, true);
            this.setBackgroundColor(-16777216);
            if (this.callouts == null) {
                if (!this.control.getSysKit().getCalloutManager().isPathEmpty()) {
                    this.initCalloutView();
                }
            } else {
                this.callouts.setIndex(this.slideIndex_SlideShow);
            }
            this.postInvalidate();
            if (isChangedSlide && this.getControl().getMainFrame() != null) {
                this.getControl().getMainFrame().changePage();
            }
            this.post(new Runnable(){

                @Override
                public void run() {
                    Presentation.this.initSlidebar();
                    Presentation.this.control.actionEvent(0x2000000A, null);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNextSlide_Slideshow() {
        Presentation presentation = this;
        synchronized (presentation) {
            if (this.slideshow) {
                return this.slideIndex_SlideShow < this.pgModel.getSlideCount() - 1;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPreviousSlide_Slideshow() {
        Presentation presentation = this;
        synchronized (presentation) {
            if (this.slideshow) {
                return this.slideIndex_SlideShow >= 1;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNextAction_Slideshow() {
        Presentation presentation = this;
        synchronized (presentation) {
            return this.slideshow && (!this.slideView.gotoNextSlide() || this.slideIndex_SlideShow < this.pgModel.getSlideCount() - 1);
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPreviousAction_Slideshow() {
        Presentation presentation = this;
        synchronized (presentation) {
            return this.slideshow && (this.slideIndex_SlideShow >= 1 || !this.slideView.gotopreviousSlide());
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void slideShow(byte type) {
        Presentation presentation = this;
        synchronized (presentation) {
            if (!this.slideshow || !this.slideView.animationStoped() || this.control.getSysKit().getCalloutManager().getDrawingMode() != 0) {
                return;
            }
            if (type == 4 && this.hasPreviousSlide_Slideshow()) {
                --this.slideIndex_SlideShow;
                if (this.slideIndex_SlideShow >= 0) {
                    this.slideView.initSlideShow(this.pgModel.getSlide(this.slideIndex_SlideShow), true);
                    if (this.getControl().getMainFrame() != null) {
                        this.getControl().getMainFrame().changePage();
                    }
                }
            } else {
                if (this.slideView.isExitSlideShow()) {
                    this.control.getMainFrame().fullScreen(false);
                    this.endSlideShow();
                    return;
                }
                switch (type) {
                    case 2: {
                        if (!this.hasPreviousAction_Slideshow()) break;
                        if (this.slideView.gotopreviousSlide()) {
                            PGSlide slide;
                            if ((slide = this.pgModel.getSlide(--this.slideIndex_SlideShow)) != null) {
                                this.slideView.initSlideShow(slide, true);
                                this.slideView.gotoLastAction();
                            }
                            if (this.getControl().getMainFrame() == null) break;
                            this.getControl().getMainFrame().changePage();
                            break;
                        }
                        this.slideView.previousActionSlideShow();
                        break;
                    }
                    case 3: {
                        if (!this.hasNextAction_Slideshow()) break;
                        if (this.slideView.gotoNextSlide()) {
                            this.slideView.initSlideShow(this.pgModel.getSlide(++this.slideIndex_SlideShow), true);
                            if (this.getControl().getMainFrame() == null) break;
                            this.getControl().getMainFrame().changePage();
                            break;
                        }
                        this.slideView.nextActionSlideShow();
                        break;
                    }
                    case 5: {
                        if (!this.hasNextSlide_Slideshow()) break;
                        this.slideView.initSlideShow(this.pgModel.getSlide(++this.slideIndex_SlideShow), true);
                        if (this.getControl().getMainFrame() == null) break;
                        this.getControl().getMainFrame().changePage();
                    }
                }
            }
            if (this.callouts != null) {
                this.callouts.setIndex(this.slideIndex_SlideShow);
            }
            this.postInvalidate();
            this.post(new Runnable(){

                @Override
                public void run() {
                    if (Presentation.this.control != null) {
                        Presentation.this.control.actionEvent(0x2000000A, null);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endSlideShow() {
        Presentation presentation = this;
        synchronized (presentation) {
            if (this.slideshow) {
                this.control.getSysKit().getCalloutManager().setDrawingMode(0);
                this.setOnTouchListener(null);
                this.pgPrintMode.setVisibility(0);
                Object bg = this.control.getMainFrame().getViewBackground();
                if (bg != null) {
                    if (bg instanceof Integer) {
                        this.setBackgroundColor((Integer)bg);
                    } else if (bg instanceof Drawable) {
                        this.setBackgroundDrawable((Drawable)bg);
                    }
                }
                this.currentIndex = this.slideIndex_SlideShow;
                this.slideshow = false;
                this.slideView.endSlideShow();
                this.showSlide(this.currentIndex, false);
                if (this.callouts != null) {
                    this.callouts.setVisibility(4);
                }
                this.post(new Runnable(){

                    @Override
                    public void run() {
                        ISlideShow iSlideshow = Presentation.this.control.getSlideShow();
                        if (iSlideshow != null) {
                            iSlideshow.exit();
                        }
                        Presentation.this.initSlidebar();
                    }
                });
            }
        }
    }

    public boolean isSlideShow() {
        return this.slideshow;
    }

    public PGFind getFind() {
        return this.pgFind;
    }

    public PGPrintMode getPrintMode() {
        return this.pgPrintMode;
    }

    public Rect getSlideDrawingRect() {
        if (this.slideshow) {
            if (this.slideSize == null) {
                this.slideSize = new Rect(this.slideView.getDrawingRect());
            } else {
                this.slideSize.set(this.slideView.getDrawingRect());
            }
            int w = this.slideSize.width();
            this.slideSize.set((this.mWidth - w) / 2, 0, (this.mWidth + w) / 2, this.mHeight);
            return this.slideSize;
        }
        return null;
    }

    public PGModel getPGModel() {
        return this.pgModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSlideAnimationSteps(int slideIndex) {
        Presentation presentation = this;
        synchronized (presentation) {
            List<ShapeAnimation> shapeAnimLst = this.pgModel.getSlide(slideIndex - 1).getSlideShowAnimation();
            if (shapeAnimLst != null) {
                return shapeAnimLst.size() + 1;
            }
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bitmap getSlideshowToImage(int slideIndex, int step) {
        Presentation presentation = this;
        synchronized (presentation) {
            if (this.slideView == null) {
                this.slideView = new SlideShowView(this, this.pgModel.getSlide(slideIndex - 1));
            }
            return this.slideView.getSlideshowToImage(this.pgModel.getSlide(slideIndex - 1), step);
        }
    }

    @Override
    public void dispose() {
        this.control = null;
        this.currentSlide = null;
        if (this.slideView != null) {
            this.slideView.dispose();
            this.slideView = null;
        }
        if (this.eventManage != null) {
            this.eventManage.dispose();
            this.eventManage = null;
        }
        this.pgModel.dispose();
        this.pgModel = null;
        if (this.pgFind != null) {
            this.pgFind.dispose();
            this.pgFind = null;
        }
    }
}

