/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.pg.control;

import android.graphics.Rect;
import android.view.MotionEvent;
import android.view.View;
import com.ahmadullahpk.alldocumentreader.xs.pg.control.Presentation;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import com.ahmadullahpk.alldocumentreader.xs.system.beans.AEventManage;

public class PGEventManage
extends AEventManage {
    private Presentation presentation;

    public PGEventManage(Presentation presentation, IControl control) {
        super(presentation.getContext(), control);
        this.presentation = presentation;
        presentation.setOnTouchListener(this);
        presentation.setLongClickable(true);
    }

    @Override
    public boolean onTouch(View v, MotionEvent event) {
        super.onTouch(v, event);
        return false;
    }

    @Override
    public boolean onDoubleTap(MotionEvent e) {
        super.onDoubleTap(e);
        return true;
    }

    @Override
    public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
        super.onScroll(e1, e2, distanceX, distanceY);
        return true;
    }

    @Override
    public void fling(int velocityX, int velocityY) {
        if (this.presentation.isSlideShow()) {
            if (Math.abs(velocityY) < 400 && Math.abs(velocityX) < 400) {
                this.presentation.slideShow((byte)3);
                return;
            }
            super.fling(velocityX, velocityY);
            int currentIndex = this.presentation.getCurrentIndex();
            if (Math.abs(velocityY) > Math.abs(velocityX)) {
                if (velocityY < 0 && currentIndex >= 0) {
                    this.presentation.slideShow((byte)3);
                } else if (velocityY > 0 && currentIndex <= this.presentation.getRealSlideCount() - 1) {
                    this.presentation.slideShow((byte)2);
                }
            } else if (velocityX < 0 && currentIndex >= 0) {
                this.presentation.slideShow((byte)4);
            } else if (velocityX > 0 && currentIndex < this.presentation.getRealSlideCount() - 1) {
                this.presentation.slideShow((byte)5);
            }
        }
    }

    @Override
    public boolean onSingleTapUp(MotionEvent e) {
        super.onSingleTapUp(e);
        if (e.getAction() == 1) {
            Rect drawRect = this.presentation.getSlideDrawingRect();
            if (this.presentation.isSlideShow() && drawRect.contains((int)e.getX(), (int)e.getY())) {
                this.presentation.slideShow((byte)3);
            }
        }
        return true;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.presentation = null;
    }
}

