/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.officereader.database;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.ahmadullahpk.alldocumentreader.xs.officereader.database.DBHelper;
import java.io.File;
import java.util.List;

public class DBService {
    private DBHelper dbHelper;

    public DBService(Context context) {
        this.createDataBase(context);
    }

    public void createDataBase(Context context) {
        if (this.dbHelper == null) {
            this.dbHelper = new DBHelper(context);
            SQLiteDatabase db = this.dbHelper.getWritableDatabase();
            if (db != null) {
                db.execSQL("CREATE TABLE IF NOT EXISTS openedfiles ('name' VARCHAR(30))");
                db.execSQL("CREATE TABLE IF NOT EXISTS starredfiles ('name' VARCHAR(30))");
                db.execSQL("CREATE TABLE IF NOT EXISTS settings ('count' VARCHAR(30))");
            }
        }
    }

    public void insertRecentFiles(String tableName, String name) {
        Cursor cursor;
        SQLiteDatabase db;
        if (this.queryItem(tableName, name)) {
            this.deleteItem(tableName, name);
        }
        if ((db = this.dbHelper.getWritableDatabase()) != null && (cursor = db.rawQuery("select * from " + tableName, null)) != null) {
            this.deleteItems(tableName, cursor.getCount() - this.getRecentMax() + 1);
            cursor.close();
            db.execSQL("INSERT INTO " + tableName + " (name) values(?)", new Object[]{name});
        }
    }

    public void insertStarFiles(String tableName, String name) {
        if (this.queryItem(tableName, name)) {
            return;
        }
        SQLiteDatabase db = this.dbHelper.getWritableDatabase();
        if (db != null) {
            db.execSQL("INSERT INTO " + tableName + " (name) values(?)", new Object[]{name});
        }
    }

    public boolean queryItem(String tableName, String name) {
        SQLiteDatabase db = this.dbHelper.getWritableDatabase();
        if (db == null) {
            return false;
        }
        Cursor cursor = db.rawQuery("select * from " + tableName + " where name like ?", new String[]{name});
        if (cursor != null && cursor.moveToFirst()) {
            cursor.close();
            return true;
        }
        cursor.close();
        return false;
    }

    public void deleteItem(String tableName, String name) {
        SQLiteDatabase db = this.dbHelper.getWritableDatabase();
        if (db != null) {
            db.execSQL("delete from " + tableName + " where name=?", new Object[]{name});
        }
    }

    public void deleteItems(String tableName, int count) {
        Cursor cursor;
        SQLiteDatabase db = this.dbHelper.getWritableDatabase();
        if (db != null && (cursor = db.rawQuery("select * from " + tableName, null)) != null) {
            cursor.moveToFirst();
            while (cursor != null && count > 0) {
                this.deleteItem(tableName, cursor.getString(0));
                cursor.moveToNext();
                --count;
            }
            cursor.close();
        }
    }

    public void get(String tableName, List<File> fileList) {
        Cursor cursor;
        SQLiteDatabase db = this.dbHelper.getWritableDatabase();
        if (db != null && (cursor = db.rawQuery("select * from " + tableName, null)) != null) {
            while (cursor.moveToNext()) {
                File file = new File(cursor.getString(0));
                if (file.exists()) {
                    fileList.add(file);
                    continue;
                }
                this.deleteItem(tableName, file.getAbsolutePath());
            }
            cursor.close();
        }
    }

    public int getCount(String tableName) {
        Cursor cursor;
        int count = 0;
        SQLiteDatabase db = this.dbHelper.getWritableDatabase();
        if (db != null && (cursor = db.rawQuery("select * from " + tableName, null)) != null) {
            count = cursor.getCount();
            cursor.close();
        }
        return count;
    }

    public int getRecentMax() {
        Cursor cursor;
        int max = 10;
        SQLiteDatabase db = this.dbHelper.getWritableDatabase();
        if (db != null && (cursor = db.rawQuery("select * from settings", null)) != null) {
            if (cursor.moveToFirst()) {
                max = cursor.getInt(0);
            } else {
                db.execSQL("INSERT INTO settings (count) values(?)", new Object[]{10});
            }
            cursor.close();
        }
        return max;
    }

    public void changeRecentCount(int value) {
        Cursor cursor;
        SQLiteDatabase db = this.dbHelper.getWritableDatabase();
        if (db != null && (cursor = db.rawQuery("select * from settings", null)) != null) {
            if (cursor.moveToFirst()) {
                int count = cursor.getInt(0);
                if (count != value) {
                    db.execSQL("update settings set count = " + value + " where count = " + count);
                    int has = this.getCount("openedfiles");
                    if (has > value) {
                        this.deleteItems("openedfiles", has - value);
                    }
                }
            } else {
                db.execSQL("INSERT INTO settings (count) values(?)", new Object[]{10});
            }
            cursor.close();
        }
    }

    public void dropTable(String tableName) {
        SQLiteDatabase db = this.dbHelper.getWritableDatabase();
        if (db != null) {
            db.execSQL("DROP TABLE IF EXISTS " + tableName);
        }
    }

    public void closeDatabase() {
        SQLiteDatabase db = this.dbHelper.getWritableDatabase();
        if (db != null) {
            db.close();
        }
    }

    public void dispose() {
        this.closeDatabase();
        this.dbHelper.dispose();
        this.dbHelper = null;
    }
}

