/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.xls.Reader;

import android.os.Message;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.Document;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.Element;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.ElementHandler;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.ElementPath;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.io.SAXReader;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.PackagePart;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.PackageRelationship;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.PackageRelationshipCollection;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.ZipPackage;
import com.ahmadullahpk.alldocumentreader.xs.fc.xls.Reader.SheetReader;
import com.ahmadullahpk.alldocumentreader.xs.fc.xls.SSReader;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Sheet;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Workbook;
import com.ahmadullahpk.alldocumentreader.xs.system.AbortReaderError;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import com.ahmadullahpk.alldocumentreader.xs.system.IReader;
import com.ahmadullahpk.alldocumentreader.xs.system.ReaderHandler;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class WorkbookReader {
    private static final int WINDOWWIDTH = 2;
    private static WorkbookReader reader = new WorkbookReader();
    private ZipPackage zipPackage;
    private Workbook book;
    private SSReader iReader;
    private Map<Integer, String> sheetIndexList;
    private Map<String, String> sheetNameList;
    private int tempIndex;
    private PackageRelationshipCollection worksheetRelCollection;
    private PackageRelationshipCollection chartsheetRelCollection;

    public static WorkbookReader instance() {
        return reader;
    }

    public void read(ZipPackage zipPackage, PackagePart packagePart, Workbook book, SSReader iReader) throws Exception {
        this.zipPackage = zipPackage;
        this.book = book;
        this.iReader = iReader;
        this.getSheetsProp(packagePart);
        for (int i = 0; i < this.sheetIndexList.size(); ++i) {
            Sheet sheet = new Sheet();
            sheet.setWorkbook(book);
            String id2 = this.sheetIndexList.get(i);
            sheet.setSheetName(this.sheetNameList.get(id2));
            book.addSheet(i, sheet);
        }
        this.worksheetRelCollection = packagePart.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/worksheet");
        this.chartsheetRelCollection = packagePart.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/chartsheet");
        class WorkbookReaderHandler
        extends ReaderHandler {
            private WorkbookReader reader;
            private IControl control;

            public WorkbookReaderHandler(IControl control, WorkbookReader reader) {
                this.reader = reader;
                this.control = control;
            }

            @Override
            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 0: {
                        new SheetThread(this.control, this.reader, (Integer)msg.obj).start();
                        break;
                    }
                    case 1: 
                    case 4: {
                        WorkbookReader.this.dispose();
                        this.reader = null;
                    }
                }
            }
        }
        WorkbookReaderHandler handler = new WorkbookReaderHandler(iReader.getControl(), this);
        book.setReaderHandler(handler);
        Message msg = new Message();
        msg.what = 0;
        msg.obj = 0;
        handler.handleMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readSheetInSlideWindow(IControl control, int currentsheet) throws Exception {
        int i;
        Workbook workbook = this.book;
        synchronized (workbook) {
            this.iReader.abortCurrentReading();
            Thread.sleep(50L);
            for (i = currentsheet - 2; i <= currentsheet + 2; ++i) {
                if (i < 0 || this.book.getSheet(i) == null || this.book.getSheet(i).isAccomplished()) continue;
                this.book.getSheet(i).setState((short)1);
            }
        }
        workbook = this.book;
        synchronized (workbook) {
            if (currentsheet >= 0 && this.book.getSheet(currentsheet) != null && !this.book.getSheet(currentsheet).isAccomplished()) {
                this.readSheet(control, currentsheet);
            }
            for (i = currentsheet - 2; i <= currentsheet + 2; ++i) {
                if (i < 0 || this.book.getSheet(i) == null || this.book.getSheet(i).isAccomplished()) continue;
                this.readSheet(control, i);
            }
        }
    }

    private void readSheet(IControl control, int index) throws Exception {
        PackageRelationship rel = this.worksheetRelCollection.getRelationshipByID(this.sheetIndexList.get(index));
        short sheetType = 0;
        if (rel == null) {
            rel = this.chartsheetRelCollection.getRelationshipByID(this.sheetIndexList.get(index));
            sheetType = 1;
        }
        if (rel == null) {
            return;
        }
        PackagePart sheetPart = this.zipPackage.getPart(rel.getTargetURI());
        if (sheetPart != null) {
            this.book.getSheet(index).setSheetType(sheetType);
            SheetReader.instance().getSheet(control, this.zipPackage, this.book.getSheet(index), sheetPart, this.iReader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getSheetsProp(PackagePart documentPart) throws Exception {
        if (this.sheetIndexList != null) {
            this.sheetIndexList.clear();
        } else {
            this.sheetIndexList = new HashMap<Integer, String>(5);
        }
        if (this.sheetNameList != null) {
            this.sheetNameList.clear();
        } else {
            this.sheetNameList = new HashMap<String, String>(5);
        }
        this.tempIndex = 0;
        SAXReader saxreader = new SAXReader();
        try {
            WorkBookSaxHandler handler = new WorkBookSaxHandler();
            saxreader.addHandler("/workbook/workbookPr", handler);
            saxreader.addHandler("/workbook/sheets/sheet", handler);
            InputStream in = documentPart.getInputStream();
            saxreader.read(in);
            in.close();
        }
        finally {
            saxreader.resetHandlers();
        }
    }

    public boolean searchContent(ZipPackage zipPackage, IReader iReader, PackagePart packagePart, String key) throws Exception {
        if (this.searchContent_SheetName(packagePart, key)) {
            return true;
        }
        this.zipPackage = zipPackage;
        this.worksheetRelCollection = packagePart.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/worksheet");
        for (int i = 0; i < this.worksheetRelCollection.size(); ++i) {
            if (!this.searchContent_Sheet(iReader, this.worksheetRelCollection.getRelationship(i), key)) continue;
            this.dispose();
            return true;
        }
        return false;
    }

    private boolean searchContent_SheetName(PackagePart documentPart, String key) throws Exception {
        SAXReader saxreader = new SAXReader();
        InputStream in = documentPart.getInputStream();
        Document poiXls = saxreader.read(in);
        in.close();
        Element root = poiXls.getRootElement();
        Element sheetsElement = root.element("sheets");
        Iterator iter = sheetsElement.elementIterator();
        while (iter.hasNext()) {
            Element ele = (Element)iter.next();
            if (!ele.attributeValue("name").toLowerCase().contains(key)) continue;
            return true;
        }
        return false;
    }

    private boolean searchContent_Sheet(IReader iReader, PackageRelationship sheetsRel, String key) throws Exception {
        PackagePart sheetPart = this.zipPackage.getPart(sheetsRel.getTargetURI());
        if (sheetPart != null) {
            return SheetReader.instance().searchContent(this.zipPackage, iReader, sheetPart, key);
        }
        return false;
    }

    public void dispose() {
        this.zipPackage = null;
        this.book = null;
        this.iReader = null;
        if (this.sheetNameList != null) {
            this.sheetNameList.clear();
            this.sheetNameList = null;
        }
        if (this.sheetIndexList != null) {
            this.sheetIndexList.clear();
            this.sheetIndexList = null;
        }
        if (this.worksheetRelCollection != null) {
            this.worksheetRelCollection.clear();
            this.worksheetRelCollection = null;
        }
        if (this.chartsheetRelCollection != null) {
            this.chartsheetRelCollection.clear();
            this.chartsheetRelCollection = null;
        }
    }

    class WorkBookSaxHandler
    implements ElementHandler {
        WorkBookSaxHandler() {
        }

        @Override
        public void onStart(ElementPath elementPath) {
        }

        @Override
        public void onEnd(ElementPath elementPath) {
            if (WorkbookReader.this.iReader.isAborted()) {
                throw new AbortReaderError("abort Reader");
            }
            Element elem = elementPath.getCurrent();
            String name = elem.getName();
            if (name.equals("sheet")) {
                String id2 = elem.attributeValue("id");
                String sheetName = elem.attributeValue("name");
                WorkbookReader.this.sheetIndexList.put(WorkbookReader.this.tempIndex, id2);
                WorkbookReader.this.sheetNameList.put(id2, sheetName);
                ++WorkbookReader.this.tempIndex;
            } else if (name.equals("workbookPr")) {
                boolean usingDate1904 = false;
                if (elem.attributeValue("date1904") != null) {
                    usingDate1904 = Integer.parseInt(elem.attributeValue("date1904")) != 0;
                }
                WorkbookReader.this.book.setUsing1904DateWindowing(usingDate1904);
            }
            elem.detach();
        }
    }

    class SheetThread
    extends Thread {
        private WorkbookReader reader;
        private int sheetIndex;
        private IControl control;

        public SheetThread(IControl control, WorkbookReader reader, int sheetIndex) {
            this.reader = reader;
            this.sheetIndex = sheetIndex;
            this.control = control;
        }

        @Override
        public void run() {
            try {
                this.reader.readSheetInSlideWindow(this.control, this.sheetIndex);
            }
            catch (OutOfMemoryError e) {
                this.control.getSysKit().getErrorKit().writerLog(e, true);
                this.reader.dispose();
            }
            catch (Exception e) {
                this.control.getSysKit().getErrorKit().writerLog(e, true);
                this.reader.dispose();
            }
            finally {
                this.reader = null;
            }
        }
    }
}

