/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.xls.Reader;

import com.ahmadullahpk.alldocumentreader.xs.common.hyperlink.Hyperlink;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.Document;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.Element;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.ElementHandler;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.ElementPath;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.io.SAXReader;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.PackagePart;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.PackageRelationship;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.PackageRelationshipCollection;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.ZipPackage;
import com.ahmadullahpk.alldocumentreader.xs.fc.ppt.reader.PictureReader;
import com.ahmadullahpk.alldocumentreader.xs.fc.xls.Reader.CellReader;
import com.ahmadullahpk.alldocumentreader.xs.fc.xls.Reader.drawing.DrawingReader;
import com.ahmadullahpk.alldocumentreader.xs.fc.xls.Reader.table.TableReader;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.CellRangeAddress;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Cell;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Row;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Sheet;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Workbook;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.sheetProperty.ColumnInfo;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.sheetProperty.PaneInformation;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.table.SSTable;
import com.ahmadullahpk.alldocumentreader.xs.ss.util.ReferenceUtil;
import com.ahmadullahpk.alldocumentreader.xs.system.AbortReaderError;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import com.ahmadullahpk.alldocumentreader.xs.system.IReader;
import com.ahmadullahpk.alldocumentreader.xs.system.StopReaderError;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SheetReader {
    private static SheetReader reader = new SheetReader();
    private Sheet sheet;
    private IReader iReader;
    private int defaultRowHeight;
    private int defaultColWidth;
    private String key;
    private boolean searched;

    public static SheetReader instance() {
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSheet(IControl control, ZipPackage zipPackage, Sheet sheet, PackagePart sheetPart, IReader iReader) throws Exception {
        PackageRelationshipCollection drawingRelCollection;
        Element root;
        this.sheet = sheet;
        this.iReader = iReader;
        SAXReader saxreader = new SAXReader();
        try {
            XLSXSaxHandler xLSXSaxHandler = new XLSXSaxHandler();
            saxreader.addHandler("/worksheet/sheetFormatPr", xLSXSaxHandler);
            saxreader.addHandler("/worksheet/cols/col", xLSXSaxHandler);
            saxreader.addHandler("/worksheet/sheetData/row", xLSXSaxHandler);
            saxreader.addHandler("/worksheet/sheetData/row/c", xLSXSaxHandler);
            saxreader.addHandler("/worksheet/mergeCells/mergeCell", xLSXSaxHandler);
            InputStream in = sheetPart.getInputStream();
            Document poiXls = saxreader.read(in);
            in.close();
            root = poiXls.getRootElement();
        }
        finally {
            saxreader.resetHandlers();
        }
        Element ele = root.element("sheetViews").element("sheetView");
        if (ele.element("pane") != null) {
            PaneInformation paneInfo = new PaneInformation();
            Element pane = ele.element("pane");
            if (pane.attributeValue("xSplit") != null) {
                paneInfo.setVerticalSplitLeftColumn((short)Integer.parseInt(pane.attributeValue("xSplit")));
            }
            if (pane.attributeValue("ySplit") != null) {
                paneInfo.setHorizontalSplitTopRow((short)Integer.parseInt(pane.attributeValue("ySplit")));
            }
            sheet.setPaneInformation(paneInfo);
        }
        Map<String, String> hyperlinkTarget = this.getSheetHyperlinkByRelation(sheetPart);
        PackageRelationshipCollection tableRelCollection = sheetPart.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/table");
        if (tableRelCollection.size() > 0) {
            for (PackageRelationship tableRel : tableRelCollection) {
                TableReader.instance().read(control, zipPackage.getPart(tableRel.getTargetURI()), sheet);
            }
        }
        if ((drawingRelCollection = sheetPart.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/drawing")).size() > 0) {
            PackagePart drawingPart = zipPackage.getPart(drawingRelCollection.getRelationship(0).getTargetURI());
            DrawingReader.instance().read(control, zipPackage, drawingPart, sheet);
        }
        DrawingReader.instance().processOLEPicture(control, zipPackage, sheetPart, sheet, root.element("oleObjects"));
        PictureReader.instance().dispose();
        this.getSheetHyperlink(sheet, hyperlinkTarget, root.element("hyperlinks"));
        this.checkTableCell(sheet);
        sheet.setState((short)2);
        this.dispose();
    }

    private Map<String, String> getSheetHyperlinkByRelation(PackagePart sheetPart) throws Exception {
        PackageRelationshipCollection HyperlinkRelCollection = sheetPart.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/hyperlink");
        HashMap<String, String> hyperlink = new HashMap<String, String>(HyperlinkRelCollection.size());
        for (PackageRelationship HyperlinkRel : HyperlinkRelCollection) {
            hyperlink.put(HyperlinkRel.getId(), HyperlinkRel.getTargetURI().toString());
        }
        return hyperlink;
    }

    private void getSheetHyperlink(Sheet sheet, Map<String, String> hyperlinkTarget, Element hyperlinksEle) {
        if (hyperlinksEle == null) {
            return;
        }
        Iterator iter = hyperlinksEle.elementIterator();
        while (iter.hasNext()) {
            Cell cell;
            Element hyperlinkEle = (Element)iter.next();
            String id2 = hyperlinkEle.attributeValue("id");
            String ref = hyperlinkEle.attributeValue("ref");
            Row row = sheet.getRow(ReferenceUtil.instance().getRowIndex(ref));
            if (row == null || (cell = row.getCell(ReferenceUtil.instance().getColumnIndex(ref))) == null) continue;
            Hyperlink hyperlink = new Hyperlink();
            String target = hyperlinkTarget.get(id2);
            if (target == null) {
                hyperlink.setLinkType(2);
                target = hyperlinkEle.attributeValue("location");
            } else if (target.contains("mailto")) {
                hyperlink.setLinkType(3);
            } else if (target.contains("http")) {
                hyperlink.setLinkType(1);
            } else {
                hyperlink.setLinkType(4);
            }
            hyperlink.setAddress(target);
            cell.setHyperLink(hyperlink);
        }
    }

    private void setColumnProperty(Element col) {
        int min = Integer.parseInt(col.attributeValue("min")) - 1;
        int max = Integer.parseInt(col.attributeValue("max")) - 1;
        int styleIndex = 0;
        double width = col.attributeValue("width") != null ? Double.parseDouble(col.attributeValue("width")) * 6.0 * 1.3333333730697632 : 0.0;
        boolean hidden = col.attributeValue("hidden") != null ? Integer.parseInt(col.attributeValue("hidden")) != 0 : false;
        if (col.attributeValue("style") != null) {
            styleIndex = Integer.parseInt(col.attributeValue("style"));
        }
        this.sheet.addColumnInfo(new ColumnInfo(min, max, (int)width, styleIndex, hidden));
    }

    private void getSheetMergerdCells(Element mergedCell) {
        CellRangeAddress cellRange = this.getCellRangeAddress(mergedCell.attributeValue("ref"));
        if (cellRange.getLastRow() - cellRange.getFirstRow() == 1048575 || cellRange.getLastColumn() - cellRange.getFirstColumn() == 16383) {
            return;
        }
        int index = this.sheet.addMergeRange(cellRange) - 1;
        for (int i = cellRange.getFirstRow(); i <= cellRange.getLastRow(); ++i) {
            Row row = this.sheet.getRow(i);
            if (row == null) {
                row = new Row(cellRange.getLastColumn() - cellRange.getFirstColumn());
                row.setSheet(this.sheet);
                row.setRowNumber(i);
                this.sheet.addRow(row);
            }
            for (int j = cellRange.getFirstColumn(); j <= cellRange.getLastColumn(); ++j) {
                Cell cell = row.getCell(j);
                if (cell == null) {
                    cell = new Cell(3);
                    cell.setRowNumber(i);
                    cell.setColNumber(j);
                    cell.setSheet(this.sheet);
                    cell.setCellStyle(row.getRowStyle());
                    row.addCell(cell);
                }
                cell.setRangeAddressIndex(index);
            }
        }
    }

    private CellRangeAddress getCellRangeAddress(String region) {
        String[] subRegion = region.split(":");
        return new CellRangeAddress(ReferenceUtil.instance().getRowIndex(subRegion[0]), ReferenceUtil.instance().getColumnIndex(subRegion[0]), ReferenceUtil.instance().getRowIndex(subRegion[1]), ReferenceUtil.instance().getColumnIndex(subRegion[1]));
    }

    private void checkTableCell(Sheet sheet) {
        SSTable[] tables = sheet.getTables();
        if (tables == null) {
            return;
        }
        Workbook book = sheet.getWorkbook();
        CellRangeAddress rangeAddr = null;
        for (SSTable item : tables) {
            rangeAddr = item.getTableReference();
            for (int i = rangeAddr.getFirstRow(); i <= rangeAddr.getLastRow(); ++i) {
                Row row = sheet.getRow(i);
                if (row == null) {
                    row = new Row(rangeAddr.getLastColumn() - rangeAddr.getFirstColumn() + 1);
                    row.setSheet(sheet);
                    row.setRowNumber(i);
                    row.setFirstCol(rangeAddr.getFirstColumn());
                    row.setLastCol(rangeAddr.getLastColumn());
                    row.setInitExpandedRangeAddress(true);
                    sheet.addRow(row);
                }
                for (int j = rangeAddr.getFirstColumn(); j <= rangeAddr.getLastColumn(); ++j) {
                    Cell cell = row.getCell(j);
                    if (cell == null) {
                        cell = new Cell(3);
                        cell.setColNumber(j);
                        cell.setRowNumber(row.getRowNumber());
                        cell.setSheet(sheet);
                        cell.setCellStyle(row.getRowStyle());
                        row.addCell(cell);
                    }
                    cell.setTableInfo(item);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean searchContent(ZipPackage zipPackage, IReader iReader, PackagePart sheetPart, String key) throws Exception {
        this.key = key;
        this.searched = false;
        this.iReader = iReader;
        SAXReader saxreader = new SAXReader();
        try {
            saxreader.addHandler("/worksheet/sheetData/row/c", new XLSXSearchSaxHandler());
            InputStream in = sheetPart.getInputStream();
            saxreader.read(in);
            in.close();
        }
        catch (StopReaderError e) {
            boolean bl = true;
            return bl;
        }
        finally {
            saxreader.resetHandlers();
        }
        return this.searched;
    }

    private boolean isValidateRow(Element rowElement) {
        if (rowElement.attributeValue("ht") != null) {
            return true;
        }
        if (rowElement.attributeValue("s") != null) {
            int style2 = Integer.parseInt(rowElement.attributeValue("s"));
            if (Workbook.isValidateStyle(this.sheet.getWorkbook().getCellStyle(style2))) {
                return true;
            }
        }
        return false;
    }

    private Row createRow(Element rowElement, int defaultRowHeight) {
        if (!this.isValidateRow(rowElement)) {
            return null;
        }
        int rowIndex = Integer.parseInt(rowElement.attributeValue("r")) - 1;
        String spans = rowElement.attributeValue("spans");
        float height = defaultRowHeight;
        boolean hidden = false;
        int style2 = 0;
        if (rowElement.attributeValue("ht") != null) {
            height = Float.parseFloat(rowElement.attributeValue("ht")) * 1.3333334f;
        }
        if (rowElement.attributeValue("hidden") != null) {
            boolean bl = hidden = Integer.parseInt(rowElement.attributeValue("hidden")) != 0;
        }
        if (rowElement.attributeValue("s") != null) {
            style2 = Integer.parseInt(rowElement.attributeValue("s"));
        }
        Row row = new Row(this.getEndBySpans(spans));
        row.setRowNumber(rowIndex);
        row.setRowPixelHeight(height);
        row.setZeroHeight(hidden);
        row.setSheet(this.sheet);
        row.setRowStyle(style2);
        row.completed();
        return row;
    }

    private void modifyRow(Row row, Element rowElement, int defaultRowHeight) {
        int height = defaultRowHeight;
        boolean hidden = false;
        int style2 = 0;
        if (rowElement.attributeValue("ht") != null) {
            height = (int)(Double.parseDouble(rowElement.attributeValue("ht")) * 1.3333333730697632);
        }
        if (rowElement.attributeValue("hidden") != null) {
            boolean bl = hidden = Integer.parseInt(rowElement.attributeValue("hidden")) != 0;
        }
        if (rowElement.attributeValue("s") != null) {
            style2 = Integer.parseInt(rowElement.attributeValue("s"));
        }
        row.setRowPixelHeight(height);
        row.setZeroHeight(hidden);
        row.setRowStyle(style2);
        row.completed();
    }

    private int getEndBySpans(String spans) {
        if (spans != null) {
            String[] subSpans = spans.split(" ");
            subSpans = subSpans[subSpans.length - 1].split(":");
            return Integer.parseInt(subSpans[1], 16) - 1;
        }
        return 0;
    }

    private void dispose() {
        this.sheet = null;
        this.iReader = null;
        this.key = null;
    }

    class XLSXSaxHandler
    implements ElementHandler {
        XLSXSaxHandler() {
        }

        @Override
        public void onStart(ElementPath elementPath) {
        }

        @Override
        public void onEnd(ElementPath elementPath) {
            if (SheetReader.this.iReader.isAborted()) {
                throw new AbortReaderError("abort Reader");
            }
            Element elem = elementPath.getCurrent();
            String name = elem.getName();
            if (name.equals("sheetFormatPr")) {
                if (elem.attributeValue("defaultRowHeight") != null) {
                    SheetReader.this.defaultRowHeight = (int)(Double.parseDouble(elem.attributeValue("defaultRowHeight")) * 1.3333333730697632);
                    SheetReader.this.sheet.setDefaultRowHeight(SheetReader.this.defaultRowHeight);
                }
                if (elem.attributeValue("defaultColWidth") != null) {
                    SheetReader.this.defaultColWidth = (int)(Double.parseDouble(elem.attributeValue("defaultColWidth")) * 6.0 * 1.3333333730697632);
                    SheetReader.this.sheet.setDefaultColWidth(SheetReader.this.defaultColWidth);
                }
            } else if (name.equals("col")) {
                SheetReader.this.setColumnProperty(elem);
            } else if (name.equals("row")) {
                int rowIndex = Integer.parseInt(elem.attributeValue("r")) - 1;
                if (SheetReader.this.sheet.getRow(rowIndex) == null) {
                    SheetReader.this.sheet.addRow(SheetReader.this.createRow(elem, SheetReader.this.defaultRowHeight));
                } else {
                    SheetReader.this.modifyRow(SheetReader.this.sheet.getRow(rowIndex), elem, SheetReader.this.defaultRowHeight);
                }
            } else if (name.equals("c")) {
                String ref = elem.attributeValue("r");
                int rowIndex = ReferenceUtil.instance().getRowIndex(ref);
                int colIndex = ReferenceUtil.instance().getColumnIndex(ref);
                Row row = SheetReader.this.sheet.getRow(rowIndex);
                Cell cell = null;
                if (row != null) {
                    cell = row.getCell(colIndex, false);
                } else {
                    row = new Row(colIndex);
                    row.setRowNumber(rowIndex);
                    row.setSheet(SheetReader.this.sheet);
                    SheetReader.this.sheet.addRow(row);
                }
                if (cell == null) {
                    cell = CellReader.instance().getCell(SheetReader.this.sheet, elem);
                }
                if (cell != null) {
                    cell.setSheet(SheetReader.this.sheet);
                    row.addCell(cell);
                }
            } else if (name.equals("mergeCell")) {
                SheetReader.this.getSheetMergerdCells(elem);
            }
            elem.detach();
        }
    }

    class XLSXSearchSaxHandler
    implements ElementHandler {
        XLSXSearchSaxHandler() {
        }

        @Override
        public void onStart(ElementPath elementPath) {
        }

        @Override
        public void onEnd(ElementPath elementPath) {
            if (SheetReader.this.iReader.isAborted()) {
                throw new AbortReaderError("abort Reader");
            }
            Element elem = elementPath.getCurrent();
            String name = elem.getName();
            if (name.equals("c") && CellReader.instance().searchContent(elem, SheetReader.this.key)) {
                SheetReader.this.searched = true;
            }
            elem.detach();
            if (SheetReader.this.searched) {
                throw new StopReaderError("stop");
            }
        }
    }
}

