/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.ss.util.cellwalk;

import com.ahmadullahpk.alldocumentreader.xs.fc.ss.usermodel.ICell;
import com.ahmadullahpk.alldocumentreader.xs.fc.ss.usermodel.Sheet;
import com.ahmadullahpk.alldocumentreader.xs.fc.ss.util.DataMarker;
import com.ahmadullahpk.alldocumentreader.xs.fc.ss.util.HSSFCellRangeAddress;
import com.ahmadullahpk.alldocumentreader.xs.fc.ss.util.cellwalk.CellHandler;
import com.ahmadullahpk.alldocumentreader.xs.fc.ss.util.cellwalk.CellWalkContext;

public class CellWalk {
    private Sheet sheet;
    private HSSFCellRangeAddress range;
    private boolean traverseEmptyCells;

    public CellWalk(DataMarker dm) {
        this(dm.getSheet(), dm.getRange());
    }

    public CellWalk(Sheet sheet, HSSFCellRangeAddress range) {
        this.sheet = sheet;
        this.range = range;
        this.traverseEmptyCells = false;
    }

    public boolean isTraverseEmptyCells() {
        return this.traverseEmptyCells;
    }

    public void setTraverseEmptyCells(boolean traverseEmptyCells) {
        this.traverseEmptyCells = traverseEmptyCells;
    }

    public void traverse(CellHandler handler) {
        int firstRow = this.range.getFirstRow();
        int lastRow = this.range.getLastRow();
        int firstColumn = this.range.getFirstColumn();
        int lastColumn = this.range.getLastColumn();
        int width = lastColumn - firstColumn + 1;
        SimpleCellWalkContext ctx = new SimpleCellWalkContext();
        Object currentRow = null;
        Object currentCell = null;
    }

    private boolean isEmpty(ICell cell) {
        return cell.getCellType() == 3;
    }

    private class SimpleCellWalkContext
    implements CellWalkContext {
        public long ordinalNumber = 0L;
        public int rowNumber = 0;
        public int colNumber = 0;

        private SimpleCellWalkContext() {
        }

        @Override
        public long getOrdinalNumber() {
            return this.ordinalNumber;
        }

        @Override
        public int getRowNumber() {
            return this.rowNumber;
        }

        @Override
        public int getColumnNumber() {
            return this.colNumber;
        }
    }
}

