/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.ppt.reader;

import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.Document;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.Element;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.io.SAXReader;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.PackagePart;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.PackageRelationship;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.PackageRelationshipCollection;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.ZipPackage;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.drawing.AnchorPoint;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.drawing.CellAnchor;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PictureReader {
    private static PictureReader picReader = new PictureReader();
    private PackagePart vmlDrawingPart;
    private Map<String, String> spIDs;
    private Map<String, CellAnchor> spIDAnchors;

    public static PictureReader instance() {
        return picReader;
    }

    public PackagePart getOLEPart(ZipPackage zipPackage, PackagePart packagePart, String spid, Boolean bExcel) throws Exception {
        PackageRelationship imageShip;
        String id2;
        if (this.vmlDrawingPart == null) {
            PackageRelationshipCollection ships = packagePart.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/vmlDrawing");
            for (PackageRelationship oleShip : ships) {
                this.vmlDrawingPart = zipPackage.getPart(oleShip.getTargetURI());
                this.getShapeIds(bExcel);
            }
        }
        if (this.spIDs != null && (id2 = this.spIDs.get(spid)) != null && (imageShip = this.vmlDrawingPart.getRelationship(id2)) != null) {
            return zipPackage.getPart(imageShip.getTargetURI());
        }
        return null;
    }

    private void getShapeIds(Boolean bExcel) throws Exception {
        if (this.vmlDrawingPart != null) {
            SAXReader saxreader = new SAXReader();
            InputStream in = this.vmlDrawingPart.getInputStream();
            Document poiVml = saxreader.read(in);
            Element root = poiVml.getRootElement();
            if (root != null) {
                if (this.spIDs == null) {
                    this.spIDs = new Hashtable<String, String>();
                }
                if (bExcel.booleanValue() && this.spIDAnchors == null) {
                    this.spIDAnchors = new Hashtable<String, CellAnchor>();
                }
                List shapes = root.elements("shape");
                for (Element shape : shapes) {
                    Element imagedata = shape.element("imagedata");
                    if (imagedata == null) continue;
                    String val = shape.attributeValue("spid");
                    if (bExcel.booleanValue()) {
                        String[] values;
                        String text;
                        Element anchor;
                        if (val == null) {
                            val = shape.attributeValue("id");
                        }
                        if (val == null || val.length() <= 8) {
                            return;
                        }
                        val = val.substring(8);
                        this.spIDs.put(val, imagedata.attributeValue("relid"));
                        Element clientData = shape.element("ClientData");
                        if (clientData == null || (anchor = clientData.element("Anchor")) == null || (text = anchor.getText()) == null || text.length() <= 0 || (values = (text = text.trim().replaceAll(" ", "")).split(",")) == null || values.length != 8) continue;
                        AnchorPoint anchorFrom = new AnchorPoint();
                        anchorFrom.setColumn((short)Integer.parseInt(values[0]));
                        anchorFrom.setDX((short)Integer.parseInt(values[1]));
                        anchorFrom.setRow((short)Integer.parseInt(values[2]));
                        anchorFrom.setDY((short)Integer.parseInt(values[3]));
                        AnchorPoint anchorTo = new AnchorPoint();
                        anchorTo.setColumn((short)Integer.parseInt(values[4]));
                        anchorTo.setDX((short)Integer.parseInt(values[5]));
                        anchorTo.setRow((short)Integer.parseInt(values[6]));
                        anchorTo.setDY((short)Integer.parseInt(values[7]));
                        CellAnchor cellAnchor = new CellAnchor(1);
                        cellAnchor.setStart(anchorFrom);
                        cellAnchor.setEnd(anchorTo);
                        this.spIDAnchors.put(val, cellAnchor);
                        continue;
                    }
                    if (val != null && val.length() > 0) {
                        this.spIDs.put(val, imagedata.attributeValue("relid"));
                        continue;
                    }
                    this.spIDs.put(shape.attributeValue("id"), imagedata.attributeValue("relid"));
                }
            }
            in.close();
        }
    }

    public CellAnchor getExcelShapeAnchor(String shapeId) {
        if (shapeId != null && this.spIDAnchors != null && this.spIDAnchors.size() > 0) {
            return this.spIDAnchors.get(shapeId);
        }
        return null;
    }

    public void dispose() {
        this.vmlDrawingPart = null;
        if (this.spIDs != null) {
            this.spIDs.clear();
            this.spIDs = null;
        }
        if (this.spIDAnchors != null) {
            Iterator<String> iter = this.spIDAnchors.keySet().iterator();
            while (iter.hasNext()) {
                this.spIDAnchors.get(iter.next()).dispose();
            }
            this.spIDAnchors.clear();
            this.spIDAnchors = null;
        }
    }
}

