/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.ppt.reader;

import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.Document;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.Element;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.io.SAXReader;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.PackagePart;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.ZipPackage;
import com.ahmadullahpk.alldocumentreader.xs.fc.ppt.ShapeManage;
import com.ahmadullahpk.alldocumentreader.xs.fc.ppt.reader.BackgroundReader;
import com.ahmadullahpk.alldocumentreader.xs.fc.ppt.reader.ReaderKit;
import com.ahmadullahpk.alldocumentreader.xs.fc.ppt.reader.StyleReader;
import com.ahmadullahpk.alldocumentreader.xs.pg.model.PGLayout;
import com.ahmadullahpk.alldocumentreader.xs.pg.model.PGMaster;
import com.ahmadullahpk.alldocumentreader.xs.pg.model.PGModel;
import com.ahmadullahpk.alldocumentreader.xs.pg.model.PGPlaceholderUtil;
import com.ahmadullahpk.alldocumentreader.xs.pg.model.PGSlide;
import com.ahmadullahpk.alldocumentreader.xs.pg.model.PGStyle;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import java.io.InputStream;
import java.util.Iterator;

public class LayoutReader {
    private static LayoutReader layoutReader = new LayoutReader();
    private int style = 1001;

    public static LayoutReader instance() {
        return layoutReader;
    }

    public PGLayout getLayouts(IControl control, ZipPackage zipPackage, PackagePart layoutPart, PGModel pgModel, PGMaster pgMaster, PGStyle defaultStyle) throws Exception {
        SAXReader saxreader = new SAXReader();
        InputStream in = layoutPart.getInputStream();
        Document poiLayout = saxreader.read(in);
        Element layout2 = poiLayout.getRootElement();
        PGLayout pgLayout = null;
        if (layout2 != null) {
            Element spTree;
            Element cSld;
            String val;
            pgLayout = new PGLayout();
            if (layout2.attribute("showMasterSp") != null && (val = layout2.attributeValue("showMasterSp")) != null && val.length() > 0 && Integer.valueOf(val) == 0) {
                pgLayout.setAddShapes(false);
            }
            if ((cSld = layout2.element("cSld")) != null && (spTree = cSld.element("spTree")) != null) {
                this.processBackgroundAndFill(control, zipPackage, layoutPart, pgMaster, pgLayout, cSld);
                this.processTextStyle(control, layoutPart, pgMaster, pgLayout, spTree);
                PGSlide pgSlide = new PGSlide();
                pgSlide.setSlideType(1);
                Iterator it = spTree.elementIterator();
                while (it.hasNext()) {
                    ShapeManage.instance().processShape(control, zipPackage, layoutPart, null, pgMaster, pgLayout, defaultStyle, pgSlide, (byte)1, (Element)it.next(), null, 1.0f, 1.0f);
                }
                if (pgSlide.getShapeCount() > 0) {
                    pgLayout.setSlideMasterIndex(pgModel.appendSlideMaster(pgSlide));
                }
            }
        }
        in.close();
        return pgLayout;
    }

    private void processTextStyle(IControl control, PackagePart layoutPart, PGMaster pgMaster, PGLayout pgLayout, Element spTree) {
        Iterator it = spTree.elementIterator();
        while (it.hasNext()) {
            Element sp = (Element)it.next();
            String type = ReaderKit.instance().getPlaceholderType(sp);
            int idx = ReaderKit.instance().getPlaceholderIdx(sp);
            Element txBody = sp.element("txBody");
            if (txBody == null) continue;
            Element lstStyle = txBody.element("lstStyle");
            StyleReader.instance().setStyleIndex(this.style);
            if (!PGPlaceholderUtil.instance().isBody(type)) {
                pgLayout.setStyleByType(type, StyleReader.instance().getStyles(control, pgMaster, sp, lstStyle));
            } else if (idx > 0) {
                pgLayout.setStyleByIdx(idx, StyleReader.instance().getStyles(control, pgMaster, sp, lstStyle));
            }
            this.style = StyleReader.instance().getStyleIndex();
        }
    }

    private void processBackgroundAndFill(IControl control, ZipPackage zipPackage, PackagePart layoutPart, PGMaster pgMaster, PGLayout pgLayout, Element cSld) throws Exception {
        Element bg = cSld.element("bg");
        if (bg != null) {
            pgLayout.setBackgroundAndFill(BackgroundReader.instance().getBackground(control, zipPackage, layoutPart, pgMaster, bg));
        }
    }

    public void dispose() {
        this.style = 1001;
    }
}

