/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.ppt.bulletnumber;

import com.ahmadullahpk.alldocumentreader.xs.common.bulletnumber.ListKit;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.Element;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import java.util.HashMap;
import java.util.Map;

public class BulletNumberManage {
    private static BulletNumberManage kit;
    private Map<Integer, Integer> lvlFmt = new HashMap<Integer, Integer>();
    private Map<Integer, Integer> lvlStartAt = new HashMap<Integer, Integer>();
    private Map<Integer, Integer> lvlNum = new HashMap<Integer, Integer>();
    private Map<Integer, Integer> styleBulletIDs = new HashMap<Integer, Integer>();
    private Map<String, Integer> bulletIDs = new HashMap<String, Integer>();

    public static BulletNumberManage instance() {
        if (kit == null) {
            kit = new BulletNumberManage();
        }
        return kit;
    }

    public int getBulletID(int styleID) {
        Integer id2 = this.styleBulletIDs.get(styleID);
        if (id2 != null) {
            return id2;
        }
        return -1;
    }

    public int addBulletNumber(IControl control, int styleID, Element pPr) {
        Integer id2 = this.styleBulletIDs.get(styleID);
        if (id2 != null) {
            return id2;
        }
        String text = this.getBulletText(pPr);
        if (text != null) {
            id2 = this.bulletIDs.get(text);
            if (id2 != null) {
                if (styleID > 0) {
                    this.styleBulletIDs.put(styleID, id2);
                }
                return id2;
            }
            id2 = control.getSysKit().getPGBulletText().addBulletText(text);
            this.bulletIDs.put(text, id2);
            if (styleID > 0) {
                this.styleBulletIDs.put(styleID, id2);
            }
            return id2;
        }
        if (pPr != null && pPr.element("buNone") != null) {
            this.styleBulletIDs.put(styleID, -2);
        }
        return -1;
    }

    private String getBulletText(Element pPr) {
        if (pPr != null && pPr.element("buNone") == null) {
            Element temp;
            int lvl = 0;
            String val = null;
            if (pPr != null && pPr.attribute("lvl") != null && (val = pPr.attributeValue("lvl")) != null && val.length() > 0) {
                lvl = Integer.parseInt(val);
            }
            if ((temp = pPr.element("buAutoNum")) != null) {
                int startAt = 1;
                if (temp.attribute("startAt") != null && (val = temp.attributeValue("startAt")) != null && val.length() > 0) {
                    startAt = Integer.parseInt(val);
                }
                return this.getText(lvl, this.convertedNumberFormat(temp.attributeValue("type")), startAt);
            }
            temp = pPr.element("buBlip");
            if (temp != null) {
                if (temp.element("blip") != null && temp.element("blip").attributeValue("embed") != null) {
                    char c = 'l';
                    c = this.converterNumberChar(c);
                    Integer beforFmt = this.lvlFmt.get(lvl);
                    if (beforFmt == null || beforFmt != c) {
                        if (beforFmt != null && lvl == 0) {
                            this.lvlFmt.clear();
                            this.lvlStartAt.clear();
                            this.lvlNum.clear();
                        }
                        this.lvlFmt.put(lvl, Integer.valueOf(c));
                    }
                    return String.valueOf(c);
                }
            } else {
                temp = pPr.element("buChar");
                if (temp != null && temp.attribute("char") != null && (val = temp.attributeValue("char")) != null && val.length() > 0) {
                    char c = val.charAt(0);
                    c = this.converterNumberChar(c);
                    Integer beforFmt = this.lvlFmt.get(lvl);
                    if (beforFmt == null || beforFmt != c) {
                        if (beforFmt != null && lvl == 0) {
                            this.lvlFmt.clear();
                            this.lvlStartAt.clear();
                            this.lvlNum.clear();
                        }
                        this.lvlFmt.put(lvl, Integer.valueOf(c));
                    }
                    return String.valueOf(c);
                }
            }
        }
        return null;
    }

    private String getText(int lvl, int type, int start) {
        StringBuffer bulletBuffer = new StringBuffer();
        Integer beforType = this.lvlFmt.get(lvl);
        if (beforType == null || beforType != type) {
            if (beforType != null && lvl == 0) {
                this.lvlFmt.clear();
                this.lvlStartAt.clear();
                this.lvlNum.clear();
            }
            this.lvlFmt.put(lvl, type);
            this.lvlStartAt.put(lvl, start);
            this.lvlNum.put(lvl, start);
        } else {
            Integer beforStart = this.lvlStartAt.get(lvl);
            if (beforStart == null || beforStart != start) {
                this.lvlStartAt.put(lvl, start);
                this.lvlNum.put(lvl, start);
            } else {
                start = this.lvlNum.get(lvl) + 1;
                this.lvlNum.put(lvl, start);
            }
        }
        int numID = type;
        if (numID == 5) {
            numID = 0;
        } else if (numID == 6 || numID == 11) {
            numID = 0;
        } else if (numID == 7 || numID == 12) {
            numID = 1;
        } else if (numID == 8 || numID == 13) {
            numID = 2;
        } else if (numID == 9 || numID == 14) {
            numID = 3;
        } else if (numID == 10 || numID == 15) {
            numID = 4;
        }
        if (type >= 11 && type <= 15) {
            bulletBuffer.append("(");
        }
        bulletBuffer.append(ListKit.instance().getNumberStr(start, numID));
        if (type >= 6 && type <= 15) {
            bulletBuffer.append(")");
        } else if (type != 5) {
            bulletBuffer.append(".");
        }
        return bulletBuffer.toString();
    }

    public int addBulletNumber(IControl control, int lvl, int type, int start, char c) {
        String text = null;
        text = String.valueOf(this.converterNumberChar(c));
        Integer id2 = this.bulletIDs.get(text);
        if (id2 != null) {
            return id2;
        }
        id2 = control.getSysKit().getPGBulletText().addBulletText(text);
        this.bulletIDs.put(text, id2);
        return id2;
    }

    private int convertedNumberFormat(String numFormat) {
        if ("arabicPeriod".equalsIgnoreCase(numFormat)) {
            return 0;
        }
        if ("romanUcPeriod".equalsIgnoreCase(numFormat)) {
            return 1;
        }
        if ("romanLcPeriod".equalsIgnoreCase(numFormat)) {
            return 2;
        }
        if ("alphaUcPeriod".equalsIgnoreCase(numFormat)) {
            return 3;
        }
        if ("alphaLcPeriod".equalsIgnoreCase(numFormat)) {
            return 4;
        }
        if ("arabicPlain".equalsIgnoreCase(numFormat) || "circleNumDbPlain".equalsIgnoreCase(numFormat)) {
            return 5;
        }
        if ("arabicParenR".equalsIgnoreCase(numFormat)) {
            return 6;
        }
        if ("romanUcParenR".equalsIgnoreCase(numFormat)) {
            return 7;
        }
        if ("romanLcParenR".equalsIgnoreCase(numFormat)) {
            return 8;
        }
        if ("alphaUcParenR".equalsIgnoreCase(numFormat)) {
            return 9;
        }
        if ("alphaLcParenR".equalsIgnoreCase(numFormat)) {
            return 10;
        }
        if ("arabicParenBoth".equalsIgnoreCase(numFormat)) {
            return 11;
        }
        if ("romanUcParentBoth".equalsIgnoreCase(numFormat)) {
            return 12;
        }
        if ("romanLcParenBoth".equalsIgnoreCase(numFormat)) {
            return 13;
        }
        if ("alphaUcParenBoth".equalsIgnoreCase(numFormat)) {
            return 14;
        }
        if ("alphaLcParenBoth".equalsIgnoreCase(numFormat)) {
            return 15;
        }
        if ("ea1JpnChsDbPeriod".equalsIgnoreCase(numFormat)) {
            return 39;
        }
        return 0;
    }

    private int convertedNumberFormat(int type) {
        int fmt = 0;
        switch (type) {
            case 0: {
                fmt = 4;
                break;
            }
            case 1: {
                fmt = 3;
                break;
            }
            case 2: {
                fmt = 6;
                break;
            }
            case 3: {
                fmt = 0;
                break;
            }
            case 4: {
                fmt = 13;
                break;
            }
            case 5: {
                fmt = 8;
                break;
            }
            case 6: {
                fmt = 2;
                break;
            }
            case 7: {
                fmt = 1;
                break;
            }
            case 8: {
                fmt = 15;
                break;
            }
            case 9: {
                fmt = 10;
                break;
            }
            case 10: {
                fmt = 14;
                break;
            }
            case 11: {
                fmt = 9;
                break;
            }
            case 12: {
                fmt = 11;
                break;
            }
            case 13: 
            case 18: {
                fmt = 5;
                break;
            }
            case 14: {
                fmt = 12;
                break;
            }
            case 15: {
                fmt = 7;
                break;
            }
            case 38: {
                fmt = 39;
                break;
            }
            default: {
                fmt = 0;
            }
        }
        return fmt;
    }

    private char converterNumberChar(int c) {
        if (c == 8226 || c == 108 || c == 112) {
            c = 9679;
        } else if (c == 110 || c == 167) {
            c = 9632;
        } else if (c == 117) {
            c = 9670;
        } else if (c == 252) {
            c = 8730;
        } else if (c == 216) {
            c = 9733;
        } else if (c != 8211) {
            c = 9679;
        }
        return (char)c;
    }

    public void clearData() {
        if (this.lvlFmt != null) {
            this.lvlFmt.clear();
        }
        if (this.lvlStartAt != null) {
            this.lvlStartAt.clear();
        }
        if (this.lvlNum != null) {
            this.lvlNum.clear();
        }
    }

    public void dispose() {
        if (this.lvlFmt != null) {
            this.lvlFmt.clear();
            this.lvlFmt = null;
        }
        if (this.lvlStartAt != null) {
            this.lvlStartAt.clear();
            this.lvlStartAt = null;
        }
        if (this.lvlNum != null) {
            this.lvlNum.clear();
            this.lvlNum = null;
        }
        if (this.styleBulletIDs != null) {
            this.styleBulletIDs.clear();
            this.styleBulletIDs = null;
        }
        if (this.bulletIDs != null) {
            this.bulletIDs.clear();
            this.bulletIDs = null;
        }
        kit = null;
    }
}

