/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.poifs.storage;

import com.ahmadullahpk.alldocumentreader.xs.fc.poifs.common.POIFSBigBlockSize;
import com.ahmadullahpk.alldocumentreader.xs.fc.poifs.filesystem.BATManaged;
import com.ahmadullahpk.alldocumentreader.xs.fc.poifs.filesystem.POIFSDocument;
import com.ahmadullahpk.alldocumentreader.xs.fc.poifs.property.RootProperty;
import com.ahmadullahpk.alldocumentreader.xs.fc.poifs.storage.BlockAllocationTableWriter;
import com.ahmadullahpk.alldocumentreader.xs.fc.poifs.storage.BlockWritable;
import com.ahmadullahpk.alldocumentreader.xs.fc.poifs.storage.SmallDocumentBlock;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SmallBlockTableWriter
implements BlockWritable,
BATManaged {
    private BlockAllocationTableWriter _sbat;
    private List _small_blocks;
    private int _big_block_count;
    private RootProperty _root;

    public SmallBlockTableWriter(POIFSBigBlockSize bigBlockSize, List documents, RootProperty root) {
        this._sbat = new BlockAllocationTableWriter(bigBlockSize);
        this._small_blocks = new ArrayList();
        this._root = root;
        for (POIFSDocument doc : documents) {
            BlockWritable[] blocks = doc.getSmallBlocks();
            if (blocks.length != 0) {
                doc.setStartBlock(this._sbat.allocateSpace(blocks.length));
                for (int j = 0; j < blocks.length; ++j) {
                    this._small_blocks.add(blocks[j]);
                }
                continue;
            }
            doc.setStartBlock(-2);
        }
        this._sbat.simpleCreateBlocks();
        this._root.setSize(this._small_blocks.size());
        this._big_block_count = SmallDocumentBlock.fill(bigBlockSize, this._small_blocks);
    }

    public int getSBATBlockCount() {
        return (this._big_block_count + 15) / 16;
    }

    public BlockAllocationTableWriter getSBAT() {
        return this._sbat;
    }

    @Override
    public int countBlocks() {
        return this._big_block_count;
    }

    @Override
    public void setStartBlock(int start_block) {
        this._root.setStartBlock(start_block);
    }

    @Override
    public void writeBlocks(OutputStream stream) throws IOException {
        Iterator iter = this._small_blocks.iterator();
        while (iter.hasNext()) {
            ((BlockWritable)iter.next()).writeBlocks(stream);
        }
    }
}

