/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.poifs.filesystem;

import com.ahmadullahpk.alldocumentreader.xs.fc.poifs.filesystem.BlockStore;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;

public class NPOIFSStream
implements Iterable<ByteBuffer> {
    private BlockStore blockStore;
    private int startBlock;

    public NPOIFSStream(BlockStore blockStore, int startBlock) {
        this.blockStore = blockStore;
        this.startBlock = startBlock;
    }

    public NPOIFSStream(BlockStore blockStore) {
        this.blockStore = blockStore;
        this.startBlock = -2;
    }

    public int getStartBlock() {
        return this.startBlock;
    }

    @Override
    public Iterator<ByteBuffer> iterator() {
        return this.getBlockIterator();
    }

    public Iterator<ByteBuffer> getBlockIterator() {
        if (this.startBlock == -2) {
            throw new IllegalStateException("Can't read from a new stream before it has been written to");
        }
        return new StreamBlockByteBufferIterator(this.startBlock);
    }

    public void updateContents(byte[] contents) throws IOException {
        int blockSize = this.blockStore.getBlockStoreBlockSize();
        int blocks = (int)Math.ceil((double)contents.length / (double)blockSize);
        BlockStore.ChainLoopDetector loopDetector = this.blockStore.getChainLoopDetector();
        int prevBlock = -2;
        int nextBlock = this.startBlock;
        for (int i = 0; i < blocks; ++i) {
            int thisBlock = nextBlock;
            if (thisBlock == -2) {
                thisBlock = this.blockStore.getFreeBlock();
                loopDetector.claim(thisBlock);
                nextBlock = -2;
                if (prevBlock != -2) {
                    this.blockStore.setNextBlock(prevBlock, thisBlock);
                }
                this.blockStore.setNextBlock(thisBlock, -2);
                if (this.startBlock == -2) {
                    this.startBlock = thisBlock;
                }
            } else {
                loopDetector.claim(thisBlock);
                nextBlock = this.blockStore.getNextBlock(thisBlock);
            }
            ByteBuffer buffer = this.blockStore.createBlockIfNeeded(thisBlock);
            int startAt = i * blockSize;
            int endAt = Math.min(contents.length - startAt, blockSize);
            buffer.put(contents, startAt, endAt);
            prevBlock = thisBlock;
        }
        int lastBlock = prevBlock;
        NPOIFSStream toFree = new NPOIFSStream(this.blockStore, nextBlock);
        toFree.free(loopDetector);
        this.blockStore.setNextBlock(lastBlock, -2);
    }

    public void free() throws IOException {
        BlockStore.ChainLoopDetector loopDetector = this.blockStore.getChainLoopDetector();
        this.free(loopDetector);
    }

    private void free(BlockStore.ChainLoopDetector loopDetector) {
        int nextBlock = this.startBlock;
        while (nextBlock != -2) {
            int thisBlock = nextBlock;
            loopDetector.claim(thisBlock);
            nextBlock = this.blockStore.getNextBlock(thisBlock);
            this.blockStore.setNextBlock(thisBlock, -1);
        }
        this.startBlock = -2;
    }

    protected class StreamBlockByteBufferIterator
    implements Iterator<ByteBuffer> {
        private BlockStore.ChainLoopDetector loopDetector;
        private int nextBlock;

        protected StreamBlockByteBufferIterator(int firstBlock) {
            this.nextBlock = firstBlock;
            try {
                this.loopDetector = NPOIFSStream.this.blockStore.getChainLoopDetector();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextBlock != -2;
        }

        @Override
        public ByteBuffer next() {
            if (this.nextBlock == -2) {
                throw new IndexOutOfBoundsException("Can't read past the end of the stream");
            }
            try {
                this.loopDetector.claim(this.nextBlock);
                ByteBuffer data = NPOIFSStream.this.blockStore.getBlockAt(this.nextBlock);
                this.nextBlock = NPOIFSStream.this.blockStore.getNextBlock(this.nextBlock);
                return data;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

