/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.pdf;

import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.RectF;
import com.ahmadullahpk.alldocumentreader.xs.fc.pdf.PDFHyperlinkInfo;
import com.ahmadullahpk.alldocumentreader.xs.fc.pdf.PDFOutlineItem;

public class PDFLib {
    private static PDFLib lib = new PDFLib();
    private int currentPageIndex = -1;
    private int pageCount = -1;
    public float pageWidth;
    public float pageHeight;
    private boolean isDrawPDFFinished = true;

    public static PDFLib getPDFLib() {
        return lib;
    }

    public synchronized void openFileSync(String filename) throws Exception {
        if (PDFLib.openFile(filename) <= 0) {
            throw new Exception("Format error");
        }
        this.pageCount = -1;
        this.currentPageIndex = -1;
    }

    public int getPageCountSync() {
        if (this.pageCount < 0) {
            this.pageCount = PDFLib.getPageCount();
        }
        return this.pageCount;
    }

    private void showPageSync(int pageIndex) {
        if (this.pageCount == -1) {
            this.pageCount = PDFLib.getPageCount();
        }
        if (pageIndex > this.pageCount - 1) {
            pageIndex = this.pageCount - 1;
        } else if (pageIndex < 0) {
            pageIndex = 0;
        }
        if (this.currentPageIndex == pageIndex) {
            return;
        }
        this.currentPageIndex = pageIndex;
        PDFLib.showPage(pageIndex);
        this.pageWidth = PDFLib.getPageWidth();
        this.pageHeight = PDFLib.getPageHeight();
    }

    public Rect[] getAllPagesSize() {
        return PDFLib.getPagesSize();
    }

    public boolean isDrawPageSyncFinished() {
        return this.isDrawPDFFinished;
    }

    public synchronized void drawPageSync(Bitmap bitmap, int pageIndex, float pageWidth, float pageHeight, int paintX, int paintY, int paintWidth, int paintHeight, int drawObject) {
        this.isDrawPDFFinished = false;
        this.showPageSync(pageIndex);
        PDFLib.drawPage(bitmap, pageWidth, pageHeight, paintX, paintY, paintWidth, paintHeight);
        this.isDrawPDFFinished = true;
    }

    public synchronized int getHyperlinkCountSync(int pageIndex, float x, float y) {
        return PDFLib.getHyperlinkCount(pageIndex, x, y);
    }

    public synchronized PDFHyperlinkInfo[] getHyperlinkInfoSync(int pageIndex) {
        return PDFLib.getHyperlinkInfo(pageIndex);
    }

    public synchronized RectF[] searchContentSync(int pageIndex, String text) {
        this.showPageSync(pageIndex);
        return PDFLib.searchContent(text);
    }

    public synchronized boolean hasOutlineSync() {
        return PDFLib.hasOutline();
    }

    public synchronized PDFOutlineItem[] getOutlineSync() {
        return PDFLib.getOutline();
    }

    public synchronized boolean hasPasswordSync() {
        return PDFLib.hasPassword();
    }

    public synchronized boolean authenticatePasswordSync(String password) {
        return PDFLib.authenticatePassword(password);
    }

    public void setStopFlagSync(int flag) {
        PDFLib.setStopFlag(flag);
    }

    public int wmf2Jpg(String infilename, String outfilename, int width, int height) {
        return PDFLib.convertFile(infilename, outfilename, width, height);
    }

    public boolean convertToPNG(String in, String out, String picType) {
        if ("png".equalsIgnoreCase(picType) || "jpeg".equalsIgnoreCase(picType)) {
            return PDFLib.convertPicture2PNG(in, out, picType.toLowerCase()) != 0;
        }
        return false;
    }

    public synchronized void dispose() {
    }

    private static native int openFile(String var0);

    private static native int getPageCount();

    private static native Rect[] getPagesSize();

    private static native void showPage(int var0);

    private static native float getPageWidth();

    private static native float getPageHeight();

    private static native void drawPage(Bitmap var0, float var1, float var2, int var3, int var4, int var5, int var6);

    private static native RectF[] searchContent(String var0);

    private static native int getHyperlinkCount(int var0, float var1, float var2);

    private static native PDFHyperlinkInfo[] getHyperlinkInfo(int var0);

    private static native PDFOutlineItem[] getOutline();

    private static native boolean hasOutline();

    private static native boolean hasPassword();

    private static native boolean authenticatePassword(String var0);

    private static native int setStopFlag(int var0);

    private static native void destroy();

    private static native int convertFile(String var0, String var1, int var2, int var3);

    private static native int convertPicture2PNG(String var0, String var1, String var2);

    static {
        System.loadLibrary("wxiweiPDF");
    }
}

