/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc;

import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.Attribute;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.Element;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.ElementHandler;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.ElementPath;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.io.SAXReader;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.exceptions.InvalidFormatException;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.exceptions.InvalidOperationException;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.PackagePart;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.PackagePartName;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.PackageRelationship;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.PackagingURIHelper;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.TargetMode;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.ZipPackage;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.POILogFactory;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.POILogger;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;

public final class PackageRelationshipCollection
implements Iterable<PackageRelationship> {
    private static POILogger logger = POILogFactory.getLogger(PackageRelationshipCollection.class);
    private TreeMap<String, PackageRelationship> relationshipsByID = new TreeMap();
    private TreeMap<String, PackageRelationship> relationshipsByType = new TreeMap();
    private PackagePart relationshipPart;
    private PackagePart sourcePart;
    private PackagePartName partName;
    private ZipPackage container;
    boolean fCorePropertiesRelationship;

    PackageRelationshipCollection() {
    }

    public PackageRelationshipCollection(PackageRelationshipCollection coll, String filter) {
        this();
        for (PackageRelationship rel : coll.relationshipsByID.values()) {
            if (filter != null && !rel.getRelationshipType().equals(filter)) continue;
            this.addRelationship(rel);
        }
    }

    public PackageRelationshipCollection(ZipPackage container) throws InvalidFormatException {
        this(container, null);
    }

    public PackageRelationshipCollection(PackagePart part) throws InvalidFormatException {
        this(part._container, part);
    }

    public PackageRelationshipCollection(ZipPackage container, PackagePart part) throws InvalidFormatException {
        this();
        if (container == null) {
            throw new IllegalArgumentException("container");
        }
        if (part != null && part.isRelationshipPart()) {
            throw new IllegalArgumentException("part");
        }
        this.container = container;
        this.sourcePart = part;
        this.partName = PackageRelationshipCollection.getRelationshipPartName(part);
        if (container.containPart(this.partName)) {
            this.relationshipPart = container.getPart(this.partName);
            this.parseRelationshipsPart(this.relationshipPart);
        }
    }

    private static PackagePartName getRelationshipPartName(PackagePart part) throws InvalidOperationException {
        PackagePartName partName = part == null ? PackagingURIHelper.PACKAGE_ROOT_PART_NAME : part.getPartName();
        return PackagingURIHelper.getRelationshipPartName(partName);
    }

    public void addRelationship(PackageRelationship relPart) {
        this.relationshipsByID.put(relPart.getId(), relPart);
        this.relationshipsByType.put(relPart.getRelationshipType(), relPart);
    }

    public PackageRelationship addRelationship(URI targetUri, TargetMode targetMode, String relationshipType, String id2) {
        if (id2 == null) {
            int i = 0;
            while (this.relationshipsByID.get(id2 = "rId" + ++i) != null) {
            }
        }
        PackageRelationship rel = new PackageRelationship(this.container, this.sourcePart, targetUri, targetMode, relationshipType, id2);
        this.relationshipsByID.put(rel.getId(), rel);
        this.relationshipsByType.put(rel.getRelationshipType(), rel);
        return rel;
    }

    public void removeRelationship(String id2) {
        PackageRelationship rel;
        if (this.relationshipsByID != null && this.relationshipsByType != null && (rel = this.relationshipsByID.get(id2)) != null) {
            this.relationshipsByID.remove(rel.getId());
            this.relationshipsByType.values().remove(rel);
        }
    }

    public void removeRelationship(PackageRelationship rel) {
        if (rel == null) {
            throw new IllegalArgumentException("rel");
        }
        this.relationshipsByID.values().remove(rel);
        this.relationshipsByType.values().remove(rel);
    }

    public PackageRelationship getRelationship(int index) {
        if (index < 0 || index > this.relationshipsByID.values().size()) {
            throw new IllegalArgumentException("index");
        }
        PackageRelationship retRel = null;
        int i = 0;
        for (PackageRelationship rel : this.relationshipsByID.values()) {
            if (index != i++) continue;
            return rel;
        }
        return retRel;
    }

    public PackageRelationship getRelationshipByID(String id2) {
        return this.relationshipsByID.get(id2);
    }

    public int size() {
        return this.relationshipsByID.values().size();
    }

    private void parseRelationshipsPart(PackagePart relPart) throws InvalidFormatException {
        try {
            this.fCorePropertiesRelationship = false;
            SAXReader reader = new SAXReader();
            logger.log(POILogger.DEBUG, "Parsing relationship: " + relPart.getPartName());
            InputStream in = relPart.getInputStream();
            SaxHandler saxHandler = new SaxHandler();
            reader.addHandler("/Relationships/Relationship", saxHandler);
            reader.read(in);
            in.close();
        }
        catch (Exception e) {
            logger.log(POILogger.ERROR, e);
            throw new InvalidFormatException(e.getMessage());
        }
    }

    public PackageRelationshipCollection getRelationships(String typeFilter) {
        PackageRelationshipCollection coll = new PackageRelationshipCollection(this, typeFilter);
        return coll;
    }

    @Override
    public Iterator<PackageRelationship> iterator() {
        return this.relationshipsByID.values().iterator();
    }

    public Iterator<PackageRelationship> iterator(String typeFilter) {
        ArrayList<PackageRelationship> retArr = new ArrayList<PackageRelationship>();
        for (PackageRelationship rel : this.relationshipsByID.values()) {
            if (!rel.getRelationshipType().equals(typeFilter)) continue;
            retArr.add(rel);
        }
        return retArr.iterator();
    }

    public void clear() {
        this.relationshipsByID.clear();
        this.relationshipsByType.clear();
    }

    public String toString() {
        String str = this.relationshipsByID == null ? "relationshipsByID=null" : this.relationshipsByID.size() + " relationship(s) = [";
        str = this.relationshipPart != null && this.relationshipPart._partName != null ? str + "," + this.relationshipPart._partName : str + ",relationshipPart=null";
        str = this.sourcePart != null && this.sourcePart._partName != null ? str + "," + this.sourcePart._partName : str + ",sourcePart=null";
        str = this.partName != null ? str + "," + this.partName : str + ",uri=null)";
        return str + "]";
    }

    class SaxHandler
    implements ElementHandler {
        SaxHandler() {
        }

        @Override
        public void onStart(ElementPath elementPath) {
        }

        @Override
        public void onEnd(ElementPath elementPath) {
            Element element = elementPath.getCurrent();
            String name = element.getName();
            try {
                if (name.equals("Relationship")) {
                    String id2 = element.attribute("Id").getValue();
                    String type = element.attribute("Type").getValue();
                    if (type.equals("http://schemas.openxmlformats.org/package/2006/relationships/metadata/core-properties")) {
                        if (!PackageRelationshipCollection.this.fCorePropertiesRelationship) {
                            PackageRelationshipCollection.this.fCorePropertiesRelationship = true;
                        } else {
                            throw new InvalidFormatException("OPC Compliance error [M4.1]: there is more than one core properties relationship in the package !");
                        }
                    }
                    Attribute targetModeAttr = element.attribute("TargetMode");
                    TargetMode targetMode = TargetMode.INTERNAL;
                    if (targetModeAttr != null) {
                        targetMode = targetModeAttr.getValue().toLowerCase().equals("internal") ? TargetMode.INTERNAL : TargetMode.EXTERNAL;
                    }
                    String value = "";
                    try {
                        value = element.attribute("Target").getValue();
                        URI target = PackagingURIHelper.toURI(value);
                        PackageRelationshipCollection.this.addRelationship(target, targetMode, type, id2);
                    }
                    catch (URISyntaxException e) {
                        logger.log(POILogger.ERROR, (Object)("Cannot convert " + value + " in a valid relationship URI-> ignored"), e);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            element.detach();
        }
    }
}

