/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.usermodel;

import com.ahmadullahpk.alldocumentreader.xs.common.pictureefftect.PictureEffectInfo;
import com.ahmadullahpk.alldocumentreader.xs.common.pictureefftect.PictureEffectInfoFactory;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.DefaultEscherRecordFactory;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherBSERecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherBlipRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherContainerRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherMetafileBlip;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherOptRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherSimpleProperty;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherSpRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherTertiaryOptRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.EscherRecordHolder;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.FSPA;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.FSPATable;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.usermodel.HWPFShape;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.usermodel.HWPFShapeFactory;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.usermodel.OfficeDrawing;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.usermodel.OfficeDrawings;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class OfficeDrawingsImpl
implements OfficeDrawings {
    private final EscherRecordHolder _escherRecordHolder;
    private final FSPATable _fspaTable;
    private final byte[] _mainStream;

    public OfficeDrawingsImpl(FSPATable fspaTable, EscherRecordHolder escherRecordHolder, byte[] mainStream) {
        this._fspaTable = fspaTable;
        this._escherRecordHolder = escherRecordHolder;
        this._mainStream = mainStream;
    }

    public EscherBlipRecord getBitmapRecord(IControl control, int bitmapIndex) {
        List<? extends EscherContainerRecord> bContainers = this._escherRecordHolder.getBStoreContainers();
        if (bContainers == null || bContainers.size() != 1) {
            return null;
        }
        EscherContainerRecord bContainer = bContainers.get(0);
        List<EscherRecord> bitmapRecords = bContainer.getChildRecords();
        if (bitmapRecords.size() < bitmapIndex) {
            return null;
        }
        EscherRecord imageRecord = bitmapRecords.get(bitmapIndex - 1);
        if (imageRecord instanceof EscherBlipRecord) {
            return (EscherBlipRecord)imageRecord;
        }
        if (imageRecord instanceof EscherBSERecord) {
            DefaultEscherRecordFactory recordFactory;
            EscherRecord record;
            EscherBSERecord bseRecord = (EscherBSERecord)imageRecord;
            EscherBlipRecord blip = bseRecord.getBlipRecord();
            if (blip != null) {
                return blip;
            }
            if (bseRecord.getOffset() > 0 && (record = (recordFactory = new DefaultEscherRecordFactory()).createRecord(this._mainStream, bseRecord.getOffset())) instanceof EscherBlipRecord) {
                EscherBlipRecord blipRecord = (EscherBlipRecord)record;
                if (blipRecord instanceof EscherMetafileBlip) {
                    blipRecord.fillFields(this._mainStream, bseRecord.getOffset(), recordFactory);
                    blipRecord.setTempFilePath(control.getSysKit().getPictureManage().writeTempFile(blipRecord.getPicturedata()));
                } else {
                    int bytesAfterHeader = blipRecord.readHeader(this._mainStream, bseRecord.getOffset());
                    int pos = bseRecord.getOffset() + 8;
                    int skip = 17;
                    byte[] b = new byte[Math.min(64, bytesAfterHeader)];
                    System.arraycopy(this._mainStream, pos + skip, b, 0, b.length);
                    blipRecord.setPictureData(b);
                    blipRecord.setTempFilePath(control.getSysKit().getPictureManage().writeTempFile(this._mainStream, pos + skip, bytesAfterHeader - skip));
                }
                return blipRecord;
            }
        }
        return null;
    }

    private boolean findEscherShapeRecordContainer(EscherContainerRecord spContainer, int shapeId) {
        if (spContainer.getRecordId() == -4093) {
            Iterator<EscherRecord> iterator = spContainer.getChildRecords().iterator();
            if (iterator.hasNext()) {
                EscherRecord escherRecord = iterator.next();
                return this.findEscherShapeRecordContainer((EscherContainerRecord)escherRecord, shapeId);
            }
        } else {
            EscherSpRecord escherSpRecord = (EscherSpRecord)spContainer.getChildById((short)-4086);
            if (escherSpRecord != null && escherSpRecord.getShapeId() == shapeId) {
                return true;
            }
        }
        return false;
    }

    private EscherContainerRecord getEscherShapeRecordContainer(int shapeId) {
        for (EscherContainerRecord escherContainerRecord : this._escherRecordHolder.getSpContainers()) {
            EscherSpRecord escherSpRecord;
            if (!(escherContainerRecord.getRecordId() == -4093 ? this.findEscherShapeRecordContainer(escherContainerRecord, shapeId) : (escherSpRecord = (EscherSpRecord)escherContainerRecord.getChildById((short)-4086)) != null && escherSpRecord.getShapeId() == shapeId)) continue;
            return escherContainerRecord;
        }
        return null;
    }

    private OfficeDrawing getOfficeDrawing(FSPA fspa) {
        return new OfficeDrawingImpl(fspa, this);
    }

    @Override
    public OfficeDrawing getOfficeDrawingAt(int characterPosition) {
        FSPA fspa = this._fspaTable.getFspaFromCp(characterPosition);
        if (fspa == null) {
            return null;
        }
        return this.getOfficeDrawing(fspa);
    }

    @Override
    public Collection<OfficeDrawing> getOfficeDrawings() {
        ArrayList<OfficeDrawing> result = new ArrayList<OfficeDrawing>();
        for (FSPA fspa : this._fspaTable.getShapes()) {
            result.add(this.getOfficeDrawing(fspa));
        }
        return Collections.unmodifiableList(result);
    }

    private static class OfficeDrawingImpl
    implements OfficeDrawing {
        private FSPA fspa;
        private OfficeDrawingsImpl darwings;
        private EscherBlipRecord blipRecord;

        public OfficeDrawingImpl(FSPA fspa, OfficeDrawingsImpl drawings) {
            this.fspa = fspa;
            this.darwings = drawings;
        }

        @Override
        public byte getHorizontalPositioning() {
            return (byte)this.getTertiaryPropertyValue(911, 0);
        }

        @Override
        public byte getHorizontalRelative() {
            return (byte)this.getTertiaryPropertyValue(912, 2);
        }

        @Override
        public byte[] getPictureData(IControl control) {
            if (this.blipRecord != null) {
                return this.blipRecord.getPicturedata();
            }
            EscherContainerRecord shapeDescription = this.darwings.getEscherShapeRecordContainer(this.getShapeId());
            if (shapeDescription == null) {
                return null;
            }
            EscherOptRecord escherOptRecord = (EscherOptRecord)shapeDescription.getChildById((short)-4085);
            if (escherOptRecord == null) {
                return null;
            }
            EscherSimpleProperty escherProperty = (EscherSimpleProperty)escherOptRecord.lookup(260);
            if (escherProperty == null) {
                return null;
            }
            int bitmapIndex = escherProperty.getPropertyValue();
            this.blipRecord = this.darwings.getBitmapRecord(control, bitmapIndex);
            if (this.blipRecord == null) {
                return null;
            }
            return this.blipRecord.getPicturedata();
        }

        @Override
        public byte[] getPictureData(IControl control, int index) {
            if (index > 0) {
                this.blipRecord = this.darwings.getBitmapRecord(control, index);
                if (this.blipRecord != null) {
                    return this.blipRecord.getPicturedata();
                }
            }
            return null;
        }

        @Override
        public HWPFShape getAutoShape() {
            EscherContainerRecord spContainer = this.darwings.getEscherShapeRecordContainer(this.getShapeId());
            if (spContainer != null) {
                return HWPFShapeFactory.createShape(spContainer, null);
            }
            return null;
        }

        @Override
        public int getRectangleBottom() {
            return this.fspa.getYaBottom();
        }

        @Override
        public int getRectangleLeft() {
            return this.fspa.getXaLeft();
        }

        @Override
        public int getRectangleRight() {
            return this.fspa.getXaRight();
        }

        @Override
        public int getRectangleTop() {
            return this.fspa.getYaTop();
        }

        @Override
        public int getShapeId() {
            return this.fspa.getSpid();
        }

        @Override
        public int getWrap() {
            return this.fspa.getWr();
        }

        @Override
        public boolean isBelowText() {
            return this.fspa.isFBelowText();
        }

        @Override
        public boolean isAnchorLock() {
            return this.fspa.isFAnchorLock();
        }

        @Override
        public PictureEffectInfo getPictureEffectInfor() {
            EscherContainerRecord shapeDescription = this.darwings.getEscherShapeRecordContainer(this.getShapeId());
            if (shapeDescription == null) {
                return null;
            }
            EscherOptRecord optRecord = (EscherOptRecord)shapeDescription.getChildById((short)-4085);
            return PictureEffectInfoFactory.getPictureEffectInfor(optRecord);
        }

        private int getTertiaryPropertyValue(int propertyId, int defaultValue) {
            EscherContainerRecord shapeDescription = this.darwings.getEscherShapeRecordContainer(this.getShapeId());
            if (shapeDescription == null) {
                return defaultValue;
            }
            EscherTertiaryOptRecord escherTertiaryOptRecord = (EscherTertiaryOptRecord)shapeDescription.getChildById((short)-3806);
            if (escherTertiaryOptRecord == null) {
                return defaultValue;
            }
            EscherSimpleProperty escherProperty = (EscherSimpleProperty)escherTertiaryOptRecord.lookup(propertyId);
            if (escherProperty == null) {
                return defaultValue;
            }
            int value = escherProperty.getPropertyValue();
            return value;
        }

        @Override
        public byte getVerticalPositioning() {
            return (byte)this.getTertiaryPropertyValue(913, 0);
        }

        @Override
        public byte getVerticalRelativeElement() {
            return (byte)this.getTertiaryPropertyValue(914, 2);
        }

        @Override
        public String getTempFilePath(IControl control) {
            if (this.blipRecord == null) {
                this.getPictureData(control);
            }
            if (this.blipRecord != null) {
                return this.blipRecord.getTempFilePath();
            }
            return null;
        }

        public String toString() {
            return "OfficeDrawingImpl: " + this.fspa.toString();
        }
    }
}

