/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.usermodel;

import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.ListFormatOverride;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.POIListData;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.POIListLevel;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.StyleSheet;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.sprm.CharacterSprmCompressor;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.sprm.ParagraphSprmCompressor;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.usermodel.CharacterProperties;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.usermodel.ParagraphProperties;

public final class HWPFList {
    private POIListData _listData;
    private ListFormatOverride _override;
    private boolean _registered;
    private StyleSheet _styleSheet;

    public HWPFList(boolean numbered, StyleSheet styleSheet) {
        this._listData = new POIListData((int)(Math.random() * (double)System.currentTimeMillis()), numbered);
        this._override = new ListFormatOverride(this._listData.getLsid());
        this._styleSheet = styleSheet;
    }

    public void setLevelNumberProperties(int level, CharacterProperties chp) {
        POIListLevel listLevel = this._listData.getLevel(level);
        int styleIndex = this._listData.getLevelStyle(level);
        CharacterProperties base = this._styleSheet.getCharacterStyle(styleIndex);
        byte[] grpprl = CharacterSprmCompressor.compressCharacterProperty(chp, base);
        listLevel.setNumberProperties(grpprl);
    }

    public void setLevelParagraphProperties(int level, ParagraphProperties pap) {
        POIListLevel listLevel = this._listData.getLevel(level);
        int styleIndex = this._listData.getLevelStyle(level);
        ParagraphProperties base = this._styleSheet.getParagraphStyle(styleIndex);
        byte[] grpprl = ParagraphSprmCompressor.compressParagraphProperty(pap, base);
        listLevel.setLevelProperties(grpprl);
    }

    public void setLevelStyle(int level, int styleIndex) {
        this._listData.setLevelStyle(level, styleIndex);
    }

    public POIListData getListData() {
        return this._listData;
    }

    public ListFormatOverride getOverride() {
        return this._override;
    }
}

