/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.sprm;

import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.sprm.SprmIterator;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.sprm.SprmOperation;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.sprm.SprmUncompressor;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.usermodel.BorderCode;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.usermodel.DateAndTime;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.usermodel.DropCapSpecifier;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.usermodel.LineSpacingDescriptor;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.usermodel.ParagraphProperties;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.usermodel.ShadingDescriptor;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.Internal;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.LittleEndian;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.POILogFactory;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.POILogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

@Internal
public final class ParagraphSprmUncompressor
extends SprmUncompressor {
    private static final POILogger logger = POILogFactory.getLogger(ParagraphSprmUncompressor.class);

    public static ParagraphProperties uncompressPAP(ParagraphProperties parent, byte[] grpprl, int offset) {
        ParagraphProperties newProperties = null;
        try {
            newProperties = (ParagraphProperties)parent.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new RuntimeException("There is no way this exception should happen!!");
        }
        SprmIterator sprmIt = new SprmIterator(grpprl, offset);
        while (sprmIt.hasNext()) {
            SprmOperation sprm = sprmIt.next();
            if (sprm.getType() != 1) continue;
            try {
                ParagraphSprmUncompressor.unCompressPAPOperation(newProperties, sprm);
            }
            catch (Exception exc) {
                logger.log(POILogger.ERROR, (Object)("Unable to apply SPRM operation '" + sprm.getOperation() + "': "), exc);
            }
        }
        return newProperties;
    }

    static void unCompressPAPOperation(ParagraphProperties newPAP, SprmOperation sprm) {
        switch (sprm.getOperation()) {
            case 0: {
                newPAP.setIstd(sprm.getOperand());
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                if (newPAP.getIstd() > 9 && newPAP.getIstd() < 1) break;
                byte paramTmp = (byte)sprm.getOperand();
                newPAP.setIstd(newPAP.getIstd() + paramTmp);
                newPAP.setLvl((byte)(newPAP.getLvl() + paramTmp));
                if ((paramTmp >> 7 & 1) == 1) {
                    newPAP.setIstd(Math.max(newPAP.getIstd(), 1));
                    break;
                }
                newPAP.setIstd(Math.min(newPAP.getIstd(), 9));
                break;
            }
            case 3: {
                newPAP.setJc((byte)sprm.getOperand());
                break;
            }
            case 4: {
                newPAP.setFSideBySide(sprm.getOperand() != 0);
                break;
            }
            case 5: {
                newPAP.setFKeep(sprm.getOperand() != 0);
                break;
            }
            case 6: {
                newPAP.setFKeepFollow(sprm.getOperand() != 0);
                break;
            }
            case 7: {
                newPAP.setFPageBreakBefore(sprm.getOperand() != 0);
                break;
            }
            case 8: {
                newPAP.setBrcl((byte)sprm.getOperand());
                break;
            }
            case 9: {
                newPAP.setBrcp((byte)sprm.getOperand());
                break;
            }
            case 10: {
                newPAP.setIlvl((byte)sprm.getOperand());
                break;
            }
            case 11: {
                newPAP.setIlfo(sprm.getOperand());
                break;
            }
            case 12: {
                newPAP.setFNoLnn(sprm.getOperand() != 0);
                break;
            }
            case 13: {
                ParagraphSprmUncompressor.handleTabs(newPAP, sprm);
                break;
            }
            case 14: {
                newPAP.setDxaRight(sprm.getOperand());
                break;
            }
            case 15: {
                newPAP.setDxaLeft(sprm.getOperand());
                break;
            }
            case 16: {
                newPAP.setDxaLeft(newPAP.getDxaLeft() + sprm.getOperand());
                newPAP.setDxaLeft(Math.max(0, newPAP.getDxaLeft()));
                break;
            }
            case 17: {
                newPAP.setDxaLeft1(sprm.getOperand());
                break;
            }
            case 18: {
                newPAP.setLspd(new LineSpacingDescriptor(sprm.getGrpprl(), sprm.getGrpprlOffset()));
                break;
            }
            case 19: {
                newPAP.setDyaBefore(sprm.getOperand());
                break;
            }
            case 20: {
                newPAP.setDyaAfter(sprm.getOperand());
                break;
            }
            case 21: {
                break;
            }
            case 22: {
                newPAP.setFInTable(sprm.getOperand() != 0);
                break;
            }
            case 23: {
                newPAP.setFTtp(sprm.getOperand() != 0);
                break;
            }
            case 24: {
                newPAP.setDxaAbs(sprm.getOperand());
                break;
            }
            case 25: {
                newPAP.setDyaAbs(sprm.getOperand());
                break;
            }
            case 26: {
                newPAP.setDxaWidth(sprm.getOperand());
                break;
            }
            case 27: {
                byte param = (byte)sprm.getOperand();
                byte pcVert = (byte)((param & 0xC) >> 2);
                byte pcHorz = (byte)(param & 3);
                if (pcVert != 3) {
                    newPAP.setPcVert(pcVert);
                }
                if (pcHorz == 3) break;
                newPAP.setPcHorz(pcHorz);
                break;
            }
            case 28: {
                break;
            }
            case 29: {
                break;
            }
            case 30: {
                break;
            }
            case 31: {
                break;
            }
            case 32: {
                break;
            }
            case 33: {
                break;
            }
            case 34: {
                newPAP.setDxaFromText(sprm.getOperand());
                break;
            }
            case 35: {
                newPAP.setWr((byte)sprm.getOperand());
                break;
            }
            case 36: {
                newPAP.setBrcTop(new BorderCode(sprm.getGrpprl(), sprm.getGrpprlOffset()));
                break;
            }
            case 37: {
                newPAP.setBrcLeft(new BorderCode(sprm.getGrpprl(), sprm.getGrpprlOffset()));
                break;
            }
            case 38: {
                newPAP.setBrcBottom(new BorderCode(sprm.getGrpprl(), sprm.getGrpprlOffset()));
                break;
            }
            case 39: {
                newPAP.setBrcRight(new BorderCode(sprm.getGrpprl(), sprm.getGrpprlOffset()));
                break;
            }
            case 40: {
                newPAP.setBrcBetween(new BorderCode(sprm.getGrpprl(), sprm.getGrpprlOffset()));
                break;
            }
            case 41: {
                newPAP.setBrcBar(new BorderCode(sprm.getGrpprl(), sprm.getGrpprlOffset()));
                break;
            }
            case 42: {
                newPAP.setFNoAutoHyph(sprm.getOperand() != 0);
                break;
            }
            case 43: {
                newPAP.setDyaHeight(sprm.getOperand());
                break;
            }
            case 44: {
                newPAP.setDcs(new DropCapSpecifier((short)sprm.getOperand()));
                break;
            }
            case 45: {
                newPAP.setShd(new ShadingDescriptor((short)sprm.getOperand()));
                break;
            }
            case 46: {
                newPAP.setDyaFromText(sprm.getOperand());
                break;
            }
            case 47: {
                newPAP.setDxaFromText(sprm.getOperand());
                break;
            }
            case 48: {
                newPAP.setFLocked(sprm.getOperand() != 0);
                break;
            }
            case 49: {
                newPAP.setFWidowControl(sprm.getOperand() != 0);
                break;
            }
            case 50: {
                break;
            }
            case 51: {
                newPAP.setFKinsoku(sprm.getOperand() != 0);
                break;
            }
            case 52: {
                newPAP.setFWordWrap(sprm.getOperand() != 0);
                break;
            }
            case 53: {
                newPAP.setFOverflowPunct(sprm.getOperand() != 0);
                break;
            }
            case 54: {
                newPAP.setFTopLinePunct(sprm.getOperand() != 0);
                break;
            }
            case 55: {
                newPAP.setFAutoSpaceDE(sprm.getOperand() != 0);
                break;
            }
            case 56: {
                newPAP.setFAutoSpaceDN(sprm.getOperand() != 0);
                break;
            }
            case 57: {
                newPAP.setWAlignFont(sprm.getOperand());
                break;
            }
            case 58: {
                newPAP.setFontAlign((short)sprm.getOperand());
                break;
            }
            case 59: {
                break;
            }
            case 62: {
                byte[] buf = new byte[sprm.size() - 3];
                System.arraycopy(buf, 0, sprm.getGrpprl(), sprm.getGrpprlOffset(), buf.length);
                newPAP.setAnld(buf);
                break;
            }
            case 63: {
                try {
                    byte[] varParam = sprm.getGrpprl();
                    int offset = sprm.getGrpprlOffset();
                    newPAP.setFPropRMark(varParam[offset] != 0);
                    newPAP.setIbstPropRMark(LittleEndian.getShort(varParam, offset + 1));
                    newPAP.setDttmPropRMark(new DateAndTime(varParam, offset + 3));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 64: {
                newPAP.setLvl((byte)sprm.getOperand());
                break;
            }
            case 65: {
                newPAP.setFBiDi(sprm.getOperand() != 0);
                break;
            }
            case 67: {
                newPAP.setFNumRMIns(sprm.getOperand() != 0);
                break;
            }
            case 68: {
                break;
            }
            case 69: {
                if (sprm.getSizeCode() != 6) break;
                byte[] buf = new byte[sprm.size() - 3];
                System.arraycopy(buf, 0, sprm.getGrpprl(), sprm.getGrpprlOffset(), buf.length);
                newPAP.setNumrm(buf);
                break;
            }
            case 71: {
                newPAP.setFUsePgsuSettings(sprm.getOperand() != 0);
                break;
            }
            case 72: {
                newPAP.setFAdjustRight(sprm.getOperand() != 0);
                break;
            }
            case 73: {
                newPAP.setItap(sprm.getOperand());
                break;
            }
            case 74: {
                newPAP.setItap((byte)(newPAP.getItap() + sprm.getOperand()));
                break;
            }
            case 75: {
                newPAP.setFInnerTableCell(sprm.getOperand() != 0);
                break;
            }
            case 76: {
                newPAP.setFTtpEmbedded(sprm.getOperand() != 0);
                break;
            }
            case 97: {
                newPAP.setJustificationLogical((byte)sprm.getOperand());
                break;
            }
        }
    }

    private static void handleTabs(ParagraphProperties pap, SprmOperation sprm) {
        int x;
        byte[] grpprl = sprm.getGrpprl();
        int offset = sprm.getGrpprlOffset();
        int delSize = grpprl[offset++];
        int[] tabPositions = pap.getRgdxaTab();
        byte[] tabDescriptors = pap.getRgtbd();
        HashMap<Integer, Byte> tabMap = new HashMap<Integer, Byte>();
        for (x = 0; x < tabPositions.length; ++x) {
            tabMap.put(tabPositions[x], tabDescriptors[x]);
        }
        for (x = 0; x < delSize; ++x) {
            short clearPosition = LittleEndian.getShort(grpprl, offset);
            tabMap.remove(clearPosition);
            pap.setTabClearPosition((short)Math.max(pap.getTabClearPosition(), clearPosition));
            offset += 2;
        }
        int addSize = grpprl[offset++];
        int start = offset;
        for (int x2 = 0; x2 < addSize; ++x2) {
            Integer key = LittleEndian.getShort(grpprl, offset);
            Byte val = grpprl[start + (2 * addSize + x2)];
            tabMap.put(key, val);
            offset += 2;
        }
        tabPositions = new int[tabMap.size()];
        tabDescriptors = new byte[tabPositions.length];
        ArrayList list = new ArrayList(tabMap.keySet());
        Collections.sort(list);
        for (int x3 = 0; x3 < tabPositions.length; ++x3) {
            Integer key = (Integer)list.get(x3);
            tabPositions[x3] = key;
            tabDescriptors[x3] = (Byte)tabMap.get(key);
        }
        pap.setRgdxaTab(tabPositions);
        pap.setRgtbd(tabDescriptors);
    }
}

