/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model;

import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.CharIndexTranslator;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.GenericPropertyNode;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.PieceDescriptor;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.PlexOfCps;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.TextPiece;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.io.HWPFOutputStream;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.Internal;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

@Internal
public class TextPieceTable
implements CharIndexTranslator {
    int _cpMin;
    protected ArrayList<TextPiece> _textPieces = new ArrayList();
    protected ArrayList<TextPiece> _textPiecesFCOrder = new ArrayList();

    public TextPieceTable() {
    }

    public TextPieceTable(byte[] documentStream, byte[] tableStream, int offset, int size, int fcMin) {
        int x;
        PlexOfCps pieceTable = new PlexOfCps(tableStream, offset, size, PieceDescriptor.getSizeInBytes());
        int length = pieceTable.length();
        PieceDescriptor[] pieces = new PieceDescriptor[length];
        for (x = 0; x < length; ++x) {
            GenericPropertyNode node = pieceTable.getProperty(x);
            pieces[x] = new PieceDescriptor(node.getBytes(), 0);
        }
        this._cpMin = pieces[0].getFilePosition() - fcMin;
        for (x = 0; x < pieces.length; ++x) {
            int start = pieces[x].getFilePosition() - fcMin;
            if (start >= this._cpMin) continue;
            this._cpMin = start;
        }
        for (x = 0; x < pieces.length; ++x) {
            int start = pieces[x].getFilePosition();
            GenericPropertyNode node = pieceTable.getProperty(x);
            int nodeStartChars = node.getStart();
            int nodeEndChars = node.getEnd();
            int multiple = pieces[x].isUnicode() ? 2 : 1;
            int textSizeChars = nodeEndChars - nodeStartChars;
            int textSizeBytes = textSizeChars * multiple;
            this._textPieces.add(new TextPiece(nodeStartChars, nodeEndChars, documentStream, start, textSizeBytes, pieces[x]));
        }
        Collections.sort(this._textPieces);
        this._textPiecesFCOrder = new ArrayList<TextPiece>(this._textPieces);
        Collections.sort(this._textPiecesFCOrder, new FCComparator());
    }

    public void add(TextPiece piece) {
        this._textPieces.add(piece);
        this._textPiecesFCOrder.add(piece);
        Collections.sort(this._textPieces);
        Collections.sort(this._textPiecesFCOrder, new FCComparator());
    }

    public int adjustForInsert(int listIndex, int length) {
        int size = this._textPieces.size();
        TextPiece tp = this._textPieces.get(listIndex);
        tp.setEnd(tp.getEnd() + length);
        for (int x = listIndex + 1; x < size; ++x) {
            tp = this._textPieces.get(x);
            tp.setStart(tp.getStart() + length);
            tp.setEnd(tp.getEnd() + length);
        }
        return length;
    }

    public boolean equals(Object o) {
        TextPieceTable tpt = (TextPieceTable)o;
        int size = tpt._textPieces.size();
        if (size == this._textPieces.size()) {
            for (int x = 0; x < size; ++x) {
                if (tpt._textPieces.get(x).equals(this._textPieces.get(x))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int getByteIndex(int charPos) {
        int byteCount = 0;
        for (TextPiece tp : this._textPieces) {
            if (charPos >= tp.getEnd()) {
                byteCount = tp.getPieceDescriptor().getFilePosition() + (tp.getEnd() - tp.getStart()) * (tp.isUnicode() ? 2 : 1);
                if (charPos != tp.getEnd()) continue;
                break;
            }
            if (charPos >= tp.getEnd()) continue;
            int left = charPos - tp.getStart();
            byteCount = tp.getPieceDescriptor().getFilePosition() + left * (tp.isUnicode() ? 2 : 1);
            break;
        }
        return byteCount;
    }

    @Override
    public int getCharIndex(int bytePos) {
        return this.getCharIndex(bytePos, 0);
    }

    @Override
    public int getCharIndex(int startBytePos, int startCP) {
        int charCount = 0;
        int bytePos = this.lookIndexForward(startBytePos);
        for (TextPiece tp : this._textPieces) {
            int pieceStart = tp.getPieceDescriptor().getFilePosition();
            int bytesLength = tp.bytesLength();
            int pieceEnd = pieceStart + bytesLength;
            int toAdd = bytePos < pieceStart || bytePos > pieceEnd ? bytesLength : (bytePos > pieceStart && bytePos < pieceEnd ? bytePos - pieceStart : bytesLength - (pieceEnd - bytePos));
            charCount = tp.isUnicode() ? (charCount += toAdd / 2) : (charCount += toAdd);
            if (bytePos < pieceStart || bytePos > pieceEnd || charCount < startCP) continue;
            break;
        }
        return charCount;
    }

    public int getCpMin() {
        return this._cpMin;
    }

    public StringBuilder getText() {
        long start = System.currentTimeMillis();
        StringBuilder docText = new StringBuilder();
        for (TextPiece textPiece : this._textPieces) {
            String toAppend = textPiece.getStringBuilder().toString();
            int toAppendLength = toAppend.length();
            if (toAppendLength != textPiece.getEnd() - textPiece.getStart()) {
                // empty if block
            }
            docText.replace(textPiece.getStart(), textPiece.getStart() + toAppendLength, toAppend);
        }
        return docText;
    }

    public List<TextPiece> getTextPieces() {
        return this._textPieces;
    }

    public int hashCode() {
        return this._textPieces.size();
    }

    @Override
    public boolean isIndexInTable(int bytePos) {
        for (TextPiece tp : this._textPiecesFCOrder) {
            int pieceStart = tp.getPieceDescriptor().getFilePosition();
            if (bytePos > pieceStart + tp.bytesLength()) continue;
            return pieceStart <= bytePos;
        }
        return false;
    }

    boolean isIndexInTable(int startBytePos, int endBytePos) {
        for (TextPiece tp : this._textPiecesFCOrder) {
            int right;
            int pieceStart = tp.getPieceDescriptor().getFilePosition();
            if (startBytePos >= pieceStart + tp.bytesLength()) continue;
            int left = Math.max(startBytePos, pieceStart);
            return left < (right = Math.min(endBytePos, pieceStart + tp.bytesLength()));
        }
        return false;
    }

    @Override
    public int lookIndexBackward(int startBytePos) {
        int bytePos = startBytePos;
        int lastEnd = 0;
        for (TextPiece tp : this._textPiecesFCOrder) {
            int pieceStart = tp.getPieceDescriptor().getFilePosition();
            if (bytePos > pieceStart + tp.bytesLength()) {
                lastEnd = pieceStart + tp.bytesLength();
                continue;
            }
            if (pieceStart <= bytePos) break;
            bytePos = lastEnd;
            break;
        }
        return bytePos;
    }

    @Override
    public int lookIndexForward(int startBytePos) {
        int bytePos = startBytePos;
        for (TextPiece tp : this._textPiecesFCOrder) {
            int pieceStart = tp.getPieceDescriptor().getFilePosition();
            if (bytePos >= pieceStart + tp.bytesLength()) continue;
            if (pieceStart <= bytePos) break;
            bytePos = pieceStart;
            break;
        }
        return bytePos;
    }

    public byte[] writeTo(HWPFOutputStream docStream) throws IOException {
        PlexOfCps textPlex = new PlexOfCps(PieceDescriptor.getSizeInBytes());
        int size = this._textPieces.size();
        for (int x = 0; x < size; ++x) {
            TextPiece next = this._textPieces.get(x);
            PieceDescriptor pd = next.getPieceDescriptor();
            int offset = docStream.getOffset();
            int mod = offset % 512;
            if (mod != 0) {
                mod = 512 - mod;
                byte[] buf = new byte[mod];
                docStream.write(buf);
            }
            pd.setFilePosition(docStream.getOffset());
            docStream.write(next.getRawBytes());
            int nodeStart = next.getStart();
            int nodeEnd = next.getEnd();
            textPlex.addProperty(new GenericPropertyNode(nodeStart, nodeEnd, pd.toByteArray()));
        }
        return textPlex.toByteArray();
    }

    private static class FCComparator
    implements Comparator<TextPiece> {
        private FCComparator() {
        }

        @Override
        public int compare(TextPiece textPiece, TextPiece textPiece1) {
            if (textPiece.getPieceDescriptor().fc > textPiece1.getPieceDescriptor().fc) {
                return 1;
            }
            if (textPiece.getPieceDescriptor().fc < textPiece1.getPieceDescriptor().fc) {
                return -1;
            }
            return 0;
        }
    }
}

