/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model;

import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.DefaultEscherRecordFactory;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherBSERecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherBlipRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.HWPFDocument;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.EscherRecordHolder;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.FSPATable;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.usermodel.CharacterRun;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.usermodel.InlineWordArt;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.usermodel.Picture;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.usermodel.Range;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.Internal;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.LittleEndian;
import java.util.ArrayList;
import java.util.List;

@Internal
public final class PicturesTable {
    static final int TYPE_IMAGE = 8;
    static final int TYPE_IMAGE_WORD2000 = 0;
    static final int TYPE_IMAGE_PASTED_FROM_CLIPBOARD = 10;
    static final int TYPE_IMAGE_PASTED_FROM_CLIPBOARD_WORD2000 = 2;
    static final int TYPE_HORIZONTAL_LINE = 14;
    static final int BLOCK_TYPE_OFFSET = 14;
    static final int MM_MODE_TYPE_OFFSET = 6;
    private HWPFDocument _document;
    private byte[] _dataStream;
    private byte[] _mainStream;
    @Deprecated
    private FSPATable _fspa;
    @Deprecated
    private EscherRecordHolder _dgg;

    @Deprecated
    public PicturesTable(HWPFDocument _document, byte[] _dataStream, byte[] _mainStream, FSPATable fspa, EscherRecordHolder dgg) {
        this._document = _document;
        this._dataStream = _dataStream;
        this._mainStream = _mainStream;
        this._fspa = fspa;
        this._dgg = dgg;
    }

    public PicturesTable(HWPFDocument _document, byte[] _dataStream, byte[] _mainStream) {
        this._document = _document;
        this._dataStream = _dataStream;
        this._mainStream = _mainStream;
    }

    public boolean hasInlineWordArt(CharacterRun run) {
        if (run == null) {
            return false;
        }
        if (run.isSpecialCharacter() && !run.isObj() && !run.isOle2() && !run.isData() && ("\u0001".equals(run.text()) || "\u0001\u0015".equals(run.text()))) {
            return this.isBlockContainsInlineWordArt(run.getPicOffset());
        }
        return false;
    }

    public boolean hasPicture(CharacterRun run) {
        if (run == null) {
            return false;
        }
        if (run.isSpecialCharacter() && !run.isObj() && !run.isOle2() && !run.isData() && ("\u0001".equals(run.text()) || "\u0001\u0015".equals(run.text()))) {
            return this.isBlockContainsImage(run.getPicOffset());
        }
        return false;
    }

    public boolean hasEscherPicture(CharacterRun run) {
        return run.isSpecialCharacter() && !run.isObj() && !run.isOle2() && !run.isData() && run.text().startsWith("\b");
    }

    public boolean hasHorizontalLine(CharacterRun run) {
        if (run.isSpecialCharacter() && "\u0001".equals(run.text())) {
            return this.isBlockContainsHorizontalLine(run.getPicOffset());
        }
        return false;
    }

    private boolean isPictureRecognized(short blockType, short mappingModeOfMETAFILEPICT) {
        return blockType == 8 || blockType == 10 || blockType == 0 && mappingModeOfMETAFILEPICT == 100 || blockType == 2 && mappingModeOfMETAFILEPICT == 100;
    }

    private boolean isInlineWordArtRecognized(short blockType, short mappingModeOfMETAFILEPICT) {
        return blockType == 6 && mappingModeOfMETAFILEPICT == 100;
    }

    private static short getBlockType(byte[] dataStream, int pictOffset) {
        return LittleEndian.getShort(dataStream, pictOffset + 14);
    }

    private static short getMmMode(byte[] dataStream, int pictOffset) {
        return LittleEndian.getShort(dataStream, pictOffset + 6);
    }

    public Picture extractPicture(String tempPath, CharacterRun run, boolean fillBytes) {
        if (this.hasPicture(run)) {
            try {
                return new Picture(tempPath, run.getPicOffset(), this._dataStream, fillBytes);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public InlineWordArt extracInlineWordArt(CharacterRun run) {
        if (this.hasInlineWordArt(run)) {
            return new InlineWordArt(this._dataStream, run.getPicOffset());
        }
        return null;
    }

    private void searchForPictures(List<EscherRecord> escherRecords, List<Picture> pictures) {
        for (EscherRecord escherRecord : escherRecords) {
            if (escherRecord instanceof EscherBSERecord) {
                DefaultEscherRecordFactory recordFactory;
                EscherRecord record;
                EscherBSERecord bse = (EscherBSERecord)escherRecord;
                EscherBlipRecord blip = bse.getBlipRecord();
                if (blip != null) {
                    pictures.add(new Picture(blip.getPicturedata()));
                } else if (bse.getOffset() > 0 && (record = (recordFactory = new DefaultEscherRecordFactory()).createRecord(this._mainStream, bse.getOffset())) instanceof EscherBlipRecord) {
                    record.fillFields(this._mainStream, bse.getOffset(), recordFactory);
                    blip = (EscherBlipRecord)record;
                    pictures.add(new Picture(blip.getPicturedata()));
                }
            }
            this.searchForPictures(escherRecord.getChildRecords(), pictures);
        }
    }

    public List<Picture> getAllPictures(String tempPath) {
        ArrayList<Picture> pictures = new ArrayList<Picture>();
        Range range = this._document.getOverallRange();
        for (int i = 0; i < range.numCharacterRuns(); ++i) {
            Picture picture;
            CharacterRun run = range.getCharacterRun(i);
            if (run == null || (picture = this.extractPicture(tempPath, run, false)) == null) continue;
            pictures.add(picture);
        }
        this.searchForPictures(this._dgg.getEscherRecords(), pictures);
        return pictures;
    }

    private boolean isBlockContainsImage(int i) {
        return this.isPictureRecognized(PicturesTable.getBlockType(this._dataStream, i), PicturesTable.getMmMode(this._dataStream, i));
    }

    private boolean isBlockContainsHorizontalLine(int i) {
        return PicturesTable.getBlockType(this._dataStream, i) == 14 && PicturesTable.getMmMode(this._dataStream, i) == 100;
    }

    private boolean isBlockContainsInlineWordArt(int i) {
        return this.isInlineWordArtRecognized(PicturesTable.getBlockType(this._dataStream, i), PicturesTable.getMmMode(this._dataStream, i));
    }
}

