/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel;

import com.ahmadullahpk.alldocumentreader.xs.fc.ShapeKit;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherContainerRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFAnchor;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFRichTextString;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFShape;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFSimpleShape;
import com.ahmadullahpk.alldocumentreader.xs.fc.ss.usermodel.RichTextString;

public class HSSFTextbox
extends HSSFSimpleShape {
    public static final short OBJECT_TYPE_TEXT = 6;
    public static final short HORIZONTAL_ALIGNMENT_LEFT = 1;
    public static final short HORIZONTAL_ALIGNMENT_CENTERED = 2;
    public static final short HORIZONTAL_ALIGNMENT_RIGHT = 3;
    public static final short HORIZONTAL_ALIGNMENT_JUSTIFIED = 4;
    public static final short HORIZONTAL_ALIGNMENT_DISTRIBUTED = 7;
    public static final short VERTICAL_ALIGNMENT_TOP = 1;
    public static final short VERTICAL_ALIGNMENT_CENTER = 2;
    public static final short VERTICAL_ALIGNMENT_BOTTOM = 3;
    public static final short VERTICAL_ALIGNMENT_JUSTIFY = 4;
    public static final short VERTICAL_ALIGNMENT_DISTRIBUTED = 7;
    HSSFRichTextString string = new HSSFRichTextString("");
    private int marginLeft;
    private int marginRight;
    private int marginTop;
    private int marginBottom;
    private short halign;
    private short valign;
    private boolean isWrapLine;
    private boolean isWordArt;
    private int fontColor;

    public HSSFTextbox(EscherContainerRecord escherContainer, HSSFShape parent, HSSFAnchor anchor) {
        super(escherContainer, parent, anchor);
        this.setShapeType(6);
        this.halign = 1;
        this.valign = 1;
        this.marginLeft = Math.round(ShapeKit.getTextboxMarginLeft(escherContainer));
        this.marginTop = Math.round(ShapeKit.getTextboxMarginTop(escherContainer));
        this.marginRight = Math.round(ShapeKit.getTextboxMarginRight(escherContainer));
        this.marginBottom = Math.round(ShapeKit.getTextboxMarginBottom(escherContainer));
        this.isWrapLine = ShapeKit.isTextboxWrapLine(escherContainer);
    }

    public HSSFRichTextString getString() {
        return this.string;
    }

    public void setString(RichTextString string2) {
        HSSFRichTextString rtr = (HSSFRichTextString)string2;
        if (rtr.numFormattingRuns() == 0) {
            rtr.applyFont((short)0);
        }
        this.string = rtr;
    }

    public boolean isTextboxWrapLine() {
        return this.isWrapLine;
    }

    public int getMarginLeft() {
        return this.marginLeft;
    }

    public void setMarginLeft(int marginLeft) {
        this.marginLeft = marginLeft;
    }

    public int getMarginRight() {
        return this.marginRight;
    }

    public void setMarginRight(int marginRight) {
        this.marginRight = marginRight;
    }

    public int getMarginTop() {
        return this.marginTop;
    }

    public void setMarginTop(int marginTop) {
        this.marginTop = marginTop;
    }

    public int getMarginBottom() {
        return this.marginBottom;
    }

    public void setMarginBottom(int marginBottom) {
        this.marginBottom = marginBottom;
    }

    public short getHorizontalAlignment() {
        return this.halign;
    }

    public void setHorizontalAlignment(short align) {
        this.halign = align;
    }

    public short getVerticalAlignment() {
        return this.valign;
    }

    public void setVerticalAlignment(short align) {
        this.valign = align;
    }

    public boolean isWordArt() {
        return this.isWordArt;
    }

    public void setWordArt(boolean isWordArt) {
        this.isWordArt = isWordArt;
    }

    public void setFontColor(int fontColor) {
        this.fontColor = fontColor;
    }

    public int getFontColor() {
        return this.fontColor;
    }
}

