/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel;

import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.CFRuleRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.aggregates.CFRecordsAggregate;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.aggregates.ConditionalFormattingTable;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFConditionalFormatting;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFConditionalFormattingRule;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFSheet;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFWorkbook;
import com.ahmadullahpk.alldocumentreader.xs.fc.ss.SpreadsheetVersion;
import com.ahmadullahpk.alldocumentreader.xs.fc.ss.usermodel.ConditionalFormatting;
import com.ahmadullahpk.alldocumentreader.xs.fc.ss.usermodel.ConditionalFormattingRule;
import com.ahmadullahpk.alldocumentreader.xs.fc.ss.usermodel.SheetConditionalFormatting;
import com.ahmadullahpk.alldocumentreader.xs.fc.ss.util.HSSFCellRangeAddress;
import com.ahmadullahpk.alldocumentreader.xs.fc.ss.util.Region;

public final class HSSFSheetConditionalFormatting
implements SheetConditionalFormatting {
    private final HSSFSheet _sheet;
    private final ConditionalFormattingTable _conditionalFormattingTable;

    HSSFSheetConditionalFormatting(HSSFSheet sheet) {
        this._sheet = sheet;
        this._conditionalFormattingTable = sheet.getSheet().getConditionalFormattingTable();
    }

    @Override
    public HSSFConditionalFormattingRule createConditionalFormattingRule(byte comparisonOperation, String formula1, String formula2) {
        return null;
    }

    @Override
    public HSSFConditionalFormattingRule createConditionalFormattingRule(byte comparisonOperation, String formula1) {
        return null;
    }

    @Override
    public HSSFConditionalFormattingRule createConditionalFormattingRule(String formula) {
        HSSFWorkbook wb = this._sheet.getWorkbook();
        return null;
    }

    public int addConditionalFormatting(HSSFConditionalFormatting cf) {
        CFRecordsAggregate cfraClone = cf.getCFRecordsAggregate().cloneCFAggregate();
        return this._conditionalFormattingTable.add(cfraClone);
    }

    @Override
    public int addConditionalFormatting(ConditionalFormatting cf) {
        return this.addConditionalFormatting((HSSFConditionalFormatting)cf);
    }

    public int addConditionalFormatting(Region[] regions, HSSFConditionalFormattingRule[] cfRules) {
        return this.addConditionalFormatting(Region.convertRegionsToCellRanges(regions), cfRules);
    }

    public int addConditionalFormatting(HSSFCellRangeAddress[] regions, HSSFConditionalFormattingRule[] cfRules) {
        if (regions == null) {
            throw new IllegalArgumentException("regions must not be null");
        }
        for (HSSFCellRangeAddress range : regions) {
            range.validate(SpreadsheetVersion.EXCEL97);
        }
        if (cfRules == null) {
            throw new IllegalArgumentException("cfRules must not be null");
        }
        if (cfRules.length == 0) {
            throw new IllegalArgumentException("cfRules must not be empty");
        }
        if (cfRules.length > 3) {
            throw new IllegalArgumentException("Number of rules must not exceed 3");
        }
        CFRuleRecord[] rules = new CFRuleRecord[cfRules.length];
        for (int i = 0; i != cfRules.length; ++i) {
            rules[i] = cfRules[i].getCfRuleRecord();
        }
        CFRecordsAggregate cfra = new CFRecordsAggregate(regions, rules);
        return this._conditionalFormattingTable.add(cfra);
    }

    @Override
    public int addConditionalFormatting(HSSFCellRangeAddress[] regions, ConditionalFormattingRule[] cfRules) {
        HSSFConditionalFormattingRule[] hfRules;
        if (cfRules instanceof HSSFConditionalFormattingRule[]) {
            hfRules = (HSSFConditionalFormattingRule[])cfRules;
        } else {
            hfRules = new HSSFConditionalFormattingRule[cfRules.length];
            System.arraycopy(cfRules, 0, hfRules, 0, hfRules.length);
        }
        return this.addConditionalFormatting(regions, hfRules);
    }

    public int addConditionalFormatting(HSSFCellRangeAddress[] regions, HSSFConditionalFormattingRule rule1) {
        HSSFConditionalFormattingRule[] hSSFConditionalFormattingRuleArray;
        if (rule1 == null) {
            hSSFConditionalFormattingRuleArray = null;
        } else {
            HSSFConditionalFormattingRule[] hSSFConditionalFormattingRuleArray2 = new HSSFConditionalFormattingRule[1];
            hSSFConditionalFormattingRuleArray = hSSFConditionalFormattingRuleArray2;
            hSSFConditionalFormattingRuleArray2[0] = rule1;
        }
        return this.addConditionalFormatting(regions, hSSFConditionalFormattingRuleArray);
    }

    @Override
    public int addConditionalFormatting(HSSFCellRangeAddress[] regions, ConditionalFormattingRule rule1) {
        return this.addConditionalFormatting(regions, (HSSFConditionalFormattingRule)rule1);
    }

    public int addConditionalFormatting(HSSFCellRangeAddress[] regions, HSSFConditionalFormattingRule rule1, HSSFConditionalFormattingRule rule2) {
        return this.addConditionalFormatting(regions, new HSSFConditionalFormattingRule[]{rule1, rule2});
    }

    @Override
    public int addConditionalFormatting(HSSFCellRangeAddress[] regions, ConditionalFormattingRule rule1, ConditionalFormattingRule rule2) {
        return this.addConditionalFormatting(regions, (HSSFConditionalFormattingRule)rule1, (HSSFConditionalFormattingRule)rule2);
    }

    @Override
    public HSSFConditionalFormatting getConditionalFormattingAt(int index) {
        CFRecordsAggregate cf = this._conditionalFormattingTable.get(index);
        if (cf == null) {
            return null;
        }
        return new HSSFConditionalFormatting(this._sheet.getWorkbook(), cf);
    }

    @Override
    public int getNumConditionalFormattings() {
        return this._conditionalFormattingTable.size();
    }

    @Override
    public void removeConditionalFormatting(int index) {
        this._conditionalFormattingTable.remove(index);
    }
}

