/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel;

import com.ahmadullahpk.alldocumentreader.xs.common.bg.BackgroundAndFill;
import com.ahmadullahpk.alldocumentreader.xs.common.bg.Gradient;
import com.ahmadullahpk.alldocumentreader.xs.common.bg.LinearGradientShader;
import com.ahmadullahpk.alldocumentreader.xs.common.bg.RadialGradientShader;
import com.ahmadullahpk.alldocumentreader.xs.common.bg.TileShader;
import com.ahmadullahpk.alldocumentreader.xs.common.borders.Line;
import com.ahmadullahpk.alldocumentreader.xs.common.picture.Picture;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.Arrow;
import com.ahmadullahpk.alldocumentreader.xs.fc.ShapeKit;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherBSERecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherBlipRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherChildAnchorRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherClientAnchorRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherContainerRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherOptRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherSimpleProperty;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.model.InternalWorkbook;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFAnchor;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFChildAnchor;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFClientAnchor;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFPatriarch;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Color;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.XLSModel.AWorkbook;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;

public abstract class HSSFShape {
    final HSSFShape parent;
    HSSFPatriarch _patriarch;
    protected EscherContainerRecord escherContainer;
    private HSSFAnchor anchor;
    private int shapeType = 0;
    private boolean _noBorder = false;
    private int _lineStyleColor = 0x8000040;
    private int _lineWidth = 9525;
    private int _lineStyle = 0;
    private boolean _noFill = false;
    private int _fillType;
    private int _fillColor = 0x8000009;
    private byte[] bgPictureData;
    private int angle;
    private boolean flipH;
    private boolean flipV;
    private Arrow startArrow;
    private Arrow endArrow;

    HSSFShape(EscherContainerRecord escherContainer, HSSFShape parent, HSSFAnchor anchor) {
        this.escherContainer = escherContainer;
        this.parent = parent;
        this.anchor = anchor;
    }

    public boolean checkPatriarch() {
        for (HSSFShape topParent = this.parent; this._patriarch == null && topParent != null; topParent = topParent.getParent()) {
            this._patriarch = topParent._patriarch;
        }
        return this._patriarch != null;
    }

    public void processLineWidth() {
        this._lineWidth = ShapeKit.getLineWidth(this.escherContainer);
    }

    public HSSFShape getParent() {
        return this.parent;
    }

    public HSSFAnchor getAnchor() {
        return this.anchor;
    }

    public void setAnchor(HSSFAnchor anchor) {
        if (this.parent == null) {
            if (anchor instanceof HSSFChildAnchor) {
                throw new IllegalArgumentException("Must use client anchors for shapes directly attached to sheet.");
            }
        } else if (anchor instanceof HSSFClientAnchor) {
            throw new IllegalArgumentException("Must use child anchors for shapes attached to groups.");
        }
        this.anchor = anchor;
    }

    public boolean isNoBorder() {
        return this._noBorder;
    }

    public void setNoBorder(boolean noBorder) {
        this._noBorder = noBorder;
    }

    public int getLineStyleColor() {
        return this._lineStyleColor;
    }

    public void setLineStyleColor(int lineStyleColor) {
        this._lineStyleColor = lineStyleColor;
        this._lineStyleColor = 0xFFFFFF & this._lineStyleColor | 0xFF000000;
    }

    public void setLineStyleColor(int red, int green, int blue) {
        this._lineStyleColor = 0xFF000000 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | (blue & 0xFF) << 0;
    }

    public int getFillColor() {
        return this._fillColor;
    }

    public void setFillColor(int fillColor, int alpha) {
        this._fillColor = fillColor;
        this._fillColor = 0xFFFFFF & this._fillColor | alpha << 24;
    }

    public void setFillColor(int red, int green, int blue, int alpha) {
        this._fillColor = (alpha & 0xFF) << 24 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | (blue & 0xFF) << 0;
    }

    public int getLineWidth() {
        return this._lineWidth;
    }

    public void setLineWidth(int lineWidth) {
        this._lineWidth = lineWidth;
    }

    public int getLineStyle() {
        return this._lineStyle;
    }

    public void setLineStyle(int lineStyle) {
        this._lineStyle = lineStyle;
    }

    public boolean isNoFill() {
        return this._noFill;
    }

    public void setNoFill(boolean noFill) {
        this._noFill = noFill;
    }

    public int getFillType() {
        return this._fillType;
    }

    public void setFillType(int fillType) {
        this._fillType = fillType;
    }

    public byte[] getBGPictureData() {
        return this.bgPictureData;
    }

    public void setBGPictureData(byte[] bgPictureData) {
        this.bgPictureData = bgPictureData;
    }

    public int getShapeType() {
        return this.shapeType;
    }

    public void setShapeType(int shapeType) {
        this.shapeType = shapeType;
    }

    public int getRotation() {
        return this.angle;
    }

    public void setRotation(int angle) {
        this.angle = angle;
    }

    public boolean getFlipH() {
        return this.flipH;
    }

    public void setFilpH(boolean flipH) {
        this.flipH = flipH;
    }

    public boolean getFlipV() {
        return this.flipV;
    }

    public void setFlipV(boolean flipV) {
        this.flipV = flipV;
    }

    public void setStartArrow(byte type, int width, int length) {
        this.startArrow = new Arrow(type, width, length);
    }

    public void setEndArrow(byte type, int width, int length) {
        this.endArrow = new Arrow(type, width, length);
    }

    public int getStartArrowType() {
        return this.startArrow.getType();
    }

    public int getStartArrowWidth() {
        return this.startArrow.getWidth();
    }

    public int getStartArrowLength() {
        return this.startArrow.getLength();
    }

    public int getEndArrowType() {
        return this.endArrow.getType();
    }

    public int getEndArrowWidth() {
        return this.endArrow.getWidth();
    }

    public int getEndArrowLength() {
        return this.endArrow.getLength();
    }

    public int countOfAllChildren() {
        return 1;
    }

    public static HSSFClientAnchor toClientAnchor(EscherClientAnchorRecord anchorRecord) {
        HSSFClientAnchor anchor = new HSSFClientAnchor();
        anchor.setAnchorType(anchorRecord.getFlag());
        anchor.setCol1(anchorRecord.getCol1());
        anchor.setCol2(anchorRecord.getCol2());
        anchor.setDx1(anchorRecord.getDx1());
        anchor.setDx2(anchorRecord.getDx2());
        anchor.setDy1(anchorRecord.getDy1());
        anchor.setDy2(anchorRecord.getDy2());
        anchor.setRow1(anchorRecord.getRow1());
        anchor.setRow2(anchorRecord.getRow2());
        return anchor;
    }

    public static HSSFChildAnchor toChildAnchor(EscherChildAnchorRecord anchorRecord) {
        HSSFChildAnchor anchor = new HSSFChildAnchor(anchorRecord.getDx1(), anchorRecord.getDy1(), anchorRecord.getDx2(), anchorRecord.getDy2());
        return anchor;
    }

    public void processSimpleBackground(EscherContainerRecord escherContainer, AWorkbook workbook) {
        EscherOptRecord opt = (EscherOptRecord)ShapeKit.getEscherChild(escherContainer, -4085);
        int type = ShapeKit.getFillType(escherContainer);
        if (type == 3) {
            EscherBlipRecord blipRecord;
            InternalWorkbook iwb;
            EscherBSERecord bseRecord;
            EscherSimpleProperty p4 = (EscherSimpleProperty)ShapeKit.getEscherProperty(opt, 390);
            if (p4 != null && (bseRecord = (iwb = workbook.getInternalWorkbook()).getBSERecord(p4.getPropertyValue())) != null && (blipRecord = bseRecord.getBlipRecord()) != null) {
                this.setFillType(3);
                this.setBGPictureData(blipRecord.getPicturedata());
                return;
            }
        } else if (type == 1) {
            Color color2 = ShapeKit.getFillbackColor(escherContainer, workbook, 1);
            if (color2 != null) {
                this.setFillType(0);
                this.setFillColor(color2.getRGB(), 255);
                return;
            }
        } else {
            if (this.isGradientTile()) {
                this.setFillType(type);
                return;
            }
            Color color3 = ShapeKit.getForegroundColor(escherContainer, workbook, 1);
            if (color3 != null) {
                this.setFillType(0);
                this.setFillColor(color3.getRGB(), 255);
                return;
            }
        }
        this.setNoFill(true);
    }

    public boolean isGradientTile() {
        int type = ShapeKit.getFillType(this.escherContainer);
        return type == 7 || type == 4 || type == 5 || type == 6 || type == 2;
    }

    public BackgroundAndFill getGradientTileBackground(AWorkbook workbook, IControl control) {
        BackgroundAndFill bgFill = null;
        int type = this.getFillType();
        if (type == 7 || type == 4 || type == 5 || type == 6) {
            bgFill = new BackgroundAndFill();
            int angle = ShapeKit.getFillAngle(this.escherContainer);
            switch (angle) {
                case -90: 
                case 0: {
                    angle += 90;
                    break;
                }
                case -45: {
                    angle = 135;
                    break;
                }
                case -135: {
                    angle = 45;
                }
            }
            int focus = ShapeKit.getFillFocus(this.escherContainer);
            Color fillColor = ShapeKit.getForegroundColor(this.escherContainer, workbook, 1);
            Color fillbackColor = ShapeKit.getFillbackColor(this.escherContainer, workbook, 1);
            int[] colors = null;
            float[] positions = null;
            if (ShapeKit.isShaderPreset(this.escherContainer)) {
                colors = ShapeKit.getShaderColors(this.escherContainer);
                positions = ShapeKit.getShaderPositions(this.escherContainer);
            }
            if (colors == null) {
                colors = new int[]{fillColor == null ? -1 : fillColor.getRGB(), fillbackColor == null ? -1 : fillbackColor.getRGB()};
            }
            if (positions == null) {
                positions = new float[]{0.0f, 1.0f};
            }
            Gradient gradient = null;
            if (type == 7) {
                gradient = new LinearGradientShader(angle, colors, positions);
            } else if (type == 4 || type == 5 || type == 6) {
                gradient = new RadialGradientShader(ShapeKit.getRadialGradientPositionType(this.escherContainer), colors, positions);
            }
            if (gradient != null) {
                gradient.setFocus(focus);
            }
            bgFill.setFillType((byte)type);
            bgFill.setShader(gradient);
        } else if (type == 2) {
            EscherBlipRecord blipRecord;
            InternalWorkbook iwb;
            EscherBSERecord bseRecord;
            bgFill = new BackgroundAndFill();
            EscherOptRecord opt = (EscherOptRecord)ShapeKit.getEscherChild(this.escherContainer, -4085);
            EscherSimpleProperty p4 = (EscherSimpleProperty)ShapeKit.getEscherProperty(opt, 390);
            if (p4 != null && (bseRecord = (iwb = workbook.getInternalWorkbook()).getBSERecord(p4.getPropertyValue())) != null && (blipRecord = bseRecord.getBlipRecord()) != null) {
                bgFill.setFillType((byte)2);
                Picture pic = new Picture();
                pic.setData(blipRecord.getPicturedata());
                control.getSysKit().getPictureManage().addPicture(pic);
                bgFill.setShader(new TileShader(pic, 0, 1.0f, 1.0f));
            }
        }
        return bgFill;
    }

    public Line getLine() {
        BackgroundAndFill lineFill = new BackgroundAndFill();
        lineFill.setForegroundColor(this._lineStyleColor);
        Line line = new Line();
        line.setBackgroundAndFill(lineFill);
        line.setLineWidth(this._lineWidth);
        line.setDash(this._lineStyle > 0);
        return line;
    }
}

