/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel;

import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherBSERecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherBlipRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherContainerRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherOptRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.model.InternalWorkbook;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFAnchor;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFClientAnchor;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFPictureData;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFShape;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFSimpleShape;
import com.ahmadullahpk.alldocumentreader.xs.fc.ss.usermodel.Picture;
import com.ahmadullahpk.alldocumentreader.xs.fc.ss.util.ImageUtils;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Dimension;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.XLSModel.AWorkbook;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.baseModel.Row;
import java.io.ByteArrayInputStream;

public final class HSSFPicture
extends HSSFSimpleShape
implements Picture {
    public static final int PICTURE_TYPE_EMF = 2;
    public static final int PICTURE_TYPE_WMF = 3;
    public static final int PICTURE_TYPE_PICT = 4;
    public static final int PICTURE_TYPE_JPEG = 5;
    public static final int PICTURE_TYPE_PNG = 6;
    public static final int PICTURE_TYPE_DIB = 7;
    private static final float PX_DEFAULT = 32.0f;
    private static final float PX_MODIFIED = 36.56f;
    private static final int PX_ROW = 15;
    private int _pictureIndex;
    private EscherOptRecord opt;

    public HSSFPicture(EscherContainerRecord escherContainer, HSSFShape parent, HSSFAnchor anchor) {
        super(escherContainer, parent, anchor);
        this.setShapeType(8);
    }

    public HSSFPicture(AWorkbook workbook, EscherContainerRecord escherContainer, HSSFShape parent, HSSFAnchor anchor, EscherOptRecord opt) {
        super(escherContainer, parent, anchor);
        this.setShapeType(8);
        this.opt = opt;
        this.processLineWidth();
        this.processLine(escherContainer, workbook);
        this.processSimpleBackground(escherContainer, workbook);
        this.processRotationAndFlip(escherContainer);
    }

    public int getPictureIndex() {
        return this._pictureIndex;
    }

    public void setPictureIndex(int pictureIndex) {
        this._pictureIndex = pictureIndex;
    }

    public EscherOptRecord getEscherOptRecord() {
        return this.opt;
    }

    @Override
    public void resize(double scale) {
        HSSFClientAnchor anchor = (HSSFClientAnchor)this.getAnchor();
        anchor.setAnchorType(2);
        HSSFClientAnchor pref = this.getPreferredSize(scale);
        int row2 = anchor.getRow1() + (pref.getRow2() - pref.getRow1());
        int col2 = anchor.getCol1() + (pref.getCol2() - pref.getCol1());
        anchor.setCol2((short)col2);
        anchor.setDx1(0);
        anchor.setDx2(pref.getDx2());
        anchor.setRow2(row2);
        anchor.setDy1(0);
        anchor.setDy2(pref.getDy2());
    }

    @Override
    public void resize() {
        this.resize(1.0);
    }

    @Override
    public HSSFClientAnchor getPreferredSize() {
        return this.getPreferredSize(1.0);
    }

    public HSSFClientAnchor getPreferredSize(double scale) {
        HSSFClientAnchor anchor = (HSSFClientAnchor)this.getAnchor();
        Dimension size = this.getImageDimension();
        double scaledWidth = size.getWidth() * scale;
        double scaledHeight = size.getHeight() * scale;
        float w = 0.0f;
        w += this.getColumnWidthInPixels(anchor.col1) * (1.0f - (float)anchor.dx1 / 1024.0f);
        short col2 = (short)(anchor.col1 + 1);
        int dx2 = 0;
        while ((double)w < scaledWidth) {
            short s = col2;
            col2 = (short)(col2 + 1);
            w += this.getColumnWidthInPixels(s);
        }
        if ((double)w > scaledWidth) {
            col2 = (short)(col2 - 1);
            double cw = this.getColumnWidthInPixels(col2);
            double delta = (double)w - scaledWidth;
            dx2 = (int)((cw - delta) / cw * 1024.0);
        }
        anchor.col2 = col2;
        anchor.dx2 = dx2;
        float h = 0.0f;
        h += (1.0f - (float)anchor.dy1 / 256.0f) * this.getRowHeightInPixels(anchor.row1);
        int row2 = anchor.row1 + 1;
        int dy2 = 0;
        while ((double)h < scaledHeight) {
            h += this.getRowHeightInPixels(row2++);
        }
        if ((double)h > scaledHeight) {
            double ch = this.getRowHeightInPixels(--row2);
            double delta = (double)h - scaledHeight;
            dy2 = (int)((ch - delta) / ch * 256.0);
        }
        anchor.row2 = row2;
        anchor.dy2 = dy2;
        return anchor;
    }

    private float getColumnWidthInPixels(int column) {
        if (this.checkPatriarch()) {
            return this._patriarch._sheet.getColumnPixelWidth(column);
        }
        return 0.0f;
    }

    private float getRowHeightInPixels(int i) {
        Row row;
        if (this.checkPatriarch() && (row = this._patriarch._sheet.getRow(i)) != null) {
            return row.getRowPixelHeight();
        }
        return 18.0f;
    }

    private float getPixelWidth(int column) {
        return 32.0f;
    }

    public Dimension getImageDimension() {
        if (this.checkPatriarch()) {
            EscherBSERecord bse = this._patriarch._sheet.getAWorkbook().getInternalWorkbook().getBSERecord(this._pictureIndex);
            byte[] data = bse.getBlipRecord().getPicturedata();
            byte type = bse.getBlipTypeWin32();
            return ImageUtils.getImageDimension(new ByteArrayInputStream(data), type);
        }
        return null;
    }

    @Override
    public HSSFPictureData getPictureData() {
        if (this.checkPatriarch() && this._pictureIndex > 0) {
            InternalWorkbook iwb = this._patriarch._sheet.getAWorkbook().getInternalWorkbook();
            EscherBlipRecord blipRecord = iwb.getBSERecord(this._pictureIndex).getBlipRecord();
            return new HSSFPictureData(blipRecord);
        }
        return null;
    }
}

