/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel;

import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.ExtendedFormatRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.FontRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.common.UnicodeString;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFCell;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFCellStyle;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFRichTextString;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFRow;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFSheet;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFWorkbook;
import com.ahmadullahpk.alldocumentreader.xs.fc.ss.usermodel.ICell;
import com.ahmadullahpk.alldocumentreader.xs.fc.ss.usermodel.IRow;
import java.util.HashSet;
import java.util.Iterator;

public class HSSFOptimiser {
    public static void optimiseFonts(HSSFWorkbook workbook) {
        int i;
        short[] newPos = new short[workbook.getWorkbook().getNumberOfFontRecords() + 1];
        boolean[] zapRecords = new boolean[newPos.length];
        for (int i2 = 0; i2 < newPos.length; ++i2) {
            newPos[i2] = (short)i2;
            zapRecords[i2] = false;
        }
        FontRecord[] frecs = new FontRecord[newPos.length];
        for (i = 0; i < newPos.length; ++i) {
            if (i == 4) continue;
            frecs[i] = workbook.getWorkbook().getFontRecordAt(i);
        }
        for (i = 5; i < newPos.length; ++i) {
            int earlierDuplicate = -1;
            for (int j = 0; j < i && earlierDuplicate == -1; ++j) {
                FontRecord frCheck;
                if (j == 4 || !(frCheck = workbook.getWorkbook().getFontRecordAt(j)).sameProperties(frecs[i])) continue;
                earlierDuplicate = j;
            }
            if (earlierDuplicate == -1) continue;
            newPos[i] = (short)earlierDuplicate;
            zapRecords[i] = true;
        }
        for (i = 5; i < newPos.length; ++i) {
            int preDeletePos;
            int newPosition = preDeletePos = newPos[i];
            for (int j = 0; j < preDeletePos; ++j) {
                if (!zapRecords[j]) continue;
                newPosition = (short)(newPosition - 1);
            }
            newPos[i] = newPosition;
        }
        for (i = 5; i < newPos.length; ++i) {
            if (!zapRecords[i]) continue;
            workbook.getWorkbook().removeFontRecord(frecs[i]);
        }
        workbook.resetFontCache();
        for (i = 0; i < workbook.getWorkbook().getNumExFormats(); ++i) {
            ExtendedFormatRecord xfr = workbook.getWorkbook().getExFormatAt(i);
            xfr.setFontIndex(newPos[xfr.getFontIndex()]);
        }
        HashSet<UnicodeString> doneUnicodeStrings = new HashSet<UnicodeString>();
        for (int sheetNum = 0; sheetNum < workbook.getNumberOfSheets(); ++sheetNum) {
            HSSFSheet s = workbook.getSheetAt(sheetNum);
            Iterator<IRow> rIt = s.rowIterator();
            while (rIt.hasNext()) {
                HSSFRow row = (HSSFRow)rIt.next();
                Iterator<ICell> cIt = row.cellIterator();
                while (cIt.hasNext()) {
                    HSSFRichTextString rtr;
                    UnicodeString u;
                    HSSFCell cell = (HSSFCell)cIt.next();
                    if (cell.getCellType() != 1 || doneUnicodeStrings.contains(u = (rtr = cell.getRichStringCellValue()).getRawUnicodeString())) continue;
                    for (short i3 = 5; i3 < newPos.length; i3 = (short)((short)(i3 + 1))) {
                        if (i3 == newPos[i3]) continue;
                        u.swapFontUse(i3, newPos[i3]);
                    }
                    doneUnicodeStrings.add(u);
                }
            }
        }
    }

    public static void optimiseCellStyles(HSSFWorkbook workbook) {
        int i;
        short[] newPos = new short[workbook.getWorkbook().getNumExFormats()];
        boolean[] zapRecords = new boolean[newPos.length];
        for (int i2 = 0; i2 < newPos.length; ++i2) {
            newPos[i2] = (short)i2;
            zapRecords[i2] = false;
        }
        ExtendedFormatRecord[] xfrs = new ExtendedFormatRecord[newPos.length];
        for (i = 0; i < newPos.length; ++i) {
            xfrs[i] = workbook.getWorkbook().getExFormatAt(i);
        }
        for (i = 21; i < newPos.length; ++i) {
            int earlierDuplicate = -1;
            for (int j = 0; j < i && earlierDuplicate == -1; ++j) {
                ExtendedFormatRecord xfCheck = workbook.getWorkbook().getExFormatAt(j);
                if (!xfCheck.equals(xfrs[i])) continue;
                earlierDuplicate = j;
            }
            if (earlierDuplicate == -1) continue;
            newPos[i] = (short)earlierDuplicate;
            zapRecords[i] = true;
        }
        for (i = 21; i < newPos.length; ++i) {
            int preDeletePos;
            int newPosition = preDeletePos = newPos[i];
            for (int j = 0; j < preDeletePos; ++j) {
                if (!zapRecords[j]) continue;
                newPosition = (short)(newPosition - 1);
            }
            newPos[i] = newPosition;
        }
        for (i = 21; i < newPos.length; ++i) {
            if (!zapRecords[i]) continue;
            workbook.getWorkbook().removeExFormatRecord(xfrs[i]);
        }
        for (int sheetNum = 0; sheetNum < workbook.getNumberOfSheets(); ++sheetNum) {
            HSSFSheet s = workbook.getSheetAt(sheetNum);
            Iterator<IRow> rIt = s.rowIterator();
            while (rIt.hasNext()) {
                HSSFRow row = (HSSFRow)rIt.next();
                Iterator<ICell> cIt = row.cellIterator();
                while (cIt.hasNext()) {
                    HSSFCell cell = (HSSFCell)cIt.next();
                    short oldXf = cell.getCellValueRecord().getXFIndex();
                    HSSFCellStyle newStyle = workbook.getCellStyleAt(newPos[oldXf]);
                    cell.setCellStyle(newStyle);
                }
            }
        }
    }
}

